---
generated_at: 2026-02-02 10:36:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-TaskManagerログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-list/task-manager-log-list.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /task-manager/:taskManagerId/log-list である | E-06 28行目 | ○ |
| C-02 | loadLogList()でログ一覧を取得 | E-01 68-78行目、E-03 57-61行目 | ○ |
| C-03 | /taskmanagers/{id}/logs APIを呼び出す | E-03 59行目 | ○ |
| C-04 | 表示項目にLog Name、Last Modified Time、Sizeがある | E-02 33-35行目 | ○ |
| C-05 | sortLastModifiedTimeFnとsortSizeFnでソート | E-01 46-48行目、E-02 34-35行目 | ○ |
| C-06 | バーチャルスクロール対応 | E-02 24-28行目 | ○ |
| C-07 | nzVirtualItemSize=36 | E-02 24行目 | ○ |
| C-08 | queryParamsHandling='preserve'でパラメータ保持 | E-02 43行目 | ○ |
| C-09 | logRouterFactoryでルーティングパス生成 | E-01 52行目、62-63行目 | ○ |
| C-10 | catchError(() => of([]))でエラーハンドリング | E-01 71行目 | ○ |
| C-11 | ChangeDetectionStrategy.OnPush適用 | E-01 39行目 | ○ |
| C-12 | humanizeDatePipeで日時フォーマット | E-01 23行目、E-02 47行目 | ○ |
| C-13 | 関連機能No.32 REST API | E-05 71行目 | ○ |
| C-14 | 関連機能No.24 タスク実行 | E-05 72行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目がHTMLテンプレートと一致しているか確認
- [ ] バーチャルスクロールの設定が正しいか確認
- [ ] 遷移先URLパターンが正しいか確認
