---
generated_at: 2026-02-02 10:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-TaskManagerログ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/log-detail/task-manager-log-detail.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/task-manager.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /task-manager/:taskManagerId/log-list/:logName である | E-06 29行目 | ○ |
| C-02 | loadLog()でログ内容を取得 | E-01 84-95行目、E-03 63-75行目 | ○ |
| C-03 | /taskmanagers/{id}/logs/{logName} APIを呼び出す | E-03 64行目 | ○ |
| C-04 | パンくずリストでLog Listへ戻る | E-02 18-28行目 | ○ |
| C-05 | AddonInlineComponentでツールバー表示 | E-01 23行目、E-02 29-35行目 | ○ |
| C-06 | nz-code-editorでログ表示 | E-02 38-43行目 | ○ |
| C-07 | reloadLog()でログ再取得 | E-01 84-95行目 | ○ |
| C-08 | toggleFullScreen()でフルスクリーン切替 | E-01 98-101行目 | ○ |
| C-09 | ホストバインディングでフルスクリーン制御 | E-01 39-41行目 | ○ |
| C-10 | AutoResizeDirective使用 | E-01 24行目、E-02 39行目 | ○ |
| C-11 | Cache-Control: no-cacheヘッダー | E-03 66行目 | ○ |
| C-12 | responseType: 'text'でテキスト取得 | E-03 66行目 | ○ |
| C-13 | ChangeDetectionStrategy.OnPush適用 | E-01 38行目 | ○ |
| C-14 | 関連機能No.32 REST API | E-05 73行目 | ○ |
| C-15 | 関連機能No.24 タスク実行 | E-05 74行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] パンくずリストのリンク先が正しいか確認
- [ ] エディタオプションの設定が正しいか確認
- [ ] ダウンロード機能が正しく動作するか確認
