---
generated_at: 2026-02-02 10:42:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-TaskManagerプロファイラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/profiler/task-manager-profiler.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/task-manager/profiler/task-manager-profiler.component.html`
- E-03: `flink-runtime-web/web-dashboard/src/app/services/task-manager.service.ts`
- E-04: `flink-runtime-web/web-dashboard/src/app/interfaces/job-profiler.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /task-manager/:taskManagerId/profiler である | E-06 31行目 | ○ |
| C-02 | loadProfilingList()でプロファイリング履歴を取得 | E-01 99-124行目、E-03 124-126行目 | ○ |
| C-03 | createProfilingInstance()でプロファイリングを作成 | E-01 79-97行目、E-03 128-134行目 | ○ |
| C-04 | POST /taskmanagers/{id}/profiler APIを呼び出す | E-03 130-133行目 | ○ |
| C-05 | 5つのプロファイリングモード（CPU/Lock/Wall-Clock/Allocation/ITIMER） | E-02 43-82行目 | ○ |
| C-06 | デフォルトモードはITIMER | E-01 66行目 | ○ |
| C-07 | デフォルトdurationは30秒 | E-01 65行目 | ○ |
| C-08 | 実行中チェックで警告メッセージ表示 | E-01 80-83行目 | ○ |
| C-09 | isEnabled=falseで警告アラート表示 | E-02 123-129行目 | ○ |
| C-10 | ボタンのdisabled制御 | E-02 92行目 | ○ |
| C-11 | 履歴テーブルに8列を表示 | E-02 139-148行目 | ○ |
| C-12 | humanizeWatermarkToDatetimePipeで日時変換 | E-01 24行目、E-02 153-154行目 | ○ |
| C-13 | downloadProfilingResult()で結果ダウンロード | E-01 127-145行目、E-03 136-148行目 | ○ |
| C-14 | StatusService.refresh$でポーリング | E-01 101行目 | ○ |
| C-15 | ChangeDetectionStrategy.OnPush適用 | E-01 43行目 | ○ |
| C-16 | 関連機能No.32 REST API | E-05 77行目 | ○ |
| C-17 | 関連機能No.57 メトリクスコア | E-05 78行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] プロファイリングモードの説明が正しいか確認
- [ ] 実行中チェックロジックが正しいか確認
- [ ] 設定依存の警告メッセージが正しいか確認
