---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-完了済みジョブ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/job/job.component.ts`（全体）
- E-02: `src/app/components/job-list/job-list.component.ts`（全体）
- E-03: `src/app/services/job.service.ts`（66-81行目）
- E-04: `src/app/interfaces/job-overview.ts`（全体）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行5）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行9-10）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/job/completed` | E-05, E-07 | ○ |
| C-02 | FINISHED/FAILED/CANCELEDをフィルタリング | E-03（76行目） | ○ |
| C-03 | completed=trueでフィルタリング | E-02（103行目） | ○ |
| C-04 | isCompleted判定はpath === 'completed' | E-01（75行目） | ○ |
| C-05 | 終了時刻でソート可能 | E-02（72行目） | ○ |
| C-06 | 同一コンポーネント構成（JobComponent + JobListComponent） | E-01, E-02 | ○ |
| C-07 | INITIALIZING状態チェック不要 | E-02（80-84行目）完了済みは常にcompleted=true | ○ |
| C-08 | ジョブクリックで詳細画面に遷移 | E-01（68-70行目） | ○ |
| C-09 | GET `/jobs/overview`でジョブ一覧取得 | E-03（67行目） | ○ |
| C-10 | StatusService.refresh$でデータ更新 | E-02（97-100行目） | ○ |
| C-11 | 機能No.32 REST APIが主機能 | E-06（行9） | ○ |
| C-12 | 機能No.23 ジョブ管理が補助機能 | E-06（行10） | ○ |
| C-13 | completed属性はサービス層で追加 | E-03（76行目） | ○ |
| C-14 | ChangeDetectionStrategy.OnPushを使用 | E-01（32行目）, E-02（49行目） | ○ |
| C-15 | JobBadgeComponentで状態を色分け表示 | E-02（imports配列） | ○ |
| C-16 | catchErrorでEMPTYを返却 | E-03（80行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み
- **備考**：No.3「実行中ジョブ一覧」と大部分のコードを共有しているため、そちらの確認も併せて行うと効率的

## 6) レビュアーチェックリスト（最小）
- [ ] 完了済みジョブの履歴保持期間がバックエンドで設定されているか確認
- [ ] 大量の完了ジョブがある場合のパフォーマンスを確認
- [ ] 終了時刻のソートがデフォルトで降順になっているか確認
