---
generated_at: 2026-02-02 10:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-実行中アプリケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts`
- E-02: `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts`
- E-03: `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.html`
- E-04: `flink-runtime-web/web-dashboard/src/app/services/application.service.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは /application/running である | E-06 65行目、E-07 41行目 | ○ |
| C-02 | loadApplications()でアプリケーション一覧を取得 | E-02 88-109行目、E-04 44-59行目 | ○ |
| C-03 | /applications/overview APIを呼び出す | E-04 45行目 | ○ |
| C-04 | completed=falseでフィルタリング | E-02 97行目 | ○ |
| C-05 | 表示項目にApplication Name、Start Time、Duration等がある | E-03 30-37行目 | ○ |
| C-06 | ソート関数が定義されている（sortApplicationNameFn等） | E-02 68-72行目 | ○ |
| C-07 | デフォルトソートは開始時刻降順 | E-02 104-105行目、E-03 31行目 | ○ |
| C-08 | navigateToApplication()で詳細画面へ遷移 | E-01 68-70行目、E-02 78-80行目 | ○ |
| C-09 | StatusService.refresh$でポーリング | E-02 91-93行目 | ○ |
| C-10 | JobsBadgeコンポーネントでジョブ状態表示 | E-02 38行目、E-03 51行目 | ○ |
| C-11 | ApplicationBadgeコンポーネントでステータス表示 | E-02 35行目、E-03 54行目 | ○ |
| C-12 | humanizeDatePipeで日時フォーマット | E-02 36行目、E-03 47行目 | ○ |
| C-13 | humanizeDurationPipeで実行時間フォーマット | E-02 37行目、E-03 48行目 | ○ |
| C-14 | ChangeDetectionStrategy.OnPush適用 | E-01 32行目、E-02 48行目 | ○ |
| C-15 | 関連機能No.32 REST API | E-05 83行目 | ○ |
| C-16 | 関連機能No.23 ジョブ管理 | E-05 84行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目がHTMLテンプレートと一致しているか確認
- [ ] フィルタリングロジック（completed=false）が正しいか確認
- [ ] デフォルトソートが正しく記述されているか確認
- [ ] 完了済みアプリケーション一覧との違いが正しいか確認
