---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-完了済みアプリケーション一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.ts` (行19-78)
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/application/application.component.html` (行19-29)
- E-03: `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.ts` (行59-124)
- E-04: `flink-runtime-web/web-dashboard/src/app/components/application-list/application-list.component.html` (行19-59)
- E-05: `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` (行44-59)
- E-06: `flink-runtime-web/web-dashboard/src/app/interfaces/application-overview.ts` (行19-47)
- E-07: `flink-runtime-web/web-dashboard/src/app/pages/application/routes.ts` (行24-52)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行85-86)
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` (行64-68, 122-125)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/application/completed` | E-07 (行39-48) | ○ |
| C-02 | `ApplicationComponent`がルートコンポーネントとして使用される | E-07 (行41), E-01 | ○ |
| C-03 | `isCompleted`フラグでcompleted/runningを判別 | E-01 (行37, 72-76) | ○ |
| C-04 | カードタイトルは'Completed Applications' | E-01 (行47-49) | ○ |
| C-05 | completedフラグはFINISHED/FAILED/CANCELEDでtrue | E-05 (行53) | ○ |
| C-06 | 終了時刻の降順がデフォルトソート | E-03 (行100-102), E-04 (行35) | ○ |
| C-07 | Application Name列は幅40% | E-04 (行30) | ○ |
| C-08 | 日付はyyyy-MM-dd HH:mm:ss.SSS形式で表示 | E-04 (行47-49) | ○ |
| C-09 | REST APIエンドポイントは `/applications/overview` | E-05 (行45) | ○ |
| C-10 | エラー時はEMPTYを返却 | E-05 (行57) | ○ |
| C-11 | 6つのソート可能列（Application Name, Start Time, Duration, End Time, Jobs除く, Status） | E-04 (行30-37), E-03 (行68-72) | ○ |
| C-12 | 行クリックでnavigateToApplication()が呼ばれる | E-02 (行23), E-04 (行43) | ○ |
| C-13 | Router.navigate()で詳細画面へ遷移 | E-01 (行68-70) | ○ |
| C-14 | ApplicationItemインターフェースにid, name, status, start-time等が含まれる | E-06 (行23-32) | ○ |
| C-15 | JobStatusインターフェースにジョブ状態カウントが含まれる | E-06 (行34-47) | ○ |
| C-16 | 関連機能としてREST API(32)とジョブ管理(23)がある | E-08 (行85-86) | ○ |
| C-17 | サイドナビゲーションからアクセス可能 | E-09 (行77-78) | ○ |
| C-18 | アプリケーション詳細画面へ遷移可能 | E-09 (行123-124), E-01 (行68-70) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードによる根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コード解析による高い信頼性がある

## 6) レビュアーチェックリスト（最小）
- [ ] APIエンドポイント `/applications/overview` のバックエンド実装との整合性確認
- [ ] ソート動作のブラウザ実機確認
- [ ] 画面遷移のE2Eテスト存在確認
