---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-アプリケーション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/application/application-detail/application-detail.component.ts` (行38-82)
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/application/application-detail/application-detail.component.html` (行19-39)
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/application/application-detail/status/application-status.component.ts` (行62-112)
- E-04: `flink-runtime-web/web-dashboard/src/app/pages/application/application-detail/status/application-status.component.html` (行19-79)
- E-05: `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` (行40-94)
- E-06: `flink-runtime-web/web-dashboard/src/app/pages/application/application-local.service.ts` (行25-36)
- E-07: `flink-runtime-web/web-dashboard/src/app/interfaces/application-detail.ts` (行22-42)
- E-08: `flink-runtime-web/web-dashboard/src/app/pages/application/modules/running-application/routes.ts` (行24-40)
- E-09: `flink-runtime-web/web-dashboard/src/app/pages/application/modules/completed-application/routes.ts` (行23-38)
- E-10: `flink-runtime-web/web-dashboard/src/app/pages/application/application.config.ts` (行25-32)
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行87-88)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/application/running/:id` または `/application/completed/:id` | E-08 (行27), E-09 (行26) | ○ |
| C-02 | `ApplicationDetailComponent`がメインコンポーネント | E-08 (行27), E-09 (行26) | ○ |
| C-03 | RunningApplicationGuardが実行中アプリケーションに設定されている | E-08 (行28) | ○ |
| C-04 | statusService.refresh$を購読して定期更新 | E-01 (行54-56) | ○ |
| C-05 | applicationService.loadApplication()でAPI呼び出し | E-01 (行57-58) | ○ |
| C-06 | applicationLocalService.setApplicationDetail()でデータ共有 | E-01 (行59-61) | ○ |
| C-07 | APIエンドポイントは `/applications/:applicationid` | E-05 (行62) | ○ |
| C-08 | cancelApplication()は `/applications/:id/cancel` をPOST | E-05 (行40-42) | ○ |
| C-09 | isErrorフラグでエラー表示を制御 | E-01 (行40), E-02 (行19, 29-35) | ○ |
| C-10 | isLoadingフラグでスケルトン表示を制御 | E-01 (行39), E-02 (行22) | ○ |
| C-11 | エラー時に「Application failed during initialization」を表示 | E-02 (行33) | ○ |
| C-12 | webCancelEnabledでキャンセル機能の有効/無効を判定 | E-03 (行68) | ○ |
| C-13 | isHistoryServerでJobManagerログリンク表示を制御 | E-03 (行69), E-04 (行58) | ○ |
| C-14 | キャンセル可能条件はRUNNINGまたはCREATED状態 | E-04 (行30-32) | ○ |
| C-15 | キャンセル後にstatusTipsに'Cancelling...'を設定 | E-03 (行107-109) | ○ |
| C-16 | nz-popconfirmで確認ダイアログを表示 | E-04 (行24-35) | ○ |
| C-17 | ApplicationDetailインターフェースにid, name, status等が含まれる | E-07 (行32-42) | ○ |
| C-18 | status-countsはloadApplication()内で計算される | E-05 (行64-77, 89) | ○ |
| C-19 | タブナビゲーションのデフォルトはOverviewのみ | E-10 (行26) | ○ |
| C-20 | listOfNavigationはmoduleConfigから取得 | E-03 (行80) | ○ |
| C-21 | JobManagerログリンクは `/job-manager/logs` へ遷移 | E-04 (行59) | ○ |
| C-22 | end-timeが-1より大きい場合のみ終了時刻を表示 | E-04 (行68) | ○ |
| C-23 | ReplaySubjectでデータ共有 | E-06 (行27-35) | ○ |
| C-24 | 関連機能としてREST API(32)とジョブ管理(23)がある | E-11 (行87-88) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードによる根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コード解析による高い信頼性がある

## 6) レビュアーチェックリスト（最小）
- [ ] APIエンドポイント `/applications/:id` のバックエンド実装との整合性確認
- [ ] キャンセルAPI `/applications/:id/cancel` のバックエンド実装との整合性確認
- [ ] RunningApplicationGuardの動作確認
- [ ] web-cancel/web-history機能フラグの設定確認
- [ ] キャンセル操作のE2Eテスト存在確認
