---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-アプリケーション概要

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime-web/web-dashboard/src/app/pages/application/overview/application-overview.component.ts` (行35-58)
- E-02: `flink-runtime-web/web-dashboard/src/app/pages/application/overview/application-overview.component.html` (行19-30)
- E-03: `flink-runtime-web/web-dashboard/src/app/pages/application/overview/routes.ts` (行23-28)
- E-04: `flink-runtime-web/web-dashboard/src/app/components/job-list/job-list.component.ts` (行60-120)
- E-05: `flink-runtime-web/web-dashboard/src/app/components/job-list/job-list.component.html` (行19-57)
- E-06: `flink-runtime-web/web-dashboard/src/app/pages/application/application-local.service.ts` (行25-36)
- E-07: `flink-runtime-web/web-dashboard/src/app/interfaces/job-overview.ts` (行23-49)
- E-08: `flink-runtime-web/web-dashboard/src/app/services/application.service.ts` (行78-88)
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行89-90)
- E-10: `docs/code-to-docs/画面一覧/画面遷移図.md` (行68, 125)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/application/running/:id/overview` または `/application/completed/:id/overview` | E-03, E-10 (行68) | ○ |
| C-02 | `ApplicationOverviewComponent`がルートコンポーネント | E-03 (行26) | ○ |
| C-03 | applicationLocalService.applicationDetailChanges()でデータを購読 | E-01 (行43) | ○ |
| C-04 | map(data => data.jobs)でジョブ配列を抽出 | E-01 (行45) | ○ |
| C-05 | shareReplay()でObservableを共有 | E-01 (行46) | ○ |
| C-06 | flink-job-listコンポーネントを2つ使用（running/completed） | E-02 (行19-24, 25-30) | ○ |
| C-07 | Running Job Listのタイトルは'Running Job List' | E-02 (行21) | ○ |
| C-08 | Completed Job Listのタイトルは'Completed Job List' | E-02 (行26) | ○ |
| C-09 | 実行中ジョブクリックで `/job/running/:jid` へ遷移 | E-02 (行23), E-01 (行55-57) | ○ |
| C-10 | 完了済みジョブクリックで `/job/completed/:jid` へ遷移 | E-02 (行29), E-01 (行55-57) | ○ |
| C-11 | INITIALIZINGステータス時はメッセージを表示して遷移しない | E-04 (行80-82) | ○ |
| C-12 | JobsItemインターフェースにjid, name, state等が含まれる | E-07 (行23-34) | ○ |
| C-13 | TaskStatusインターフェースにタスク状態が含まれる | E-07 (行36-49) | ○ |
| C-14 | ジョブのcompletedフラグはloadApplication()内で設定される | E-08 (行87) | ○ |
| C-15 | completedフラグはFINISHED/FAILED/CANCELEDでtrue | E-08 (行87) | ○ |
| C-16 | ジョブ一覧はcompletedフラグでフィルタリング | E-04 (行103) | ○ |
| C-17 | Job Name列は幅40% | E-05 (行30) | ○ |
| C-18 | 日付はyyyy-MM-dd HH:mm:ss.SSS形式で表示 | E-05 (行45-47) | ○ |
| C-19 | ReplaySubjectでデータ共有 | E-06 (行27-35) | ○ |
| C-20 | 関連機能としてREST API(32)とジョブ管理(23)がある | E-09 (行89-90) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードによる根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、コード解析による高い信頼性がある

## 6) レビュアーチェックリスト（最小）
- [ ] shareReplay()の動作がメモリリークを起こさないか確認
- [ ] INITIALIZINGステータスのメッセージ表示が適切か確認
- [ ] ジョブ詳細画面への遷移のE2Eテスト存在確認
- [ ] Running/Completedの表示分離が正しく動作するか確認
