---
generated_at: 2026-02-02 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ジョブ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/job/job-detail/job-detail.component.ts`（全体）
- E-02: `src/app/pages/job/job-local.service.ts`（全体）
- E-03: `src/app/services/job.service.ts`（88-92行目、110-114行目、211-266行目）
- E-04: `src/app/interfaces/job-detail.ts`（全体）
- E-05: `src/app/pages/job/job.config.ts`（全体）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行6）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行11-12）
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/job/:status/:jid` | E-06, E-08 | ○ |
| C-02 | コンテナ画面として各タブを含む | E-06（備考欄） | ○ |
| C-03 | GET `/jobs/{jobid}`でジョブ詳細取得 | E-03（90行目） | ○ |
| C-04 | ActivatedRouteからjidパラメータ取得 | E-01（58行目） | ○ |
| C-05 | JobLocalServiceにジョブ詳細を設定 | E-01（60行目） | ○ |
| C-06 | エラー時にloadExceptions()を呼び出し | E-01（63行目） | ○ |
| C-07 | GET `/jobs/{jobid}/exceptions`で例外取得 | E-03（111-113行目） | ○ |
| C-08 | errorDetailsにroot-exceptionを設定 | E-01（64行目） | ○ |
| C-09 | タブ構成がjob.config.tsで定義 | E-05（26-33行目） | ○ |
| C-10 | Overviewタブが存在 | E-05（27行目） | ○ |
| C-11 | Exceptionsタブが存在 | E-05（28行目） | ○ |
| C-12 | Data Skewタブが存在 | E-05（29行目） | ○ |
| C-13 | TimeLineタブが存在 | E-05（30行目） | ○ |
| C-14 | Checkpointsタブが存在 | E-05（31行目） | ○ |
| C-15 | Configurationタブが存在 | E-05（32行目） | ○ |
| C-16 | JobLocalServiceはReplaySubjectを使用 | E-02（36行目） | ○ |
| C-17 | convertJob()でplanを変換 | E-03（91行目、211-266行目） | ○ |
| C-18 | ChangeDetectionStrategy.OnPushを使用 | E-01（35行目） | ○ |
| C-19 | 機能No.32 REST APIが主機能 | E-07（行11） | ○ |
| C-20 | 機能No.23 ジョブ管理が補助機能 | E-07（行12） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] JobLocalServiceのReplaySubjectがメモリリークを起こさないか確認
- [ ] エラー発生時のUI表示が適切か確認
- [ ] タブ間遷移時のデータ再取得有無を確認
