---
generated_at: 2026-02-02 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-タイムライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/job/timeline/job-timeline.component.ts`（全体）
- E-02: `src/app/interfaces/job-detail.ts`（VerticesItemRange型）
- E-03: `src/app/services/job.service.ts`（145-149行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行8）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行16-17）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/job/:status/:jid/timeline` | E-04, E-06 | ○ |
| C-02 | G2チャートライブラリを使用 | E-01（32-33行目、178行目） | ○ |
| C-03 | ngAfterViewInitで初期化 | E-01（68行目） | ○ |
| C-04 | JobLocalService.jobDetailChanges()でデータ取得 | E-01（71-72行目） | ○ |
| C-05 | vertices情報を抽出 | E-01（80行目） | ○ |
| C-06 | 開始時刻でソート | E-01（89行目） | ○ |
| C-07 | range計算（start-time, end-time） | E-01（82-87行目） | ○ |
| C-08 | クリックでサブタスクタイムライン表示 | E-01（210-220行目） | ○ |
| C-09 | updateSubTaskChart()でサブタスク取得 | E-01（113-175行目） | ○ |
| C-10 | GET `/jobs/{jobid}/vertices/{vertexid}/subtasktimes` | E-03（146-148行目） | ○ |
| C-11 | timestamps情報を解析 | E-01（121-131行目） | ○ |
| C-12 | 状態ごとの時間範囲を計算 | E-01（132-146行目） | ○ |
| C-13 | coordinate('rect').transpose() | E-01（186行目、232行目） | ○ |
| C-14 | COLOR_MAPで状態ごとの色設定 | E-01（190行目、236行目） | ○ |
| C-15 | 時間フォーマットはHH:mm:ss.SSS | E-01（99行目、157行目） | ○ |
| C-16 | 機能No.32 REST APIが主機能 | E-05（行16） | ○ |
| C-17 | 機能No.23 ジョブ管理が補助機能 | E-05（行17） | ○ |
| C-18 | scrollIntoViewIfNeededで自動スクロール | E-01（164-173行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み
- **備考**：scrollIntoViewIfNeededは非標準APIであるため、ブラウザ互換性に注意（コード内にFIXMEコメントあり）

## 6) レビュアーチェックリスト（最小）
- [ ] 多数のサブタスク（100以上）がある場合のパフォーマンスを確認
- [ ] scrollIntoViewIfNeededのブラウザ互換性を確認
- [ ] タイムゾーン処理が正しいか確認
- [ ] 長時間実行ジョブでのタイムライン表示を確認
