---
generated_at: 2026-02-02 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-データスキュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/app/pages/job/dataskew/data-skew.component.ts`（全体）
- E-02: `src/app/interfaces/job-detail.ts`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行10）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行21-22）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは`/job/:status/:jid/dataskew` | E-03, E-05 | ○ |
| C-02 | refresh$サブジェクトを使用 | E-01（46行目） | ○ |
| C-03 | JobLocalService.jobDetailChanges()をサブスクライブ | E-01（83-93行目） | ○ |
| C-04 | vertices情報を取得 | E-01（62行目） | ○ |
| C-05 | loadAggregatedMetrics()でスキュー取得 | E-01（68行目） | ○ |
| C-06 | numRecordsInメトリクスを使用 | E-01（68行目） | ○ |
| C-07 | skew集計を取得 | E-01（68行目） | ○ |
| C-08 | Number.isNaN()でNaNチェック | E-01（70行目） | ○ |
| C-09 | Math.round()で整数に丸め | E-01（70行目） | ○ |
| C-10 | スキュー率で降順ソート | E-01（72行目） | ○ |
| C-11 | listOfVerticesAndSkewに結果設定 | E-01（74行目） | ○ |
| C-12 | refresh()メソッドで手動リフレッシュ | E-01（102-104行目） | ○ |
| C-13 | 機能No.32 REST APIが主機能 | E-04（行21） | ○ |
| C-14 | 機能No.57 メトリクスコアがAPI連携 | E-04（行22） | ○ |
| C-15 | ChangeDetectionStrategy.OnPushを使用 | E-01（37行目） | ○ |
| C-16 | NzTableModuleを使用 | E-01（38行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：全ての主張がソースコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] スキュー率の計算アルゴリズムが業務要件に合っているか確認
- [ ] 多数の頂点がある場合のメトリクス取得パフォーマンスを確認
- [ ] スキュー率の閾値による警告表示が必要か検討
