---
generated_at: 2026-02-02 16:15:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **IT-052 HadoopDelegationTokenReceiverITCase**：テストコード詳細未確認
  2. **IT-053 HadoopFSDelegationTokenProviderITCase**：テストコード詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-sql-gateway/src/test/java/org/apache/flink/table/gateway/rest/SqlGatewayRestEndpointITCase.java`
- E-02: `flink-table/flink-sql-gateway/src/test/java/org/apache/flink/table/gateway/rest/SessionRelatedITCase.java`
- E-03: `flink-table/flink-sql-gateway/src/test/java/org/apache/flink/table/gateway/service/SqlGatewayServiceITCase.java`
- E-04: `flink-end-to-end-tests/flink-sql-gateway-test/src/test/java/org/apache/flink/table/gateway/SqlGatewayE2ECase.java`
- E-05: `flink-connectors/flink-connector-files/src/test/java/org/apache/flink/connector/file/sink/StreamingExecutionFileSinkITCase.java`
- E-06: `flink-connectors/flink-connector-files/src/test/java/org/apache/flink/connector/file/sink/BatchExecutionFileSinkITCase.java`
- E-07: `flink-connectors/flink-connector-files/src/test/java/org/apache/flink/connector/file/sink/writer/FileSinkMigrationITCase.java`
- E-08: `flink-connectors/flink-connector-base/src/test/java/org/apache/flink/connector/base/source/reader/CoordinatedSourceITCase.java`
- E-09: `flink-connectors/flink-connector-base/src/test/java/org/apache/flink/connector/base/source/hybrid/HybridSourceITCase.java`
- E-10: `flink-connectors/flink-connector-base/src/test/java/org/apache/flink/connector/base/sink/AsyncSinkBaseITCase.java`
- E-11: `flink-runtime/src/test/java/org/apache/flink/runtime/jobmaster/JobExecutionITCase.java`
- E-12: `flink-runtime/src/test/java/org/apache/flink/runtime/jobmaster/JobRecoveryITCase.java`
- E-13: `flink-runtime/src/test/java/org/apache/flink/runtime/dispatcher/DispatcherCleanupITCase.java`
- E-14: `flink-runtime/src/test/java/org/apache/flink/runtime/scheduler/adaptive/AdaptiveSchedulerClusterITCase.java`
- E-15: `flink-runtime/src/test/java/org/apache/flink/runtime/checkpoint/ZooKeeperCompletedCheckpointStoreITCase.java`
- E-16: `flink-runtime/src/test/java/org/apache/flink/runtime/minicluster/MiniClusterITCase.java`
- E-17: `flink-runtime/src/test/java/org/apache/flink/runtime/rest/RestServerEndpointITCase.java`
- E-18: `flink-runtime/src/test/java/org/apache/flink/runtime/rest/RestServerSSLAuthITCase.java`
- E-19: `flink-runtime/src/test/java/org/apache/flink/runtime/rpc/RpcSSLAuthITCase.java`
- E-20: `flink-connectors/flink-hadoop-compatibility/src/test/java/org/apache/flink/test/hadoopcompatibility/mapred/HadoopMapredITCase.java`
- E-21: `flink-runtime/src/test/java/org/apache/flink/runtime/security/token/hadoop/HadoopDelegationTokenReceiverITCase.java`
- E-22: `flink-runtime/src/test/java/org/apache/flink/runtime/security/token/hadoop/HadoopFSDelegationTokenProviderITCase.java`
- E-23: `flink-table/flink-table-planner/src/test/java/org/apache/flink/table/planner/catalog/CatalogITCase.java`
- E-24: `flink-table/flink-table-planner/src/test/java/org/apache/flink/table/planner/runtime/stream/module/ModuleITCase.java`
- E-25: `flink-table/flink-table-planner/src/test/java/org/apache/flink/table/planner/runtime/stream/sql/FunctionITCase.java`
- E-26: `flink-table/flink-table-planner/src/test/java/org/apache/flink/table/planner/runtime/batch/sql/FunctionITCase.java`
- E-27: `flink-table/flink-sql-client/src/test/java/org/apache/flink/table/client/cli/CliClientITCase.java`
- E-28: `flink-table/flink-sql-client/src/test/java/org/apache/flink/table/client/cli/CliClientMultiStatementITTest.java`
- E-29: `flink-table/flink-sql-client/src/test/java/org/apache/flink/table/client/gateway/ExecutorImplITCase.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 SqlGatewayRestEndpointITCase - testSqlGatewayMessageHeaders | E-01 | ○ |
| C-02 | IT-002 SqlGatewayRestEndpointITCase - testVersionSelection | E-01 | ○ |
| C-03 | IT-003 SqlGatewayRestEndpointITCase - testDefaultVersionRouting | E-01 | ○ |
| C-04 | IT-004 SqlGatewayRestEndpointITCase - testRequestInterleaving | E-01 | ○ |
| C-05 | IT-005 SqlGatewayRestEndpointITCase - testShouldWaitForHandlersWhenClosing | E-01 | ○ |
| C-06 | IT-006 SqlGatewayRestEndpointITCase - testOnUnavailableRpcEndpointReturns503 | E-01 | ○ |
| C-07 | IT-007 SessionRelatedITCase - testCreateAndCloseSessions | E-02 | ○ |
| C-08 | IT-008 SessionRelatedITCase - testGetSessionConfiguration | E-02 | ○ |
| C-09 | IT-009 SessionRelatedITCase - testTouchSession | E-02 | ○ |
| C-10 | IT-010 SessionRelatedITCase - testConfigureSession | E-02 | ○ |
| C-11 | IT-011 SqlGatewayServiceITCase - testOpenSessionWithConfig | E-03 | ○ |
| C-12 | IT-012 SqlGatewayServiceITCase - testOpenSessionWithEnvironment | E-03 | ○ |
| C-13 | IT-013 SqlGatewayServiceITCase - testConfigureSessionWithLegalStatement | E-03 | ○ |
| C-14 | IT-014 SqlGatewayServiceITCase - testFetchResultsInRunning | E-03 | ○ |
| C-15 | IT-015 SqlGatewayServiceITCase - testGetOperationFinishedAndFetchResults | E-03 | ○ |
| C-16 | IT-016 SqlGatewayServiceITCase - testCancelOperation | E-03 | ○ |
| C-17 | IT-017 SqlGatewayServiceITCase - testOperationGetErrorAndFetchError | E-03 | ○ |
| C-18 | IT-018 SqlGatewayServiceITCase - testStopJobStatementWithSavepoint | E-03 | ○ |
| C-19 | IT-019 SqlGatewayServiceITCase - testShowJobsOperation | E-03 | ○ |
| C-20 | IT-020 SqlGatewayServiceITCase - testDescribeJobOperation | E-03 | ○ |
| C-21 | IT-021 SqlGatewayServiceITCase - testGetCurrentCatalog | E-03 | ○ |
| C-22 | IT-022 SqlGatewayServiceITCase - testListCatalogs | E-03 | ○ |
| C-23 | IT-023 SqlGatewayServiceITCase - testListDatabases | E-03 | ○ |
| C-24 | IT-024 SqlGatewayServiceITCase - testListTables | E-03 | ○ |
| C-25 | IT-025 SqlGatewayServiceITCase - testListSystemFunctions | E-03 | ○ |
| C-26 | IT-026 SqlGatewayServiceITCase - testListUserDefinedFunctions | E-03 | ○ |
| C-27 | IT-027 SqlGatewayServiceITCase - testCompleteStatement | E-03 | ○ |
| C-28 | IT-028 SqlGatewayServiceITCase - testCancelOperationAndFetchResultInParallel | E-03 | ○ |
| C-29 | IT-029 SqlGatewayServiceITCase - testCloseOperationAndFetchResultInParallel | E-03 | ○ |
| C-30 | IT-030 SqlGatewayServiceITCase - testCancelAndCloseOperationInParallel | E-03 | ○ |
| C-31 | IT-031 SqlGatewayE2ECase - testHiveServer2ExecuteStatement | E-04 | ○ |
| C-32 | IT-032 SqlGatewayE2ECase - testRestExecuteStatement | E-04 | ○ |
| C-33 | IT-033 SqlGatewayE2ECase - testSqlClientExecuteStatement | E-04 | ○ |
| C-34 | IT-034 SqlGatewayE2ECase - testMaterializedTableInContinuousMode | E-04 | ○ |
| C-35 | IT-035 SqlGatewayE2ECase - testMaterializedTableInFullMode | E-04 | ○ |
| C-36 | IT-036 StreamingExecutionFileSinkITCase | E-05 | ○ |
| C-37 | IT-037 BatchExecutionFileSinkITCase | E-06 | ○ |
| C-38 | IT-038 FileSinkMigrationITCase | E-07 | ○ |
| C-39 | IT-039 CoordinatedSourceITCase | E-08 | ○ |
| C-40 | IT-040 HybridSourceITCase | E-09 | ○ |
| C-41 | IT-041 AsyncSinkBaseITCase | E-10 | ○ |
| C-42 | IT-042 JobExecutionITCase | E-11 | ○ |
| C-43 | IT-043 JobRecoveryITCase | E-12 | ○ |
| C-44 | IT-044 DispatcherCleanupITCase | E-13 | ○ |
| C-45 | IT-045 AdaptiveSchedulerClusterITCase | E-14 | ○ |
| C-46 | IT-046 ZooKeeperCompletedCheckpointStoreITCase | E-15 | ○ |
| C-47 | IT-047 MiniClusterITCase | E-16 | ○ |
| C-48 | IT-048 RestServerEndpointITCase | E-17 | ○ |
| C-49 | IT-049 RestServerSSLAuthITCase | E-18 | ○ |
| C-50 | IT-050 RpcSSLAuthITCase | E-19 | ○ |
| C-51 | IT-051 HadoopMapredITCase | E-20 | ○ |
| C-52 | IT-052 HadoopDelegationTokenReceiverITCase | E-21 | △ |
| C-53 | IT-053 HadoopFSDelegationTokenProviderITCase | E-22 | △ |
| C-54 | IT-054 CatalogITCase | E-23 | ○ |
| C-55 | IT-055 ModuleITCase | E-24 | ○ |
| C-56 | IT-056 FunctionITCase（Stream SQL） | E-25 | ○ |
| C-57 | IT-057 FunctionITCase（Batch SQL） | E-26 | ○ |
| C-58 | IT-058 CliClientITCase | E-27 | ○ |
| C-59 | IT-059 CliClientMultiStatementITTest | E-28 | ○ |
| C-60 | IT-060 ExecutorImplITCase | E-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- IT-052, IT-053: Hadoop認証関連のテストコードは存在を確認したが、詳細なテスト手順・期待結果についてはソースコードの詳細解析が必要
  - 候補：テストコードの詳細解析 / Hadoop認証仕様書 / Kerberos設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: IT-003, IT-008, IT-009, IT-010, IT-014, IT-019, IT-020, IT-021, IT-022, IT-023, IT-024, IT-025, IT-026, IT-027, IT-038, IT-044, IT-051, IT-052, IT-053, IT-055, IT-059
- **1（中リスク）**: IT-001, IT-002, IT-004, IT-005, IT-006, IT-007, IT-011, IT-012, IT-013, IT-015, IT-016, IT-017, IT-028, IT-029, IT-030, IT-036, IT-037, IT-039, IT-040, IT-041, IT-042, IT-045, IT-046, IT-047, IT-048, IT-054, IT-056, IT-057, IT-058, IT-060
- **2（高リスク）**: IT-018, IT-031, IT-032, IT-033, IT-034, IT-035, IT-043, IT-049, IT-050
  - 理由：ジョブリカバリ、E2Eテスト、SSL認証は本番環境への影響が大きいため

## 6) レビュアーチェックリスト（最小）
- [ ] CSVファイルがExcelで正しく開けることを確認（BOM付きUTF-8）
- [ ] 高優先度テストケース（IT-018, IT-031-035, IT-043, IT-049-050）の前提条件が実環境で満たせることを確認
- [ ] 根拠なし項目（IT-052, IT-053）について、Hadoop認証関連テストの詳細仕様を確認
- [ ] テスト手順の記述が実際のテストコードの@Testメソッドと一致していることをサンプリング確認
- [ ] 期待結果がassert文と整合していることをサンプリング確認
