---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-core/src/main/java/org/apache/flink/api/common/state/CheckpointListener.java`
- E-02: `flink-core/src/main/java/org/apache/flink/api/common/state/InternalCheckpointListener.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/CheckpointStatsListener.java`
- E-04: `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java`
- E-05: `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderContender.java`
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/leaderretrieval/LeaderRetrievalListener.java`
- E-07: `flink-runtime/src/main/java/org/apache/flink/runtime/heartbeat/HeartbeatListener.java`
- E-08: `flink-runtime/src/main/java/org/apache/flink/runtime/blocklist/BlocklistListener.java`
- E-09: `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/BufferAvailabilityListener.java`
- E-10: `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/BufferListener.java`
- E-11: `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListener.java`
- E-12: `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/hybrid/tiered/storage/AvailabilityNotifier.java`
- E-13: `flink-runtime/src/main/java/org/apache/flink/runtime/query/KvStateRegistryListener.java`
- E-14: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/JobLeaderListener.java`
- E-15: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/slot/TimeoutListener.java`
- E-16: `flink-rpc/flink-rpc-core/src/main/java/org/apache/flink/runtime/rpc/FatalErrorHandler.java`
- E-17: `flink-runtime/src/main/java/org/apache/flink/runtime/application/ApplicationStatusListener.java`
- E-18: `flink-runtime/src/main/java/org/apache/flink/runtime/util/event/NotificationListener.java`
- E-19: `flink-runtime/src/main/java/org/apache/flink/runtime/source/coordinator/ExecutorNotifier.java`
- E-20: `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/consumer/GateNotificationHelper.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | notifyCheckpointComplete - チェックポイント完了通知 | E-01 | ○ |
| C-02 | notifyCheckpointAborted - チェックポイント中断通知 | E-01 | ○ |
| C-03 | notifyCheckpointSubsumed - チェックポイント置換通知 | E-02 | ○ |
| C-04 | onCompletedCheckpoint - チェックポイント完了コールバック | E-03 | ○ |
| C-05 | onFailedCheckpoint - チェックポイント失敗コールバック | E-03 | ○ |
| C-06 | onJobSubmitted - ジョブ送信通知 | E-04 | ○ |
| C-07 | onJobExecuted - ジョブ実行完了通知 | E-04 | ○ |
| C-08 | grantLeadership - リーダー権限付与通知 | E-05 | ○ |
| C-09 | revokeLeadership - リーダー権限剥奪通知 | E-05 | ○ |
| C-10 | notifyLeaderAddress - リーダーアドレス通知 | E-06 | ○ |
| C-11 | notifyHeartbeatTimeout - ハートビートタイムアウト通知 | E-07 | ○ |
| C-12 | notifyTargetUnreachable - ターゲット到達不能通知 | E-07 | ○ |
| C-13 | notifyNewBlockedNodes - 新規ブロックノード通知 | E-08 | ○ |
| C-14 | notifyDataAvailable - データ利用可能通知 | E-09 | ○ |
| C-15 | notifyPriorityEvent - 優先イベント通知 | E-09 | ○ |
| C-16 | notifyBufferAvailable - バッファ利用可能通知 | E-10 | ○ |
| C-17 | notifyBufferDestroyed - バッファ破棄通知 | E-10 | ○ |
| C-18 | notifyPartitionCreated - パーティション作成通知 | E-11 | ○ |
| C-19 | notifyPartitionCreatedTimeout - パーティション作成タイムアウト通知 | E-11 | ○ |
| C-20 | notifyAvailable - データ利用可能通知（階層型ストレージ） | E-12 | ○ |
| C-21 | notifyKvStateRegistered - KvState登録通知 | E-13 | ○ |
| C-22 | notifyKvStateUnregistered - KvState登録解除通知 | E-13 | ○ |
| C-23 | jobManagerGainedLeadership - ジョブマネージャリーダーシップ取得通知 | E-14 | ○ |
| C-24 | jobManagerLostLeadership - ジョブマネージャリーダーシップ喪失通知 | E-14 | ○ |
| C-25 | jobManagerRejectedRegistration - ジョブマネージャ登録拒否通知 | E-14 | ○ |
| C-26 | notifyTimeout - タイムアウト通知 | E-15 | ○ |
| C-27 | onFatalError - 致命的エラー通知 | E-16 | ○ |
| C-28 | handleError（LeaderContender） - エラー通知（リーダー選出） | E-05 | ○ |
| C-29 | handleError（LeaderRetrievalListener） - エラー通知（リーダー取得） | E-06 | ○ |
| C-30 | handleError（JobLeaderListener） - エラー通知（ジョブリーダー） | E-14 | ○ |
| C-31 | notifyApplicationStatusChange - アプリケーションステータス変更通知 | E-17 | ○ |
| C-32 | onNotification - 汎用通知コールバック | E-18 | ○ |
| C-33 | notifyReadyAsync - 非同期準備完了通知 | E-19 | ○ |
| C-34 | notifyPriority（GateNotificationHelper） - 優先度通知 | E-20 | ○ |
| C-35 | notifyDataAvailable（GateNotificationHelper） - データ利用可能通知（入力ゲート） | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての通知機能はソースコード内のインターフェース定義から直接抽出されており、根拠が明確に存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードのインターフェース定義に基づいている
- 注意点：Apache Flinkは分散ストリーム処理フレームワークであり、本一覧はシステム内部の通知機構（リスナーパターン、コールバック）を対象としている。メール通知やSMS通知などのエンドユーザー向け通知機能は本プロジェクトには含まれていない。

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知のカテゴリ分類が適切か確認
- [ ] 通知名（メソッド名）がソースコードと一致しているか確認
- [ ] 説明内容がJavaDocコメントと整合しているか確認
- [ ] 備考欄のインターフェース名が正確か確認
- [ ] プロジェクト内に追加の通知関連インターフェースが存在しないか確認
