# 通知設計書 14-notifyDataAvailable

## 概要

本ドキュメントは、Apache Flinkのデータ利用可能通知（notifyDataAvailable）の設計仕様を記述したものである。

### 本通知の処理概要

notifyDataAvailableは、ResultSubpartitionViewで新しいデータが利用可能になった際にリスナーに通知するメカニズムである。これにより、下流タスクは新しいデータの到着を認識し、消費処理を開始できる。

**業務上の目的・背景**：ストリーム処理において、上流タスクから下流タスクへのデータ転送は効率的に行われる必要がある。データが利用可能になるたびにポーリングするのではなく、プッシュ型の通知により、低レイテンシかつ効率的なデータ転送を実現する。

**通知の送信タイミング**：PipelinedSubpartitionにバッファが追加され、以下のいずれかの条件を満たした場合に通知が発行される：(1)最初の完了バッファが追加された時、(2)flush()が明示的に呼び出された時、(3)サブパーティションが終了した時。

**通知の受信者**：BufferAvailabilityListenerインターフェースを実装するクラスが受信者となる。主にCreditBasedSequenceNumberingViewReaderやLocalInputChannelがリスナーとして機能する。

**通知内容の概要**：データが利用可能になったResultSubpartitionViewへの参照が通知される。受信者はこの参照を使用してバッファを取得できる。

**期待されるアクション**：受信者は、通知を受けてResultSubpartitionViewからバッファをポーリングし、下流へのデータ転送処理を開始する。ネットワーク層では、Netty経由でデータを送信するためのキューイングが行われる。

## 通知種別

内部コールバック（Javaメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（バッファ追加スレッドから呼び出し） |
| 優先度 | 高（データ転送に直結） |
| リトライ | なし |

### 送信先決定ロジック

PipelinedSubpartitionViewの作成時に登録されたBufferAvailabilityListenerに対して通知される。

## 通知テンプレート

### コールバックシグネチャ

```java
void notifyDataAvailable(ResultSubpartitionView view);
```

### パラメータ詳細

| パラメータ名 | 型 | 説明 |
|------------|-----|------|
| view | ResultSubpartitionView | データが利用可能になったサブパーティションビュー |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| view | サブパーティションビュー | PipelinedSubpartitionViewインスタンス | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッファ追加 | add()メソッド | 最初の完了バッファ追加時 | shouldNotifyDataAvailable()がtrueの場合 |
| フラッシュ | flush()メソッド | 未読データがある場合 | 明示的なフラッシュリクエスト |
| 終了 | finish()メソッド | サブパーティション終了時 | EndOfPartitionEvent送信時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| isBlocked | サブパーティションがブロック状態の場合 |
| flushRequested | 既にフラッシュリクエスト済みの場合 |
| readViewがnull | リードビューが未作成の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[バッファ追加/フラッシュ] --> B{サブパーティションがブロック?}
    B -->|Yes| C[処理終了]
    B -->|No| D{通知条件を満たす?}
    D -->|No| C
    D -->|Yes| E{readViewが存在?}
    E -->|No| C
    E -->|Yes| F[readView.notifyDataAvailable呼び出し]
    F --> G[BufferAvailabilityListener.notifyDataAvailable]
    G --> H[requestQueue.notifyReaderNonEmpty]
    H --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースアクセスは発生しない（インメモリ処理）。

### 更新テーブル一覧

データベース更新は発生しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | notifyDataAvailable内で例外発生 | 例外が上位に伝播 |
| ビュー解放済み | isReleased()がtrueの場合 | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（バッファ到着頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし（24時間稼働）

## セキュリティ考慮事項

- 通知はJVM内部のメソッド呼び出しで完結
- バッファ内容自体は通知に含まれない（参照のみ）

## 備考

- 通知は最初の完了バッファでのみ発生し、その後はリーダーがバッファを消費する
- バックプレッシャー制御にも関連する重要な通知

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResultSubpartitionView.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultSubpartitionView.java` | ビューインターフェース |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BufferAvailabilityListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/BufferAvailabilityListener.java` | インターフェース定義（25-32行目） |

**主要処理フロー**:
1. **行25**: インターフェースの目的説明
2. **行27-32**: notifyDataAvailableメソッドのJavadoc
3. **行32**: void notifyDataAvailable(ResultSubpartitionView view)

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PipelinedSubpartition.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PipelinedSubpartition.java` | 通知発行の実装（760-765行目） |
| 3-2 | PipelinedSubpartitionView.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PipelinedSubpartitionView.java` | ビュー実装（54-56行目） |

**主要処理フロー**:
- **行760-765**: notifyDataAvailable()メソッド
- **行752-758**: shouldNotifyDataAvailable()判定

#### Step 4: 受信側を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CreditBasedSequenceNumberingViewReader.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/CreditBasedSequenceNumberingViewReader.java` | Netty層での受信（294-296行目） |

### プログラム呼び出し階層図

```
PipelinedSubpartition.add() / flush() / finish()
    │
    └─ notifyDataAvailable()
           │
           └─ PipelinedSubpartitionView.notifyDataAvailable()
                  │
                  └─ BufferAvailabilityListener.notifyDataAvailable(view)
                         │
                         └─ CreditBasedSequenceNumberingViewReader
                                │
                                └─ PartitionRequestQueue.notifyReaderNonEmpty()
```

### データフロー図

```
[入力]               [処理]                    [出力]

バッファ追加 ───▶ PipelinedSubpartition ───▶ BufferAvailabilityListener
                       │                          │
                       ├─ 通知条件判定            └─ Netty送信キュー
                       └─ readView経由               追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BufferAvailabilityListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/BufferAvailabilityListener.java` | インターフェース | リスナーインターフェース定義 |
| PipelinedSubpartition.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PipelinedSubpartition.java` | 実装クラス | バッファ管理と通知発行 |
| PipelinedSubpartitionView.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PipelinedSubpartitionView.java` | 実装クラス | ビュー実装 |
| CreditBasedSequenceNumberingViewReader.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/CreditBasedSequenceNumberingViewReader.java` | リスナー実装 | Netty層での処理 |
| PartitionRequestQueue.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/PartitionRequestQueue.java` | ネットワーク | 送信キュー管理 |
