# 通知設計書 17-notifyBufferDestroyed

## 概要

本ドキュメントは、Apache Flinkのバッファ破棄通知（notifyBufferDestroyed）の設計仕様を記述したものである。

### 本通知の処理概要

notifyBufferDestroyedは、バッファプロバイダ（バッファプール）が破棄された際にリスナーに通知するメカニズムである。バッファを待機中のコンポーネントに対して、バッファが今後利用できなくなったことを知らせる。

**業務上の目的・背景**：タスク終了やエラー発生時にバッファプールが破棄される場合、バッファを待機中のコンポーネントは無限に待機し続ける可能性がある。この通知により、待機中のコンポーネントは適切に処理を終了またはエラーハンドリングを行うことができる。

**通知の送信タイミング**：LocalBufferPoolのlazyDestroy()メソッドが呼び出され、バッファプールが破棄される際に、登録済みの全BufferListenerに対して通知が発行される。

**通知の受信者**：BufferListenerインターフェースを実装するクラスが受信者となる。主にBufferManager（RemoteInputChannel用）がリスナーとして機能する。

**通知内容の概要**：パラメータなしの通知。単にバッファプールが破棄されたという事実のみが通知される。

**期待されるアクション**：受信者は、バッファ待機をキャンセルし、エラー処理または正常終了処理を行う。新しいバッファは取得できなくなるため、適切なクリーンアップを実施する必要がある。

## 通知種別

内部コールバック（Javaメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（プール破棄スレッドから呼び出し） |
| 優先度 | 高（リソース解放に直結） |
| リトライ | なし |

### 送信先決定ロジック

LocalBufferPoolに登録された全てのBufferListenerに対して通知される。registeredListenersキューから全リスナーを取り出して通知する。

## 通知テンプレート

### コールバックシグネチャ

```java
void notifyBufferDestroyed();
```

### パラメータ詳細

パラメータなし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| - | パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プール破棄 | lazyDestroy()メソッド | リスナーが登録されている場合 | タスク終了時など |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に破棄済み | isDestroyedがtrueの場合 |
| リスナー未登録 | registeredListenersが空の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[lazyDestroy呼び出し] --> B{既に破棄済み?}
    B -->|Yes| C[処理終了]
    B -->|No| D[availableMemorySegments解放]
    D --> E{リスナーあり?}
    E -->|No| F[isDestroyed = true]
    E -->|Yes| G[リスナー取得]
    G --> H[notifyBufferDestroyed呼び出し]
    H --> I{次のリスナーあり?}
    I -->|Yes| G
    I -->|No| F
    F --> J[networkBufferPool.destroyBufferPool]
    J --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースアクセスは発生しない（インメモリ処理）。

### 更新テーブル一覧

データベース更新は発生しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | notifyBufferDestroyed内で例外発生 | 例外を無視して次のリスナーへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（プール破棄は通常1回） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし（24時間稼働）

## セキュリティ考慮事項

- 通知はJVM内部のメソッド呼び出しで完結
- 機密情報は含まれない

## 備考

- lazyDestroyはタスクの終了時に呼び出される
- 全リスナーへの通知後、NetworkBufferPoolにプールを返却

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BufferPool.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/BufferPool.java` | バッファプールインターフェース |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BufferListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/BufferListener.java` | インターフェース定義（45-46行目） |

**主要処理フロー**:
1. **行45**: Javadoc説明
2. **行46**: void notifyBufferDestroyed()

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LocalBufferPool.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/LocalBufferPool.java` | 破棄処理（620-648行目） |

**主要処理フロー**:
- **行620-648**: lazyDestroy()メソッド
- **行627-629**: availableMemorySegments解放
- **行631-635**: 全リスナーへの通知

### プログラム呼び出し階層図

```
タスク終了 / エラー発生
    │
    └─ LocalBufferPool.lazyDestroy()
           │
           ├─ synchronized(availableMemorySegments)
           │      │
           │      ├─ メモリセグメント解放
           │      │
           │      └─ while ((listener = registeredListeners.poll()) != null)
           │             │
           │             └─ BufferListener.notifyBufferDestroyed()
           │
           └─ networkBufferPool.destroyBufferPool(this)
```

### データフロー図

```
[入力]               [処理]                    [出力]

プール破棄 ───▶ LocalBufferPool ───▶ BufferListener
                       │                          │
                       ├─ メモリ解放              └─ 待機キャンセル
                       └─ リスナー通知               エラー処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BufferListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/BufferListener.java` | インターフェース | リスナーインターフェース定義 |
| LocalBufferPool.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/LocalBufferPool.java` | 実装クラス | バッファプール管理 |
| BufferManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/consumer/BufferManager.java` | リスナー実装 | バッファ管理 |
| NetworkBufferPool.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/buffer/NetworkBufferPool.java` | グローバルプール | メモリ管理 |
