# 通知設計書 18-notifyPartitionCreated

## 概要

本ドキュメントは、Apache Flinkのパーティション作成通知（notifyPartitionCreated）の設計仕様を記述したものである。

### 本通知の処理概要

notifyPartitionCreatedは、上流タスクがパーティションをResultPartitionManagerに登録した際に、待機中のリスナーに通知するメカニズムである。これにより、下流タスクからのデータリクエストを適切に処理できる。

**業務上の目的・背景**：分散ストリーム処理では、下流タスクが上流タスクより先に起動する場合がある。この場合、下流タスクは上流のパーティションが未登録の状態でデータリクエストを行う可能性がある。notifyPartitionCreatedにより、パーティション登録完了を待機中のリクエストに通知し、データ転送を開始できる。

**通知の送信タイミング**：ResultPartitionManagerのregisterResultPartition()メソッドが呼び出され、新しいパーティションが登録された際に、そのパーティションを待機中の全PartitionRequestListenerに対して通知が発行される。

**通知の受信者**：PartitionRequestListenerインターフェースを実装するクラス（NettyPartitionRequestListenerなど）が受信者となる。

**通知内容の概要**：登録されたResultPartitionへの参照が通知される。受信者はこのパーティションに対してサブパーティションビューを作成できる。

**期待されるアクション**：受信者は、通知されたパーティションに対してcreateSubpartitionView()を呼び出し、データ読み取りの準備を完了する。その後、通常のデータ転送処理が開始される。

## 通知種別

内部コールバック（Javaメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（パーティション登録スレッドから呼び出し） |
| 優先度 | 高（データ転送開始に直結） |
| リトライ | なし |

### 送信先決定ロジック

ResultPartitionManagerに登録されたPartitionRequestListenerManagerから、該当パーティションIDに対応するリスナーを取得して通知する。

## 通知テンプレート

### コールバックシグネチャ

```java
void notifyPartitionCreated(ResultPartition partition) throws IOException;
```

### パラメータ詳細

| パラメータ名 | 型 | 説明 |
|------------|-----|------|
| partition | ResultPartition | 作成されたパーティション |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| partition | 登録されたパーティション | ResultPartitionManagerから取得 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| パーティション登録 | registerResultPartition() | 待機中のリスナーがある場合 | 上流タスクのデプロイ時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 待機リスナーなし | listenerManagerがnullまたは空の場合 |
| シャットダウン中 | isShutdownがtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[registerResultPartition呼び出し] --> B{シャットダウン中?}
    B -->|Yes| C[例外スロー]
    B -->|No| D[パーティション登録]
    D --> E{待機リスナーあり?}
    E -->|No| F[処理終了]
    E -->|Yes| G[リスナー取得]
    G --> H[notifyPartitionCreated呼び出し]
    H --> I{次のリスナーあり?}
    I -->|Yes| H
    I -->|No| F
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースアクセスは発生しない（インメモリ処理）。

### 更新テーブル一覧

データベース更新は発生しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IOException | サブパーティションビュー作成失敗 | 例外が上位に伝播 |
| 重複登録 | 同じIDのパーティションが既に登録 | IllegalStateException |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（タスクデプロイ頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし（24時間稼働）

## セキュリティ考慮事項

- 通知はJVM内部のメソッド呼び出しで完結
- パーティション情報は内部制御情報のみ

## 備考

- Netty経由でのリモート通信に使用される
- 登録後、待機中のリスナーマネージャはクリアされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ResultPartition.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartition.java` | パーティション構造 |
| 1-2 | ResultPartitionID.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartitionID.java` | パーティション識別子 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListener.java` | インターフェース定義（63-67行目） |

**主要処理フロー**:
1. **行63-67**: notifyPartitionCreatedメソッドのJavadoc
2. **行67**: void notifyPartitionCreated(ResultPartition partition) throws IOException

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResultPartitionManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartitionManager.java` | 登録処理（85-107行目） |

**主要処理フロー**:
- **行85-107**: registerResultPartition()メソッド
- **行97**: listenerManagers.remove()でリスナー取得
- **行100-103**: 全リスナーへの通知ループ

#### Step 4: リスナー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | NettyPartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/NettyPartitionRequestListener.java` | Netty実装（90-93行目） |

### プログラム呼び出し階層図

```
タスクデプロイ
    │
    └─ ResultPartitionManager.registerResultPartition(partition)
           │
           ├─ synchronized(registeredPartitions)
           │      │
           │      ├─ registeredPartitions.put()
           │      │
           │      └─ listenerManagers.remove()
           │
           └─ for (PartitionRequestListener listener : ...)
                  │
                  └─ listener.notifyPartitionCreated(partition)
                         │
                         └─ NettyPartitionRequestListener
                                │
                                └─ reader.notifySubpartitionsCreated()
```

### データフロー図

```
[入力]               [処理]                    [出力]

パーティション ───▶ ResultPartitionManager ───▶ PartitionRequestListener
登録                    │                          │
                        ├─ パーティション管理       └─ サブパーティション
                        └─ リスナー管理               ビュー作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListener.java` | インターフェース | リスナーインターフェース定義 |
| ResultPartitionManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartitionManager.java` | 実装クラス | パーティション管理 |
| NettyPartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/NettyPartitionRequestListener.java` | リスナー実装 | Netty層での処理 |
| PartitionRequestListenerManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListenerManager.java` | マネージャ | リスナー管理 |
| ResultPartition.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartition.java` | データ構造 | パーティション |
