# 通知設計書 19-notifyPartitionCreatedTimeout

## 概要

本ドキュメントは、Apache Flinkのパーティション作成タイムアウト通知（notifyPartitionCreatedTimeout）の設計仕様を記述したものである。

### 本通知の処理概要

notifyPartitionCreatedTimeoutは、パーティションリクエストリスナーが一定時間内にパーティション作成通知を受け取れなかった場合に、タイムアウトを通知するメカニズムである。これにより、待機中の下流タスクに対してエラーを通知し、適切なエラーハンドリングを行える。

**業務上の目的・背景**：分散システムでは、上流タスクのデプロイ失敗や遅延により、パーティションが登録されない場合がある。この場合、下流タスクが無限に待機することを防ぐため、タイムアウト機構が必要である。PartitionNotFoundExceptionを送信することで、下流タスクは再試行やエラー報告を行える。

**通知の送信タイミング**：ResultPartitionManagerのcheckRequestPartitionListeners()メソッドが定期実行され、リスナーの作成時刻からpartitionListenerTimeout時間が経過した場合に通知が発行される。また、releasePartition()やshutdown()時にも発行される。

**通知の受信者**：PartitionRequestListenerインターフェースを実装するクラス（NettyPartitionRequestListenerなど）が受信者となる。

**通知内容の概要**：パラメータなしの通知。受信者はPartitionNotFoundExceptionを下流に送信する。

**期待されるアクション**：受信者は、PartitionNotFoundExceptionを下流タスクに送信し、パーティションが見つからなかったことを通知する。下流タスクは再試行またはエラー処理を行う。

## 通知種別

内部コールバック（Javaメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（タイムアウトチェックスレッドから呼び出し） |
| 優先度 | 高（エラー通知に直結） |
| リトライ | なし |

### 送信先決定ロジック

タイムアウトが発生したPartitionRequestListenerに対して通知される。checkRequestPartitionListeners()で定期的にチェックされる。

## 通知テンプレート

### コールバックシグネチャ

```java
void notifyPartitionCreatedTimeout();
```

### パラメータ詳細

パラメータなし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| - | パラメータなし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期チェック | checkRequestPartitionListeners() | 作成時刻から閾値経過 | ScheduledExecutorで定期実行 |
| パーティション解放 | releasePartition() | リスナーがある場合 | パーティション解放時 |
| シャットダウン | shutdown() | リスナーがある場合 | マネージャシャットダウン時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| タイムアウト前 | 作成時刻から閾値が経過していない場合 |
| パーティション登録済み | パーティションが既に登録されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[checkRequestPartitionListeners定期実行] --> B{シャットダウン中?}
    B -->|Yes| C[処理終了]
    B -->|No| D[リスナーマネージャ走査]
    D --> E{タイムアウト?}
    E -->|No| F[次のリスナーへ]
    E -->|Yes| G[タイムアウトリスナーリストに追加]
    G --> H{全リスナー確認完了?}
    H -->|No| D
    H -->|Yes| I[タイムアウトリスナーに通知]
    I --> J[notifyPartitionCreatedTimeout呼び出し]
    J --> K{次のタイムアウトリスナーあり?}
    K -->|Yes| J
    K -->|No| C
    F --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

データベースアクセスは発生しない（インメモリ処理）。

### 更新テーブル一覧

データベース更新は発生しない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | notifyPartitionCreatedTimeout内で例外発生 | 例外を無視して次のリスナーへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（タイムアウト発生頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし（24時間稼働）

## セキュリティ考慮事項

- 通知はJVM内部のメソッド呼び出しで完結
- タイムアウト情報は内部制御情報のみ

## 備考

- partitionListenerTimeoutはResultPartitionManager初期化時に設定
- タイムアウトチェックはScheduledExecutorで定期実行（間隔はpartitionListenerTimeout）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PartitionNotFoundException.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionNotFoundException.java` | 例外クラス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListener.java` | インターフェース定義（69-73行目） |

**主要処理フロー**:
1. **行69-73**: notifyPartitionCreatedTimeoutメソッドのJavadoc
2. **行73**: void notifyPartitionCreatedTimeout()

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResultPartitionManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartitionManager.java` | タイムアウトチェック（235-258行目） |

**主要処理フロー**:
- **行235-258**: checkRequestPartitionListeners()メソッド
- **行248-249**: removeExpiration()でタイムアウトリスナー収集
- **行255-257**: 全タイムアウトリスナーへの通知ループ

#### Step 4: リスナー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | NettyPartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/NettyPartitionRequestListener.java` | Netty実装（96-98行目） |

### プログラム呼び出し階層図

```
ScheduledExecutor定期実行
    │
    └─ ResultPartitionManager.checkRequestPartitionListeners()
           │
           ├─ synchronized(registeredPartitions)
           │      │
           │      └─ partitionRequestListeners.removeExpiration()
           │
           └─ for (PartitionRequestListener listener : timeoutListeners)
                  │
                  └─ listener.notifyPartitionCreatedTimeout()
                         │
                         └─ NettyPartitionRequestListener
                                │
                                └─ reader.notifyPartitionRequestTimeout()
                                       │
                                       └─ PartitionNotFoundException送信
```

### データフロー図

```
[入力]               [処理]                    [出力]

タイムアウト ───▶ ResultPartitionManager ───▶ PartitionRequestListener
チェック                │                          │
                        ├─ リスナー走査            └─ PartitionNotFoundException
                        └─ 期限切れ判定               を下流に送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListener.java` | インターフェース | リスナーインターフェース定義 |
| ResultPartitionManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/ResultPartitionManager.java` | 実装クラス | パーティション管理とタイムアウトチェック |
| NettyPartitionRequestListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/netty/NettyPartitionRequestListener.java` | リスナー実装 | Netty層での処理 |
| PartitionRequestListenerManager.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionRequestListenerManager.java` | マネージャ | リスナー管理 |
| PartitionNotFoundException.java | `flink-runtime/src/main/java/org/apache/flink/runtime/io/network/partition/PartitionNotFoundException.java` | 例外クラス | パーティション未検出例外 |
