# 通知設計書 2-notifyCheckpointAborted

## 概要

本ドキュメントは、Apache Flinkにおけるチェックポイント中断通知（notifyCheckpointAborted）の設計を記載する。分散チェックポイントが中断された際にリスナーに通知されるコールバック機能である。

### 本通知の処理概要

本通知は、Flinkの分散チェックポイント機構において、チェックポイントが何らかの理由で中断（abort）された際に、CheckpointListenerインターフェースを実装するコンポーネントに対して発行される内部通知である。

**業務上の目的・背景**：チェックポイントが失敗した際に、関連する一時リソースの早期クリーンアップを可能にするために必要である。ただし、この通知はデータの破棄を意図したものではなく、あくまで補助的なリソース管理のためのものである。チェックポイント包含契約に従い、中断されたチェックポイントのデータは次の成功するチェックポイントに含まれるべきである。

**通知の送信タイミング**：CheckpointCoordinatorがチェックポイントの中断を決定した後に発行される。中断の原因には、タイムアウト、タスクの失敗、DeclineCheckpointメッセージの受信などがある。

**通知の受信者**：CheckpointListenerインターフェースを実装する全てのコンポーネント。具体的には、StreamOperator、SourceReader、SplitEnumerator、OperatorCoordinator、およびユーザー定義関数（UDF）が対象となる。

**通知内容の概要**：中断されたチェックポイントのID（long型）のみが通知される。受信者はこのIDを使用して、対応するチェックポイントに関連する一時リソースのクリーンアップを実行できる。

**期待されるアクション**：受信者は、通知されたチェックポイントIDに関連する一時的なリソース（ローカルキャッシュ等）をクリーンアップできる。ただし、チェックポイント包含契約に従い、データの破棄は行わず、次のチェックポイントに含まれるようにする必要がある。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（RPC経由でタスクに送信後、タスク内で同期的に処理） |
| 優先度 | 中（早期クリーンアップのため、なるべく早く通知） |
| リトライ | なし（ベストエフォート通知） |

### 送信先決定ロジック

CheckpointListenerインターフェースを実装している全てのStreamOperatorおよびOperatorCoordinatorに対して通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
default void notifyCheckpointAborted(long checkpointId) throws Exception {}
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数: checkpointId - 中断されたチェックポイントのID（正の長整数）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| checkpointId | 中断されたチェックポイントの一意識別子 | CheckpointCoordinator.abortedCheckpointIds | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部イベント | CheckpointCoordinator.abortPendingCheckpoint | チェックポイントタイムアウト | タイムアウト時間内に完了しなかった場合 |
| 内部イベント | DeclineCheckpoint受信 | タスクがチェックポイントを拒否 | タスクでエラーが発生した場合等 |
| 内部イベント | ジョブ/タスク失敗 | チェックポイント実行中の失敗 | タスクの異常終了等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| タスクがクローズ済み | StreamOperatorWrapperがclosed=trueの場合、通知をスキップ |
| 既に通知済み | 同じcheckpointIdに対して既に通知済みの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[チェックポイント中断イベント発生] --> B[CheckpointCoordinator.abortPendingCheckpoint]
    B --> C[Execution.notifyCheckpointAborted呼び出し]
    C --> D[TaskManagerGateway経由でタスクに送信]
    D --> E[Task.notifyCheckpointAborted]
    E --> F[StreamTask.notifyCheckpointAbortedAsync]
    F --> G[SubtaskCheckpointCoordinatorImpl処理]
    G --> H[OperatorChain.notifyCheckpointAborted]
    H --> I{各オペレータに通知}
    I --> J[StreamOperator.notifyCheckpointAborted]
    J --> K[CheckpointListener.notifyCheckpointAborted]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ使用 |

### テーブル別参照項目詳細

内部通知のためデータベース参照なし。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | リスナー内で例外発生 | タスク/ジョブの失敗とリカバリをトリガー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし（ベストエフォート通知） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（チェックポイント中断時に即座に通知）

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- チェックポイントIDは順序保証のために使用され、機密情報は含まない

## 備考

- デフォルト実装は空（何も行わない）であり、必要に応じてオーバーライドする
- 「チェックポイント包含契約」に従い、中断されたチェックポイントのデータは破棄してはならない
- 次の成功するチェックポイントが、中断されたチェックポイントの範囲もカバーする
- この通知は主に一時リソースの早期クリーンアップに使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CheckpointListener.java | `flink-core/src/main/java/org/apache/flink/api/common/state/CheckpointListener.java` | notifyCheckpointAbortedメソッドのJavaDoc（124-146行目）を理解 |

**読解のコツ**: デフォルト実装が空であること、およびこのメソッドが「まれに必要」とされている理由を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CheckpointCoordinator.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/CheckpointCoordinator.java` | abortPendingCheckpointメソッドを確認 |

#### Step 3: タスクへの通知伝播を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SubtaskCheckpointCoordinatorImpl.java | `flink-runtime/src/main/java/org/apache/flink/streaming/runtime/tasks/SubtaskCheckpointCoordinatorImpl.java` | notifyCheckpointAbortedの処理（476行目） |
| 3-2 | RegularOperatorChain.java | `flink-runtime/src/main/java/org/apache/flink/streaming/runtime/tasks/RegularOperatorChain.java` | notifyCheckpointAbortedメソッド |

### プログラム呼び出し階層図

```
CheckpointCoordinator.abortPendingCheckpoint()
    │
    └─ Execution.notifyCheckpointAborted(checkpointId)
           │
           └─ TaskManagerGateway.notifyCheckpointAborted(...)
                  │
                  └─ Task.notifyCheckpointAborted(checkpointId)
                         │
                         └─ StreamTask処理
                                │
                                └─ SubtaskCheckpointCoordinatorImpl
                                       │
                                       └─ OperatorChain.notifyCheckpointAborted(checkpointId)
                                              │
                                              └─ StreamOperator.notifyCheckpointAborted(checkpointId)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

チェックポイント中断 ───▶ CheckpointCoordinator ───▶ TaskManagerGateway(RPC)
                                                          │
                                                          ▼
                                                        Task
                                                          │
                                                          ▼
                                                    StreamTask
                                                          │
                                                          ▼
                                              SubtaskCheckpointCoordinator
                                                          │
                                                          ▼
                                                    OperatorChain
                                                          │
                                                          ▼
                                                CheckpointListener
                                                (一時リソースクリーンアップ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CheckpointListener.java | `flink-core/src/main/java/org/apache/flink/api/common/state/CheckpointListener.java` | インターフェース | 通知を受け取るリスナーの契約定義 |
| CheckpointCoordinator.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/CheckpointCoordinator.java` | ソース | チェックポイント中断を管理し通知を発行 |
| SubtaskCheckpointCoordinatorImpl.java | `flink-runtime/src/main/java/org/apache/flink/streaming/runtime/tasks/SubtaskCheckpointCoordinatorImpl.java` | ソース | サブタスクレベルでの中断通知管理 |
| RegularOperatorChain.java | `flink-runtime/src/main/java/org/apache/flink/streaming/runtime/tasks/RegularOperatorChain.java` | ソース | オペレータチェーンへの通知伝播 |
