# 通知設計書 21-notifyKvStateRegistered

## 概要

本ドキュメントは、Apache Flink の KvState 登録通知（notifyKvStateRegistered）の詳細設計を記載したものである。KvState インスタンスがタスクマネージャに登録された際に、JobMaster へ通知を送信する仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：Apache Flink では、Queryable State 機能を用いて、実行中のジョブの状態をリアルタイムでクエリすることができる。KvState（Key-Value State）がタスクマネージャ上で登録されると、その情報をジョブマスターに伝達し、外部クライアントがクエリ可能な状態を発見できるようにする必要がある。本通知は、分散システムにおける状態の位置情報を一元管理するための重要な通信メカニズムである。

**通知の送信タイミング**：KvState インスタンスが作成または復元された際に、`KvStateRegistry.registerKvState()` メソッドが呼び出され、その内部で登録済みのリスナー（`KvStateRegistryListener`）に対して `notifyKvStateRegistered()` が呼び出される。具体的には、オペレータが初期化されて状態がセットアップされるタイミングで発生する。

**通知の受信者**：JobMaster（`KvStateRegistryGateway` を実装するコンポーネント）が受信者となる。`RpcKvStateRegistryListener` が中間層として RPC 経由で JobMaster に通知を転送する。

**通知内容の概要**：通知には、ジョブID、ジョブ頂点ID、キーグループ範囲、登録名、KvState ID、および KvState サーバのアドレスが含まれる。これらの情報により、クライアントは特定のキーに対応する状態がどのタスクマネージャ上に存在するかを特定できる。

**期待されるアクション**：JobMaster は受信した情報を `KvStateLocationRegistry` に登録し、外部クライアントからのクエリリクエストに対して適切なタスクマネージャへルーティングできるようにする。

## 通知種別

内部 RPC 通知（Flink RPC フレームワークによるプロセス間通信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（RPC） |
| 優先度 | 中 |
| リトライ | なし（RPC フレームワーク依存） |

### 送信先決定ロジック

`KvStateRegistry` に登録されている `KvStateRegistryListener` に対して通知が送信される。リスナーは `JobID` をキーとして登録されており、対応するジョブのリスナーが呼び出される。`HighAvailabilityServices.DEFAULT_JOB_ID` で登録されたレガシーリスナーも優先的にチェックされる。

## 通知テンプレート

### RPC 通知の場合

| 項目 | 内容 |
|-----|------|
| インターフェース | `KvStateRegistryGateway` |
| メソッド | `notifyKvStateRegistered` |
| 形式 | RPC メソッド呼び出し |

### パラメータ

```java
void notifyKvStateRegistered(
    JobID jobId,
    JobVertexID jobVertexId,
    KeyGroupRange keyGroupRange,
    String registrationName,
    KvStateID kvStateId,
    InetSocketAddress kvStateServerAddress
);
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobId | ジョブ識別子 | 実行コンテキスト | Yes |
| jobVertexId | ジョブ頂点識別子 | タスク情報 | Yes |
| keyGroupRange | キーグループ範囲 | 状態バックエンド | Yes |
| registrationName | 登録名 | 状態記述子 | Yes |
| kvStateId | KvState 識別子 | 新規生成（UUID） | Yes |
| kvStateServerAddress | サーバアドレス | タスクマネージャ設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 状態登録 | `registerKvState()` 呼び出し | リスナーが登録済み | Queryable State として設定された状態の登録時 |
| 状態復元 | チェックポイントからの復元 | リスナーが登録済み | 障害復旧時の状態再登録 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リスナー未登録 | `KvStateRegistryListener` が未登録の場合、通知は送信されない |
| ジョブ不一致 | 対応するジョブIDのリスナーが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[KvState 登録要求] --> B[KvStateRegistry.registerKvState]
    B --> C[KvStateID 生成]
    C --> D[状態をマップに登録]
    D --> E{リスナー登録済み?}
    E -->|Yes| F[listener.notifyKvStateRegistered]
    E -->|No| G[通知スキップ]
    F --> H[RpcKvStateRegistryListener]
    H --> I[RPC経由でJobMasterに通知]
    I --> J[KvStateLocationRegistry更新]
    J --> K[終了]
    G --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ管理）

### メモリ内データ構造

| データ構造 | クラス | 用途 | 備考 |
|-----------|------|------|------|
| registeredKvStates | `ConcurrentHashMap<KvStateID, KvStateEntry>` | 登録済み状態の管理 | KvStateRegistry |
| listeners | `ConcurrentHashMap<JobID, KvStateRegistryListener>` | リスナー管理 | KvStateRegistry |

### 更新データ一覧

| データ構造 | 操作 | 概要 |
|-----------|------|------|
| registeredKvStates | PUT | 新規 KvState の登録 |
| KvStateLocationRegistry | 更新 | JobMaster 側での位置情報登録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 同一 KvStateID の重複登録 | 例外をスロー |
| RPC失敗 | ネットワーク障害等 | RPC フレームワークに委任 |
| リスナー未登録 | JobID に対応するリスナーなし | 通知をスキップ（正常動作） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | RPC フレームワーク依存 |
| リトライ間隔 | RPC フレームワーク依存 |
| リトライ対象エラー | ネットワーク一時障害 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（システム稼働中常時）

## セキュリティ考慮事項

- KvState サーバアドレスは内部ネットワーク情報を含むため、外部に漏洩しないよう注意が必要
- RPC 通信は Flink の認証・暗号化設定に従う
- Queryable State 機能自体のアクセス制御は別途設定が必要

## 備考

- 本通知は Queryable State 機能が有効な場合にのみ使用される
- InternalCheckpointListener インターフェースとは異なり、外部からの状態クエリ用途に特化している
- 高可用性サービスのレガシーモードでは `DEFAULT_JOB_ID` が使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

KvState の識別に使用されるデータ構造と、通知パラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | KvStateID.java | `flink-queryable-state/flink-queryable-state-common/src/main/java/org/apache/flink/queryablestate/KvStateID.java` | UUID ベースの一意識別子 |
| 1-2 | KeyGroupRange.java | `flink-runtime/src/main/java/org/apache/flink/runtime/state/KeyGroupRange.java` | キーの並列処理範囲を表現 |

**読解のコツ**: `KvStateID` は単純な UUID ラッパーであり、状態インスタンスを一意に識別する。`KeyGroupRange` は Flink の並列処理モデルにおいてキーがどの範囲を担当するかを示す。

#### Step 2: エントリーポイントを理解する

通知の起点となる `KvStateRegistry` クラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | KvStateRegistry.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/KvStateRegistry.java` | 状態登録とリスナー通知のメインロジック |

**主要処理フロー**:
1. **行 85-113**: `registerKvState()` メソッド - 状態登録のエントリーポイント
2. **行 93**: 新規 `KvStateID` の生成
3. **行 95-96**: `registeredKvStates` マップへの登録
4. **行 97-102**: リスナーへの通知呼び出し

#### Step 3: リスナーインターフェースを理解する

通知を受け取るリスナーのインターフェース定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | KvStateRegistryListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/KvStateRegistryListener.java` | リスナーインターフェース定義 |

**主要処理フロー**:
- **行 42-47**: `notifyKvStateRegistered()` メソッドシグネチャ

#### Step 4: RPC 実装を理解する

実際の RPC 通信を行う実装クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RpcKvStateRegistryListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/rpc/RpcKvStateRegistryListener.java` | RPC 通信の実装 |

**主要処理フロー**:
- **行 44-57**: `notifyKvStateRegistered()` の実装 - Gateway 経由で JobMaster に通知

### プログラム呼び出し階層図

```
TaskManager (オペレータ初期化)
    │
    ├─ InternalKvState.setCurrentKey() / 状態アクセス
    │      └─ TaskKvStateRegistry.registerKvState()
    │              └─ KvStateRegistry.registerKvState()  [行 85-113]
    │                      │
    │                      ├─ KvStateID 生成  [行 93]
    │                      ├─ registeredKvStates.putIfAbsent()  [行 95]
    │                      └─ listener.notifyKvStateRegistered()  [行 100-101]
    │                              └─ RpcKvStateRegistryListener.notifyKvStateRegistered()
    │                                      └─ KvStateRegistryGateway.notifyKvStateRegistered() [RPC]
    │
    └─ JobMaster (受信側)
            └─ KvStateLocationRegistry.notifyKvStateRegistered()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

InternalKvState     ───▶  KvStateRegistry           ───▶  RPC 通知
(状態インスタンス)           (登録・ID発行)                  (JobMaster へ)
      │                          │                            │
      │                          ▼                            ▼
      │               registeredKvStates Map          KvStateLocationRegistry
      │               (ローカル管理)                   (グローバル位置情報)
      │                          │
      └──────────────────────────┘
              状態メタデータ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| KvStateRegistry.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/` | ソース | 状態登録管理 |
| KvStateRegistryListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/` | ソース | リスナーインターフェース |
| RpcKvStateRegistryListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/rpc/` | ソース | RPC 実装 |
| KvStateRegistryGateway.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/` | ソース | RPC ゲートウェイ |
| KvStateLocationRegistry.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/` | ソース | 位置情報管理 |
| TaskKvStateRegistry.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/` | ソース | タスク用ファサード |
| KvStateEntry.java | `flink-runtime/src/main/java/org/apache/flink/runtime/query/` | ソース | 状態エントリ |
