# 通知設計書 25-jobManagerRejectedRegistration

## 概要

本ドキュメントは、Apache Flink の JobManager 登録拒否通知（jobManagerRejectedRegistration）の詳細設計を記載したものである。タスクマネージャのジョブマネージャへの接続試行が拒否された際に、タスクエグゼキュータに通知する仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：タスクマネージャがジョブマネージャに登録しようとする際、様々な理由で拒否される可能性がある。例えば、リソースプロファイルの不一致、ジョブの状態異常、またはセキュリティ上の問題などが考えられる。本通知は、拒否された理由を明確に伝達し、タスクエグゼキュータが適切な対応（ログ記録、代替処理、エラー報告等）を行えるようにするための重要な通信メカニズムである。

**通知の送信タイミング**：`DefaultJobLeaderService` 内の `JobManagerRegisteredRpcConnection` が `onRegistrationRejection()` コールバックを受信した際に発生する。これは、ジョブマスターが `registerTaskManager()` RPC 呼び出しに対して拒否レスポンスを返した場合である。

**通知の受信者**：`TaskExecutor` 内の `JobLeaderListenerImpl` が受信者となる。`JobLeaderService` を通じてタスクエグゼキュータに通知が配信される。

**通知内容の概要**：通知には、ジョブID、対象のジョブマネージャアドレス、および拒否理由を含む `JMTMRegistrationRejection` オブジェクトが含まれる。これにより、タスクエグゼキュータは拒否の詳細を把握できる。

**期待されるアクション**：タスクエグゼキュータは、`handleRejectedJobManagerConnection()` メソッドを呼び出して、拒否された接続に対する適切な処理（ログ記録、ジョブテーブルからの削除、再試行判断等）を行う。

## 通知種別

内部コールバック通知（Java インターフェースコールバック）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Executor 経由） |
| 優先度 | 高 |
| リトライ | 拒否のため再試行なし |

### 送信先決定ロジック

`DefaultJobLeaderService` に登録された `JobLeaderListener` に対して通知が送信される。RPC 登録が拒否された場合、現在のセッションIDが有効であるかを確認した上で、コールバックが実行される。

## 通知テンプレート

### コールバック通知の場合

| 項目 | 内容 |
|-----|------|
| インターフェース | `JobLeaderListener` |
| メソッド | `jobManagerRejectedRegistration` |
| 形式 | Java インターフェースコールバック |

### パラメータ

```java
void jobManagerRejectedRegistration(
    JobID jobId,
    String targetAddress,
    JMTMRegistrationRejection rejection
);
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobId | ジョブ識別子 | ジョブリーダーサービス | Yes |
| targetAddress | ジョブマネージャアドレス | RPC 接続情報 | Yes |
| rejection | 拒否理由 | ジョブマスターからのレスポンス | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 登録拒否 | `onRegistrationRejection()` | 登録が有効な場合 | ジョブマスターからの拒否レスポンス |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 無効なセッション | リーダーセッションIDが現在のものと一致しない場合 |
| サービス停止 | JobLeaderService が停止済みの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[登録RPC実行] --> B[registerTaskManager]
    B --> C{登録結果}
    C -->|成功| D[onRegistrationSuccess]
    C -->|拒否| E[onRegistrationRejection]
    C -->|失敗| F[onRegistrationFailure]
    E --> G{有効なセッション?}
    G -->|No| H[ログ出力して終了]
    G -->|Yes| I[ログ出力]
    I --> J[jobLeaderListener.jobManagerRejectedRegistration]
    J --> K[TaskExecutor.runAsync]
    K --> L[handleRejectedJobManagerConnection]
    L --> M[終了]
    H --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ管理）

### メモリ内データ構造

| データ構造 | クラス | 用途 | 備考 |
|-----------|------|------|------|
| currentJobMasterId | `JobMasterId` | 現在のリーダーID | セッション検証用 |

### 更新データ一覧

| データ構造 | 操作 | 概要 |
|-----------|------|------|
| jobTable | 更新可能 | 拒否されたジョブの処理 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 登録拒否 | ジョブマスターからの明示的な拒否 | handleRejectedJobManagerConnection で処理 |
| 無効なセッション | リーダー変更後の古いレスポンス | ログ出力してスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（拒否は明示的な結果） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（システム稼働中常時）

## セキュリティ考慮事項

- 拒否理由にセンシティブな情報が含まれる可能性があるため、ログ出力時に注意が必要
- 拒否はセキュリティ違反を示す可能性があり、適切な監査が推奨される

## 備考

- 本通知は `JMTMRegistrationRejection` クラスに拒否の詳細情報が含まれる
- 登録失敗（`onRegistrationFailure`）とは異なり、明示的な拒否である点に注意
- タスクマネージャ側で自動リトライは行われない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知パラメータと拒否理由の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JMTMRegistrationRejection.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/` | 拒否理由の構造 |

**読解のコツ**: `JMTMRegistrationRejection` には拒否の理由を説明する情報が含まれる。

#### Step 2: エントリーポイントを理解する

リスナーインターフェースと通知の起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JobLeaderListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | リスナーインターフェース定義 |

**主要処理フロー**:
- **行 63-72**: `jobManagerRejectedRegistration()` メソッドシグネチャ
- パラメータは `jobId`, `targetAddress`, `rejection` の3つ

#### Step 3: 通知送信ロジックを理解する

DefaultJobLeaderService での通知生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefaultJobLeaderService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | ジョブリーダーサービス実装 |

**主要処理フロー**:
1. **行 432-450**: `onRegistrationRejection()` - 登録拒否時のコールバック
2. **行 434-443**: `runIfValidRegistrationAttemptOrElse()` で有効性チェック
3. **行 435-438**: ログ出力
4. **行 440-442**: `jobLeaderListener.jobManagerRejectedRegistration()` の呼び出し

#### Step 4: 受信側の処理を理解する

TaskExecutor での通知受信処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TaskExecutor.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | タスクエグゼキュータ実装 |

**主要処理フロー**:
- **行 2571-2575**: `JobLeaderListenerImpl.jobManagerRejectedRegistration()` の実装
- **行 2574**: `runAsync()` で非同期に `handleRejectedJobManagerConnection()` を呼び出し

### プログラム呼び出し階層図

```
JobManagerRetryingRegistration (RPC登録)
    │
    ├─ invokeRegistration()  [行 516-521]
    │      └─ gateway.registerTaskManager()  [RPC]
    │
    └─ 結果に応じたコールバック
            │
            ├─ onRegistrationSuccess()  [成功時]
            ├─ onRegistrationRejection()  [拒否時, 行 432-450]
            │      │
            │      ├─ 有効性チェック  [行 434, 470-477]
            │      ├─ ログ出力  [行 435-438]
            │      └─ jobLeaderListener.jobManagerRejectedRegistration()  [行 440-442]
            │              └─ TaskExecutor.JobLeaderListenerImpl  [行 2571-2575]
            │                      └─ runAsync()  [行 2574]
            │                              └─ handleRejectedJobManagerConnection()
            │
            └─ onRegistrationFailure()  [失敗時]
```

### データフロー図

```
[入力]                        [処理]                         [出力]

RPC拒否レスポンス      ───▶  DefaultJobLeaderService   ───▶  コールバック通知
(JMTMRegistrationRejection)  (有効性チェック)               (TaskExecutor へ)
      │                              │                            │
      │                              ▼                            ▼
      │               runIfValidRegistrationAttemptOrElse   JobLeaderListener
      │               (セッションID検証)                     .jobManagerRejectedRegistration()
      │                              │                            │
      │                              ▼                            ▼
      │                    ログ出力                       handleRejectedJobManagerConnection()
      │                                                    (拒否処理)
      │                              │
      └──────────────────────────────┘
              拒否情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JobLeaderListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | ソース | リスナーインターフェース |
| DefaultJobLeaderService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | ソース | ジョブリーダーサービス実装 |
| TaskExecutor.java | `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/` | ソース | タスクエグゼキュータ（受信側） |
| JMTMRegistrationRejection.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/` | ソース | 拒否理由 |
| RegisteredRpcConnection.java | `flink-runtime/src/main/java/org/apache/flink/runtime/registration/` | ソース | RPC 接続管理 |
| RetryingRegistration.java | `flink-runtime/src/main/java/org/apache/flink/runtime/registration/` | ソース | リトライ登録 |
