# 通知設計書 4-onCompletedCheckpoint

## 概要

本ドキュメントは、Apache Flinkにおけるチェックポイント完了コールバック（onCompletedCheckpoint）の設計を記載する。チェックポイントが正常に完了した際に呼び出される統計収集用のコールバック機能である。

### 本通知の処理概要

本通知は、Flinkのチェックポイント統計追跡機構において、チェックポイントが正常に完了した際にCheckpointStatsListenerインターフェースを実装するコンポーネントに対して発行されるコールバックである。

**業務上の目的・背景**：チェックポイントの統計情報（成功回数、実行時間等）を収集し、モニタリングやメトリクス報告に使用するために必要である。この情報は、ジョブの健全性監視やパフォーマンスチューニングに活用される。特にAdaptiveSchedulerにおいて、チェックポイントの完了状況を追跡するために使用される。

**通知の送信タイミング**：DefaultCheckpointStatsTrackerがチェックポイントの完了を記録した際に発行される。具体的には、CompletedCheckpointStatがトラッカーに報告された後に通知される。

**通知の受信者**：CheckpointStatsListenerインターフェースを実装するコンポーネント。主にAdaptiveScheduler、Executingステートなどのスケジューラコンポーネントが対象。

**通知内容の概要**：引数なしのコールバック。チェックポイントが完了したという事実のみが通知される。詳細な統計情報は別途CheckpointStatsTrackerから取得可能。

**期待されるアクション**：受信者は、チェックポイント完了をモニタリングシステムに記録したり、スケーリング判断の材料として利用したりする。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し、統計収集用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低（統計収集用） |
| リトライ | なし |

### 送信先決定ロジック

CheckpointStatsListenerインターフェースを実装し、DefaultCheckpointStatsTrackerに登録されているコンポーネントに対して通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
default void onCompletedCheckpoint() {
    // No-op.
}
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数: なし
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 引数なしのコールバック | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部イベント | DefaultCheckpointStatsTracker.reportCompletedCheckpoint | チェックポイント完了記録時 | 完了統計の記録後に通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リスナー未登録 | CheckpointStatsListenerが登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[チェックポイント完了] --> B[CheckpointCoordinator.completePendingCheckpoint]
    B --> C[DefaultCheckpointStatsTracker.reportCompletedCheckpoint]
    C --> D[統計情報の更新]
    D --> E{リスナー登録あり?}
    E -->|Yes| F[CheckpointStatsListener.onCompletedCheckpoint]
    E -->|No| G[終了]
    F --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 内部メモリ上の統計情報のみ更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | リスナー内で例外発生 | ログ出力、処理継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（チェックポイント頻度に依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- 統計情報のみを扱い、機密データは含まない

## 備考

- デフォルト実装は空（No-op）
- 統計収集とモニタリング目的のコールバック
- onFailedCheckpointと対になるメソッド

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CheckpointStatsListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/CheckpointStatsListener.java` | インターフェース定義（22-33行目） |

**読解のコツ**: デフォルト実装がNo-opであること、およびチェックポイントライフサイクルを監視するためのインターフェースであることを理解する。

#### Step 2: 通知発行元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DefaultCheckpointStatsTracker.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/DefaultCheckpointStatsTracker.java` | リスナーへの通知呼び出し箇所 |

#### Step 3: 利用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdaptiveScheduler.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/AdaptiveScheduler.java` | リスナー実装例 |
| 3-2 | Executing.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/Executing.java` | リスナー実装例 |

### プログラム呼び出し階層図

```
CheckpointCoordinator.completePendingCheckpoint()
    │
    └─ DefaultCheckpointStatsTracker.reportCompletedCheckpoint(...)
           │
           └─ CheckpointStatsListener.onCompletedCheckpoint()
                  │
                  └─ AdaptiveScheduler / Executing (実装例)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

チェックポイント完了 ───▶ CheckpointCoordinator ───▶ DefaultCheckpointStatsTracker
                                                          │
                                                          ▼
                                               CheckpointStatsListener
                                                (統計情報の記録/通知)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CheckpointStatsListener.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/CheckpointStatsListener.java` | インターフェース | 統計リスナーの契約定義 |
| DefaultCheckpointStatsTracker.java | `flink-runtime/src/main/java/org/apache/flink/runtime/checkpoint/DefaultCheckpointStatsTracker.java` | ソース | 統計追跡と通知発行 |
| AdaptiveScheduler.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/AdaptiveScheduler.java` | ソース | リスナー実装例 |
| Executing.java | `flink-runtime/src/main/java/org/apache/flink/runtime/scheduler/adaptive/Executing.java` | ソース | リスナー実装例 |
