# 通知設計書 6-onJobSubmitted

## 概要

本ドキュメントは、Apache Flinkにおけるジョブ送信通知（onJobSubmitted）の設計を記載する。execute()またはexecuteAsync()が呼び出された際にリスナーに通知されるコールバック機能である。

### 本通知の処理概要

本通知は、Flinkのジョブ実行機構において、ジョブがクラスタに送信された際にJobListenerインターフェースを実装するコンポーネントに対して発行されるコールバックである。

**業務上の目的・背景**：ジョブの送信状況を監視し、外部システムとの連携（ログ記録、通知送信、メトリクス収集等）を実現するために必要である。ジョブの送信成功時にはJobClientを、失敗時にはThrowableを受け取ることで、適切な後続処理を行うことができる。

**通知の送信タイミング**：StreamExecutionEnvironmentのexecute()またはexecuteAsync()が呼び出され、ジョブがクラスタに送信された直後に発行される。送信の成否に関わらず通知される。

**通知の受信者**：JobListenerインターフェースを実装し、StreamExecutionEnvironment.registerJobListener()で登録されたコンポーネント。ユーザー定義のリスナーが主な対象。

**通知内容の概要**：送信成功時はJobClient（nullでない）とnullのThrowable、送信失敗時はnullのJobClientとThrowable（nullでない）が渡される。引数の一方は必ずnullとなる。

**期待されるアクション**：受信者は、送信成功時にジョブIDの記録や監視開始を行い、送信失敗時にはエラーログ記録やアラート発報を行う。ブロッキング操作は非推奨。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（ジョブ送信直後に通知） |
| リトライ | なし |

### 送信先決定ロジック

StreamExecutionEnvironmentに登録された全てのJobListenerに対して、登録順に通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
void onJobSubmitted(@Nullable JobClient jobClient, @Nullable Throwable throwable);
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数:
  - jobClient: 送信成功時は有効なJobClient、失敗時はnull
  - throwable: 送信失敗時は例外、成功時はnull
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobClient | 送信されたジョブへのクライアントインターフェース | PipelineExecutor | 条件付き |
| throwable | 送信失敗時の例外 | PipelineExecutor | 条件付き |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | execute() | ジョブ送信完了/失敗 | 同期実行時 |
| API呼び出し | executeAsync() | ジョブ送信完了/失敗 | 非同期実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リスナー未登録 | JobListenerが登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[execute/executeAsync呼び出し] --> B[StreamGraph生成]
    B --> C[PipelineExecutor.execute]
    C --> D{送信結果}
    D -->|成功| E[JobClient取得]
    D -->|失敗| F[Throwable取得]
    E --> G[JobListener.onJobSubmitted呼び出し]
    F --> G
    G --> H[各リスナーに通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | リスナー側で必要に応じて記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | リスナー内で例外発生 | ログ出力、他のリスナーへの通知は継続 |
| 送信失敗 | クラスタ接続エラー等 | throwableパラメータで通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- JobClientを通じてジョブの制御が可能なため、リスナー実装には注意が必要
- ブロッキング操作はexecute()の呼び出し元をブロックする可能性がある

## 備考

- ブロッキング操作は非推奨（execute()の呼び出しをブロックする可能性）
- 引数のjobClientとthrowableは排他的（一方が必ずnull）
- onJobExecutedと対になるメソッド
- executeAsync()でも呼び出される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JobListener.java | `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java` | インターフェース定義（27-45行目） |

**読解のコツ**: @Nullableアノテーションの意味、およびブロッキング操作が非推奨である理由を理解する。

#### Step 2: 通知発行元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamExecutionEnvironment.java | `flink-runtime/src/main/java/org/apache/flink/streaming/api/environment/StreamExecutionEnvironment.java` | execute()とjobListenersフィールド |
| 2-2 | StreamContextEnvironment.java | `flink-clients/src/main/java/org/apache/flink/client/program/StreamContextEnvironment.java` | リスナー通知の実装 |

### プログラム呼び出し階層図

```
StreamExecutionEnvironment.execute()
    │
    ├─ getStreamGraph()
    │
    └─ executeAsync(StreamGraph)
           │
           └─ PipelineExecutor.execute(...)
                  │
                  └─ JobClient作成 or 例外発生
                         │
                         └─ JobListener.onJobSubmitted(jobClient, throwable)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

execute()/executeAsync() ───▶ StreamExecutionEnvironment ───▶ PipelineExecutor
                                       │                           │
                                       │                           ▼
                                       │                      JobClient/例外
                                       │                           │
                                       │                           ▼
                                       └───────────────────▶ JobListener
                                                          (onJobSubmitted呼び出し)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JobListener.java | `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java` | インターフェース | ジョブリスナーの契約定義 |
| StreamExecutionEnvironment.java | `flink-runtime/src/main/java/org/apache/flink/streaming/api/environment/StreamExecutionEnvironment.java` | ソース | 実行環境とリスナー管理 |
| StreamContextEnvironment.java | `flink-clients/src/main/java/org/apache/flink/client/program/StreamContextEnvironment.java` | ソース | リスナー通知の実装 |
| JobClient.java | `flink-core/src/main/java/org/apache/flink/core/execution/JobClient.java` | インターフェース | ジョブ制御クライアント |
