# 通知設計書 7-onJobExecuted

## 概要

本ドキュメントは、Apache Flinkにおけるジョブ実行完了通知（onJobExecuted）の設計を記載する。execute()メソッドでジョブが完了した際にリスナーに通知されるコールバック機能である。

### 本通知の処理概要

本通知は、Flinkのジョブ実行機構において、ジョブの実行が完了（成功または失敗）した際にJobListenerインターフェースを実装するコンポーネントに対して発行されるコールバックである。

**業務上の目的・背景**：ジョブの実行完了を監視し、後続処理のトリガー、ログ記録、メトリクス収集などを実現するために必要である。ジョブの実行成功時にはJobExecutionResultを、失敗時にはThrowableを受け取ることで、適切な後続処理を行うことができる。

**通知の送信タイミング**：StreamExecutionEnvironmentのexecute()メソッドでジョブが完了した際に発行される。重要な点として、executeAsync()メソッドでは呼び出されない。

**通知の受信者**：JobListenerインターフェースを実装し、StreamExecutionEnvironment.registerJobListener()で登録されたコンポーネント。ユーザー定義のリスナーが主な対象。

**通知内容の概要**：実行成功時はJobExecutionResult（nullでない）とnullのThrowable、実行失敗時はnullのJobExecutionResultとThrowable（nullでない）が渡される。引数の一方は必ずnullとなる。

**期待されるアクション**：受信者は、実行成功時に結果の記録や後続処理の開始を行い、実行失敗時にはエラーログ記録やアラート発報、リトライ処理の開始などを行う。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（ジョブ完了直後に通知） |
| リトライ | なし |

### 送信先決定ロジック

StreamExecutionEnvironmentに登録された全てのJobListenerに対して、登録順に通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
void onJobExecuted(@Nullable JobExecutionResult jobExecutionResult, @Nullable Throwable throwable);
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数:
  - jobExecutionResult: 実行成功時は有効なJobExecutionResult、失敗時はnull
  - throwable: 実行失敗時は例外、成功時はnull
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobExecutionResult | ジョブ実行結果（アキュムレータ結果等を含む） | JobClient.getJobExecutionResult() | 条件付き |
| throwable | 実行失敗時の例外 | ジョブ実行エラー | 条件付き |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | execute() | ジョブ実行完了/失敗 | 同期実行時のみ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| executeAsync()使用時 | 非同期実行ではこのコールバックは呼び出されない |
| リスナー未登録 | JobListenerが登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[execute呼び出し] --> B[ジョブ送信]
    B --> C[ジョブ実行待機]
    C --> D{実行結果}
    D -->|成功| E[JobExecutionResult取得]
    D -->|失敗| F[Throwable取得]
    E --> G[JobListener.onJobExecuted呼び出し]
    F --> G
    G --> H[各リスナーに通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | リスナー側で必要に応じて記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | リスナー内で例外発生 | ログ出力、他のリスナーへの通知は継続 |
| 実行失敗 | ジョブ実行中のエラー | throwableパラメータで通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- JobExecutionResultにはアキュムレータの結果が含まれる可能性がある

## 備考

- executeAsync()では呼び出されない（重要な制限）
- 引数のjobExecutionResultとthrowableは排他的（一方が必ずnull）
- onJobSubmittedと対になるメソッド
- 同期実行（execute()）専用のコールバック

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JobListener.java | `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java` | インターフェース定義（47-55行目） |
| 1-2 | JobExecutionResult.java | `flink-core/src/main/java/org/apache/flink/api/common/JobExecutionResult.java` | 実行結果の構造 |

**読解のコツ**: executeAsync()では呼び出されないという重要な制限を理解する。

#### Step 2: 通知発行元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamExecutionEnvironment.java | `flink-runtime/src/main/java/org/apache/flink/streaming/api/environment/StreamExecutionEnvironment.java` | execute()メソッドの実装 |
| 2-2 | StreamContextEnvironment.java | `flink-clients/src/main/java/org/apache/flink/client/program/StreamContextEnvironment.java` | リスナー通知の実装 |

### プログラム呼び出し階層図

```
StreamExecutionEnvironment.execute()
    │
    ├─ executeAsync(StreamGraph)
    │      │
    │      └─ JobClient取得
    │
    └─ jobClient.getJobExecutionResult().get()
           │
           └─ JobExecutionResult取得 or 例外発生
                  │
                  └─ JobListener.onJobExecuted(result, throwable)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

execute() ───▶ StreamExecutionEnvironment ───▶ ジョブ実行待機
                      │                              │
                      │                              ▼
                      │                     JobExecutionResult/例外
                      │                              │
                      │                              ▼
                      └─────────────────────▶ JobListener
                                          (onJobExecuted呼び出し)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JobListener.java | `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java` | インターフェース | ジョブリスナーの契約定義 |
| JobExecutionResult.java | `flink-core/src/main/java/org/apache/flink/api/common/JobExecutionResult.java` | クラス | 実行結果の構造定義 |
| StreamExecutionEnvironment.java | `flink-runtime/src/main/java/org/apache/flink/streaming/api/environment/StreamExecutionEnvironment.java` | ソース | 実行環境とリスナー管理 |
| StreamContextEnvironment.java | `flink-clients/src/main/java/org/apache/flink/client/program/StreamContextEnvironment.java` | ソース | リスナー通知の実装 |
