# 通知設計書 8-grantLeadership

## 概要

本ドキュメントは、Apache Flinkにおけるリーダー権限付与通知（grantLeadership）の設計を記載する。リーダー選出サービスにより当該インスタンスが新しいリーダーとして選出された際にコールバックされる機能である。

### 本通知の処理概要

本通知は、Flinkの高可用性（HA）機構において、リーダー選出サービス（LeaderElectionService）がLeaderContenderインターフェースを実装するコンポーネントに対して発行するコールバックである。

**業務上の目的・背景**：分散システムにおける高可用性を実現するために、リーダー選出が必要である。Flinkでは、JobManager、ResourceManager、Dispatcher、WebMonitorEndpointなどの重要なコンポーネントがリーダー選出に参加し、選出されたリーダーのみが実際の処理を行う。このコールバックにより、コンポーネントはリーダーとしての責務を開始できる。

**通知の送信タイミング**：LeaderElectionDriverがリーダーシップを取得し、DefaultLeaderElectionServiceが当該コンテンダーをリーダーとして選出した際に発行される。ZooKeeper、Kubernetesなどのバックエンドでリーダー選出が完了した後に通知される。

**通知の受信者**：LeaderContenderインターフェースを実装し、LeaderElectionServiceに登録されたコンポーネント。具体的には、DefaultDispatcherRunner、JobMasterServiceLeadershipRunner、ResourceManagerServiceImpl、WebMonitorEndpointなどが対象。

**通知内容の概要**：新しいリーダーセッションを一意に識別するUUID（leaderSessionID）が渡される。このセッションIDは、リーダーシップの有効性を検証するために使用される。

**期待されるアクション**：受信者は、リーダーとしての処理を開始し、必要に応じてLeaderElection.confirmLeadership()を呼び出してリーダー情報を永続化する。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し、HAメカニズム用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（専用のExecutorThreadで実行） |
| 優先度 | 高（リーダーシップ取得は重要イベント） |
| リトライ | なし |

### 送信先決定ロジック

LeaderElectionServiceに登録された特定のLeaderContenderに対して通知される。複数のコンテンダーが登録されている場合、各コンテンダーに個別に通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
void grantLeadership(UUID leaderSessionID);
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数: leaderSessionID - 新しいリーダーセッションの一意識別子（UUID）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| leaderSessionID | リーダーセッションの一意識別子 | LeaderElectionDriver | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部イベント | LeaderElectionDriver.onGrantLeadership | リーダー選出成功 | バックエンド（ZK/K8s等）でリーダー選出完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サービス停止中 | LeaderElectionServiceがrunning=falseの場合 |
| コンテンダー未登録 | LeaderContenderが登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リーダー選出バックエンド] --> B[LeaderElectionDriver.onGrantLeadership]
    B --> C[DefaultLeaderElectionService.onGrantLeadership]
    C --> D[UUID生成/取得]
    D --> E[leadershipOperationExecutor経由で非同期実行]
    E --> F[LeaderContender.grantLeadership呼び出し]
    F --> G[コンテンダーがリーダー処理開始]
    G --> H[confirmLeadership呼び出し]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ZooKeeper/Kubernetes等の外部ストレージを参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | confirmLeadership時にバックエンドストレージを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | コンテンダー内で例外発生 | handleErrorコールバックで通知 |
| 接続喪失 | HAバックエンドとの接続切断 | revokeLeadershipが呼び出される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- leaderSessionIDは外部に公開される可能性があるが、認証トークンではない
- リーダーシップの検証にはセッションIDの一致が必要

## 備考

- revokeLeadershipと対になるメソッド
- 同じセッションIDで複数回呼び出されることはない
- リーダーシップ取得後、confirmLeadership()を呼び出す必要がある場合が多い
- handleErrorメソッドでエラー通知を受け取る

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LeaderContender.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderContender.java` | インターフェース定義（27-51行目） |

**読解のコツ**: grantLeadership、revokeLeadership、handleErrorの3つのメソッドの関係を理解する。

#### Step 2: 通知発行元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DefaultLeaderElectionService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/DefaultLeaderElectionService.java` | onGrantLeadership処理、leadershipOperationExecutor |

#### Step 3: 利用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefaultDispatcherRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/runner/DefaultDispatcherRunner.java` | grantLeadership実装例 |
| 3-2 | JobMasterServiceLeadershipRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterServiceLeadershipRunner.java` | grantLeadership実装例 |
| 3-3 | ResourceManagerServiceImpl.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManagerServiceImpl.java` | grantLeadership実装例 |

### プログラム呼び出し階層図

```
LeaderElectionDriver（ZK/K8s等）
    │
    └─ DefaultLeaderElectionService.onGrantLeadership(UUID)
           │
           └─ leadershipOperationExecutor.execute(...)
                  │
                  └─ LeaderContender.grantLeadership(leaderSessionID)
                         │
                         ├─ DefaultDispatcherRunner
                         ├─ JobMasterServiceLeadershipRunner
                         ├─ ResourceManagerServiceImpl
                         └─ WebMonitorEndpoint
```

### データフロー図

```
[入力]                      [処理]                              [出力]

HAバックエンド ───▶ LeaderElectionDriver ───▶ DefaultLeaderElectionService
(ZooKeeper/K8s)                                     │
                                                    ▼
                                            leaderSessionID生成
                                                    │
                                                    ▼
                                             LeaderContender
                                          (リーダー処理開始)
                                                    │
                                                    ▼
                                           confirmLeadership()
                                          (リーダー情報永続化)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LeaderContender.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderContender.java` | インターフェース | リーダー選出参加者の契約定義 |
| DefaultLeaderElectionService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/DefaultLeaderElectionService.java` | ソース | リーダー選出サービスの実装 |
| LeaderElectionDriver.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderElectionDriver.java` | インターフェース | バックエンドドライバーの契約 |
| DefaultDispatcherRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/runner/DefaultDispatcherRunner.java` | ソース | 実装例：Dispatcher |
| JobMasterServiceLeadershipRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterServiceLeadershipRunner.java` | ソース | 実装例：JobMaster |
| ResourceManagerServiceImpl.java | `flink-runtime/src/main/java/org/apache/flink/runtime/resourcemanager/ResourceManagerServiceImpl.java` | ソース | 実装例：ResourceManager |
