# 通知設計書 9-revokeLeadership

## 概要

本ドキュメントは、Apache Flinkにおけるリーダー権限剥奪通知（revokeLeadership）の設計を記載する。リーダーシップが取り消された際にコールバックされる機能である。

### 本通知の処理概要

本通知は、Flinkの高可用性（HA）機構において、リーダー選出サービス（LeaderElectionService）がリーダーシップを剥奪する際にLeaderContenderインターフェースを実装するコンポーネントに対して発行するコールバックである。

**業務上の目的・背景**：分散システムにおける高可用性を維持するために、リーダーシップの動的な移譲が必要である。ネットワーク分断、HAバックエンドとの接続喪失、または他のノードへのリーダーシップ移譲時に、現在のリーダーはリーダーとしての処理を停止する必要がある。このコールバックにより、コンポーネントは適切にリーダー責務を終了できる。

**通知の送信タイミング**：LeaderElectionDriverがリーダーシップの喪失を検出した際に発行される。具体的には、HAバックエンド（ZooKeeper、Kubernetes等）との接続喪失、セッション切断、または明示的なリーダーシップ放棄時に通知される。

**通知の受信者**：LeaderContenderインターフェースを実装し、LeaderElectionServiceに登録されたコンポーネント。具体的には、DefaultDispatcherRunner、JobMasterServiceLeadershipRunner、ResourceManagerServiceImpl、WebMonitorEndpointなどが対象。

**通知内容の概要**：引数なしのコールバック。リーダーシップが剥奪されたという事実のみが通知される。

**期待されるアクション**：受信者は、リーダーとしての処理を停止し、必要なクリーンアップを実行する。新しいリーダー選出に参加する場合は、再度grantLeadershipを待つ。

## 通知種別

内部コールバック通知（プログラム内部でのメソッド呼び出し、HAメカニズム用）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（専用のExecutorThreadで実行） |
| 優先度 | 高（リーダーシップ喪失は重要イベント） |
| リトライ | なし |

### 送信先決定ロジック

以前にgrantLeadershipが呼び出されたLeaderContenderに対して通知される。

## 通知テンプレート

### メソッドシグネチャ

```java
void revokeLeadership();
```

### 本文テンプレート

```
（プログラム内部通知のため、テキストテンプレートは存在しない）
引数: なし
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 内部通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 引数なしのコールバック | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部イベント | LeaderElectionDriver接続喪失 | HAバックエンドとの接続切断 | ZK/K8sセッション切断等 |
| 内部イベント | LeaderElection.close() | 明示的なリーダーシップ放棄 | サービス停止時 |
| 内部イベント | 他ノードへのリーダーシップ移譲 | スプリットブレイン回復等 | 複数リーダー検出時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| grantLeadership未呼び出し | 以前にリーダーシップが付与されていない場合 |
| サービス停止済み | LeaderElectionServiceが既に停止している場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リーダーシップ喪失イベント] --> B[LeaderElectionDriver.onRevokeLeadership]
    B --> C[DefaultLeaderElectionService.onRevokeLeadership]
    C --> D[issuedLeaderSessionIDをnullに設定]
    D --> E[leadershipOperationExecutor経由で非同期実行]
    E --> F[LeaderContender.revokeLeadership呼び出し]
    F --> G[コンテンダーがリーダー処理停止]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 内部メモリ上の状態のみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | HAバックエンドのリーダー情報が自動的に更新される可能性 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Exception | コンテンダー内で例外発生 | handleErrorコールバックで通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部通知のため、外部からのアクセスはない
- リーダーシップ剥奪後は、リーダー権限を必要とする操作を行ってはならない

## 備考

- grantLeadershipと対になるメソッド
- 複数のコンテンダーにリーダーシップが付与された場合の回復にも使用される
- handleErrorメソッドでエラー通知を受け取る
- リーダーシップ喪失後、再度選出される可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LeaderContender.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderContender.java` | revokeLeadershipメソッド定義（37-42行目） |

**読解のコツ**: 「複数のコンテンダーにリーダーシップが付与された場合」のケースを理解する。

#### Step 2: 通知発行元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DefaultLeaderElectionService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/DefaultLeaderElectionService.java` | onRevokeLeadership処理 |
| 2-2 | LeaderElection.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderElection.java` | close()時の動作 |

#### Step 3: 利用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefaultDispatcherRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/runner/DefaultDispatcherRunner.java` | revokeLeadership実装例 |
| 3-2 | JobMasterServiceLeadershipRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterServiceLeadershipRunner.java` | revokeLeadership実装例 |

### プログラム呼び出し階層図

```
LeaderElectionDriver（ZK/K8s等）
    │
    └─ DefaultLeaderElectionService.onRevokeLeadership()
           │
           └─ leadershipOperationExecutor.execute(...)
                  │
                  └─ LeaderContender.revokeLeadership()
                         │
                         ├─ DefaultDispatcherRunner
                         ├─ JobMasterServiceLeadershipRunner
                         ├─ ResourceManagerServiceImpl
                         └─ WebMonitorEndpoint
```

### データフロー図

```
[入力]                      [処理]                              [出力]

HAバックエンド ───▶ LeaderElectionDriver ───▶ DefaultLeaderElectionService
(接続喪失/移譲)                                     │
                                                    ▼
                                           issuedLeaderSessionID = null
                                                    │
                                                    ▼
                                             LeaderContender
                                          (リーダー処理停止)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LeaderContender.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderContender.java` | インターフェース | リーダー選出参加者の契約定義 |
| DefaultLeaderElectionService.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/DefaultLeaderElectionService.java` | ソース | リーダー選出サービスの実装 |
| LeaderElection.java | `flink-runtime/src/main/java/org/apache/flink/runtime/leaderelection/LeaderElection.java` | インターフェース | リーダー選出の制御インターフェース |
| DefaultDispatcherRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/runner/DefaultDispatcherRunner.java` | ソース | 実装例：Dispatcher |
| JobMasterServiceLeadershipRunner.java | `flink-runtime/src/main/java/org/apache/flink/runtime/jobmaster/JobMasterServiceLeadershipRunner.java` | ソース | 実装例：JobMaster |
