---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-notifyHeartbeatTimeout

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `HeartbeatListener.java` 38-44行目（インターフェース定義）
- E-02: `DefaultHeartbeatMonitor.java` 155-160行目（run()メソッド実装）
- E-03: `DefaultHeartbeatMonitor.java` 119行目（状態遷移）
- E-04: `DefaultHeartbeatMonitor.java` 67-95行目（コンストラクタ）
- E-05: `DefaultHeartbeatMonitor.java` 141-144行目（reportHeartbeatメソッド）
- E-06: `通知一覧.csv` 11行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | notifyHeartbeatTimeoutはハートビートタイムアウト時に呼び出される | E-01, E-02 | ○ |
| C-02 | ResourceIDをパラメータとして受け取る | E-01 | ○ |
| C-03 | DefaultHeartbeatMonitorのrun()メソッドで通知が発行される | E-02 | ○ |
| C-04 | 状態がRUNNINGからTIMEOUTに遷移する | E-02, E-03 | ○ |
| C-05 | compareAndSetで状態遷移が行われる | E-03 | ○ |
| C-06 | heartbeatTimeoutIntervalMsでタイムアウト間隔が設定される | E-04 | ○ |
| C-07 | ハートビート受信時にタイマーがリセットされる | E-05 | ○ |
| C-08 | ScheduledExecutorを使用してタイマーを管理 | E-04 | ○ |
| C-09 | HeartbeatListenerインターフェースで定義されている | E-01 | ○ |
| C-10 | ResourceManager、JobMaster、TaskExecutorがリスナー実装 | E-06 | ○ |
| C-11 | 非同期で通知される（スケジューラスレッドから） | E-04 | ○ |
| C-12 | 通知は1回限り（リトライなし） | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] HeartbeatListener.javaの38-44行目で定義が確認できること
- [ ] DefaultHeartbeatMonitor.javaの155-160行目でタイムアウト処理が確認できること
- [ ] 状態遷移（RUNNING -> TIMEOUT）のロジックが正確であること
