---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-notifyTargetUnreachable

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全て根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `HeartbeatListener.java` 46-52行目（インターフェース定義）
- E-02: `DefaultHeartbeatMonitor.java` 113-129行目（reportHeartbeatRpcFailure実装）
- E-03: `DefaultHeartbeatMonitor.java` 119行目（状態遷移）
- E-04: `DefaultHeartbeatMonitor.java` 126行目（notifyTargetUnreachable呼び出し）
- E-05: `DefaultHeartbeatMonitor.java` 131-133行目（機能有効/無効判定）
- E-06: `DefaultHeartbeatMonitor.java` 136-138行目（reportHeartbeatRpcSuccess）
- E-07: `通知一覧.csv` 12行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | notifyTargetUnreachableはRPC連続失敗時に呼び出される | E-02, E-04 | ○ |
| C-02 | ResourceIDをパラメータとして受け取る | E-01 | ○ |
| C-03 | reportHeartbeatRpcFailure()で失敗検知される | E-02 | ○ |
| C-04 | 状態がRUNNINGからUNREACHABLEに遷移する | E-03 | ○ |
| C-05 | failedRpcRequestsUntilUnreachableで閾値設定 | E-02, E-05 | ○ |
| C-06 | 機能を無効化できる（-1設定） | E-05 | ○ |
| C-07 | RPC成功時に失敗カウンタがリセットされる | E-06 | ○ |
| C-08 | タイムアウトタイマーがキャンセルされる | E-02 | ○ |
| C-09 | HeartbeatListenerインターフェースで定義 | E-01 | ○ |
| C-10 | compareAndSetで状態遷移が行われる | E-03 | ○ |
| C-11 | タイムアウト通知と排他的 | E-02, E-03 | ○ |
| C-12 | 通知は1回限り | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] HeartbeatListener.javaの46-52行目で定義が確認できること
- [ ] DefaultHeartbeatMonitor.javaの113-129行目でRPC失敗検知処理が確認できること
- [ ] 状態遷移（RUNNING -> UNREACHABLE）のロジックが正確であること
- [ ] 閾値設定と無効化オプションの動作が正確であること
