---
generated_at: 2026-02-02 17:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-jobManagerLostLeadership

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/JobLeaderListener.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/DefaultJobLeaderService.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/TaskExecutor.java`
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リーダーアドレスが null/empty の場合に通知される | E-02 行 315-318 | ○ |
| C-02 | 通知パラメータに jobId, jobMasterId が含まれる | E-01 行 48-54 | ○ |
| C-03 | TaskExecutor の JobLeaderListenerImpl が受信者 | E-03 行 2547-2564 | ○ |
| C-04 | 非同期で runAsync 経由で処理される | E-03 行 2552 | ○ |
| C-05 | disconnectJobManagerConnection が呼び出される | E-03 行 2557 | ○ |
| C-06 | コールバックはロック外で実行される | E-02 行 334-336 | ○ |
| C-07 | closeRpcConnection で接続をクローズする | E-02 行 318, 357-364 | ○ |
| C-08 | currentJobMasterId が null にクリアされる | E-02 行 362 | ○ |
| C-09 | rpcConnection が null にクリアされる | E-02 行 361 | ○ |
| C-10 | Optional.ofNullable で通知対象を保存する | E-02 行 317 | ○ |
| C-11 | サービス停止中は処理しない | E-02 行 300-306 | ○ |
| C-12 | currentJobMasterId が null の場合は通知しない | E-02 行 317（Optional empty） | ○ |
| C-13 | JobLeaderListener インターフェースで定義される | E-01 行 33 | ○ |
| C-14 | jobManagerGainedLeadership と対になる | E-01（両メソッド定義） | ○ |
| C-15 | ログ出力が行われる | E-03 行 2549-2550 | ○ |
| C-16 | 接続切断時に例外メッセージを生成する | E-03 行 2559-2562 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知フローはソースコードから明確
- 0: 低リスク - ロック外でのコールバック実行パターンは明確

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultJobLeaderService.notifyLeaderAddress() でのリーダー喪失処理を確認
- [ ] TaskExecutor.JobLeaderListenerImpl.jobManagerLostLeadership() の実装確認
- [ ] closeRpcConnection() でのリソースクリーンアップ確認
- [ ] ロック外コールバック実行によるデッドロック回避を確認
