---
generated_at: 2026-02-02 17:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-jobManagerRejectedRegistration

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/JobLeaderListener.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/DefaultJobLeaderService.java`
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/TaskExecutor.java`
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 登録拒否時に onRegistrationRejection が呼び出される | E-02 行 432-450 | ○ |
| C-02 | 通知パラメータに jobId, targetAddress, rejection が含まれる | E-01 行 63-72 | ○ |
| C-03 | TaskExecutor の JobLeaderListenerImpl が受信者 | E-03 行 2571-2575 | ○ |
| C-04 | 非同期で runAsync 経由で処理される | E-03 行 2574 | ○ |
| C-05 | handleRejectedJobManagerConnection が呼び出される | E-03 行 2574 | ○ |
| C-06 | runIfValidRegistrationAttemptOrElse で有効性チェックされる | E-02 行 434, 470-477 | ○ |
| C-07 | 無効なセッションの場合はログ出力してスキップ | E-02 行 444-448 | ○ |
| C-08 | 有効な場合はログ出力後にコールバック実行 | E-02 行 435-442 | ○ |
| C-09 | JobLeaderListener インターフェースで定義される | E-01 行 33 | ○ |
| C-10 | JMTMRegistrationRejection に拒否理由が含まれる | E-01 行 71 | ○ |
| C-11 | 登録失敗（onRegistrationFailure）とは異なる処理 | E-02 行 452-468 との比較 | ○ |
| C-12 | リトライは行われない（明示的拒否のため） | E-02 設計上 | ○ |
| C-13 | getTargetAddress で対象アドレスを取得 | E-02 行 441 | ○ |
| C-14 | getTargetLeaderId でセッションIDを取得 | E-02 行 472 | ○ |
| C-15 | 拒否はタスクマネージャ接続に関するもの | E-04 備考欄 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知フローはソースコードから明確
- 0: 低リスク - 拒否処理の流れは明確

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultJobLeaderService.onRegistrationRejection() の実装確認
- [ ] TaskExecutor.handleRejectedJobManagerConnection() の実装確認
- [ ] JMTMRegistrationRejection の構造確認
- [ ] runIfValidRegistrationAttemptOrElse の有効性チェックロジック確認
