---
generated_at: 2026-02-02 17:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-onFatalError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-rpc/flink-rpc-core/src/main/java/org/apache/flink/runtime/rpc/FatalErrorHandler.java`
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/taskexecutor/TaskExecutor.java`
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 致命的エラー発生時に onFatalError が呼び出される | E-02 行 2453-2460 | ○ |
| C-02 | 通知パラメータに Throwable exception が含まれる | E-01 行 32 | ○ |
| C-03 | ブロッキング呼び出しは禁止されている | E-01 行 27-28 | ○ |
| C-04 | RpcEndpoint のメインスレッドから呼び出される可能性がある | E-01 行 28 | ○ |
| C-05 | FatalErrorHandler インターフェースで定義される | E-01 行 22 | ○ |
| C-06 | TaskExecutor で fatalErrorHandler.onFatalError が呼び出される | E-02 行 2460 | ○ |
| C-07 | 複数箇所から onFatalError が呼び出される | E-02 行 476, 1025, 1050 等 | ○ |
| C-08 | LeaderRetrievalListener エラーで呼び出される | E-02 行 2524-2526 | ○ |
| C-09 | JobLeaderListener エラーで呼び出される | E-02 行 2567-2568 | ○ |
| C-10 | 登録失敗時に呼び出される | E-02 行 2626 | ○ |
| C-11 | 登録拒否時に呼び出される | E-02 行 2632 | ○ |
| C-12 | TaskManagerActions.notifyFatalError から呼び出される | E-02 行 2658 | ○ |
| C-13 | 例外は Throwable 型で受け取る | E-01 行 32 | ○ |
| C-14 | 致命的エラーのハンドリングが目的 | E-01 行 21 | ○ |
| C-15 | Handler for fatal errors と Javadoc に記載 | E-01 行 21 | ○ |
| C-16 | ブロッキング呼び出し禁止と Javadoc に記載 | E-03 備考欄 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義は明確
- 0: 低リスク - ブロッキング禁止の制約は Javadoc に明記

## 6) レビュアーチェックリスト（最小）
- [ ] FatalErrorHandler インターフェースの Javadoc 確認
- [ ] TaskExecutor.onFatalError() の実装確認
- [ ] 各呼び出し箇所での使用パターン確認
- [ ] ブロッキング禁止制約の遵守確認
