---
generated_at: 2026-02-02 17:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-notifyApplicationStatusChange

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-runtime/src/main/java/org/apache/flink/runtime/application/ApplicationStatusListener.java` 行24-33
- E-02: `flink-runtime/src/main/java/org/apache/flink/runtime/application/AbstractApplication.java` 行68-74（statusListenersフィールドとJavadoc）
- E-03: `flink-runtime/src/main/java/org/apache/flink/runtime/application/AbstractApplication.java` 行148-150（registerStatusListener）
- E-04: `flink-runtime/src/main/java/org/apache/flink/runtime/application/AbstractApplication.java` 行156-176（ALLOWED_TRANSITIONS）
- E-05: `flink-runtime/src/main/java/org/apache/flink/runtime/application/AbstractApplication.java` 行179-206（状態遷移メソッド群）
- E-06: `flink-runtime/src/main/java/org/apache/flink/runtime/application/AbstractApplication.java` 行208-220（transitionState）
- E-07: `flink-core/src/main/java/org/apache/flink/api/common/ApplicationState.java` 行29-65（状態定義とisTerminalState）
- E-08: `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/Dispatcher.java` 行157-158（ApplicationStatusListener実装宣言）
- E-09: `flink-runtime/src/main/java/org/apache/flink/runtime/dispatcher/Dispatcher.java` 行680-749（notifyApplicationStatusChange実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | notifyApplicationStatusChangeはアプリケーションステータス変更時にリスナーに通知する | E-01, E-02 | ○ |
| C-02 | ApplicationStatusListenerインターフェースで定義されている | E-01 | ○ |
| C-03 | 通知にはApplicationIDとApplicationStateが含まれる | E-01 | ○ |
| C-04 | AbstractApplicationのstatusListenersリストで管理される | E-02 | ○ |
| C-05 | registerStatusListenerでリスナーを登録する | E-03 | ○ |
| C-06 | リスナー登録はスレッドセーフではない | E-03（Javadoc記載） | ○ |
| C-07 | ALLOWED_TRANSITIONSで許可される状態遷移が定義される | E-04 | ○ |
| C-08 | CREATED->RUNNING、RUNNING->FINISHED等の遷移が定義されている | E-04 | ○ |
| C-09 | transitionStateで状態遷移と通知が実行される | E-06 | ○ |
| C-10 | 状態遷移は検証後に実行される | E-06 行209 | ○ |
| C-11 | 通知はstatusListeners.forEachで全リスナーに送信される | E-06 行218-219 | ○ |
| C-12 | ApplicationStateには7つの状態がある | E-07 | ○ |
| C-13 | FAILED、CANCELED、FINISHEDは終端状態である | E-07 行41, 47, 53 | ○ |
| C-14 | DispatcherはApplicationStatusListenerを実装している | E-08 | ○ |
| C-15 | 終端状態への遷移時にアーカイブ処理が実行される | E-09 行682 | ○ |
| C-16 | アーカイブ処理は非同期で実行される | E-09 行713-747（thenAcceptAsync） | ○ |
| C-17 | History Serverへのアーカイブ失敗はログ出力のみで継続 | E-09 行736-743 | ○ |
| C-18 | 不正な状態遷移時はIllegalStateExceptionがスローされる | E-06 行222-228（validateTransition） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ApplicationStatusListenerインターフェースの定義が正確か確認
- [ ] ALLOWED_TRANSITIONSの状態遷移マップが最新か確認
- [ ] Dispatcherのアーカイブ処理ロジックが正確に記述されているか確認
