---
generated_at: 2026-02-02 10:55:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-onJobSubmitted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-core/src/main/java/org/apache/flink/core/execution/JobListener.java` 行 27-45
- E-02: `flink-runtime/src/main/java/org/apache/flink/streaming/api/environment/StreamExecutionEnvironment.java` 行 198
- E-03: `flink-clients/src/main/java/org/apache/flink/client/program/StreamContextEnvironment.java`
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行 7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobListenerインターフェースで定義 | E-01 | ○ |
| C-02 | execute()またはexecuteAsync()呼び出し時に通知 | E-01 (行37-38) | ○ |
| C-03 | ブロッキング操作は非推奨 | E-01 (行30-32) | ○ |
| C-04 | jobClientとthrowableは排他的 | E-01 (行40) | ○ |
| C-05 | @Nullableアノテーション付き | E-01 (行44-45) | ○ |
| C-06 | StreamExecutionEnvironmentにjobListenersフィールドあり | E-02 | ○ |
| C-07 | registerJobListener()で登録 | E-01 (行28) | ○ |
| C-08 | 送信成功時はJobClientが渡される | E-01 (行44) | ○ |
| C-09 | 送信失敗時はThrowableが渡される | E-01 (行45) | ○ |
| C-10 | onJobExecutedと対になる | E-01 (両メソッドの定義) | ○ |
| C-11 | 通知一覧CSVとの整合性 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書全体として信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] @Nullableの意味が正確に説明されているか
- [ ] ブロッキング操作が非推奨である理由が明確か
- [ ] onJobExecutedとの対応関係が明確か
