---
generated_at: 2026-02-02 17:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **対応ブラウザ一覧**：公式ドキュメントからの確認が必要
  2. **デフォルトポート番号8081**：設定ファイルからの確認が必要
  3. **権限制御の有無**：セキュリティ設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - Apache Flinkシステム概要
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移とURL構造
- E-03: `docs/code-to-docs/画面設計書/1-オーバービュー.md` - オーバービュー画面仕様
- E-04: `docs/code-to-docs/画面設計書/2-ジョブサブミット.md` - ジョブサブミット画面仕様
- E-05: `docs/code-to-docs/画面設計書/3-実行中ジョブ一覧.md` - 実行中ジョブ一覧画面仕様
- E-06: `docs/code-to-docs/画面設計書/5-ジョブ詳細.md` - ジョブ詳細画面仕様
- E-07: `docs/code-to-docs/画面設計書/10-チェックポイント.md` - チェックポイント画面仕様
- E-08: `docs/code-to-docs/画面設計書/22-JobManager.md` - JobManager画面仕様
- E-09: `docs/code-to-docs/画面設計書/31-TaskManager一覧.md` - TaskManager一覧画面仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要 - Apache Flink Web Dashboardはストリーム処理フレームワークの監視・管理UIである | E-01, E-03 | ○ |
| C-02 | オーバービュー画面がデフォルトランディングページである | E-02, E-03 | ○ |
| C-03 | URL `/overview` でオーバービュー画面にアクセス可能 | E-02, E-03 | ○ |
| C-04 | ルートパス（/）は/overviewにリダイレクトされる | E-03 | ○ |
| C-05 | オーバービュー画面でTaskManager数、スロット数、Flinkバージョンを表示 | E-03 | ○ |
| C-06 | オーバービュー画面でアプリケーション一覧（RUNNING/FINISHED/CANCELED/FAILED）を表示 | E-03 | ○ |
| C-07 | ジョブサブミット画面（/submit）でJARファイルのアップロードが可能 | E-04 | ○ |
| C-08 | JARアップロード時にプログレスバーで進捗表示 | E-04 | ○ |
| C-09 | ジョブ実行パラメータ（Entry Class, Parallelism等）の設定が可能 | E-04 | ○ |
| C-10 | 実行計画（Plan）のプレビュー表示が可能 | E-04 | ○ |
| C-11 | ジョブ実行後は自動的にジョブ詳細画面に遷移 | E-04 | ○ |
| C-12 | JAR削除時に確認ダイアログ「Are you sure delete this jar?」が表示 | E-04 | ○ |
| C-13 | Yarn環境ではJARアップロードが制限される | E-04 | ○ |
| C-14 | 実行中ジョブ一覧（/job/running）でジョブ名、状態、開始時刻、実行時間を表示 | E-05 | ○ |
| C-15 | INITIALIZING状態のジョブは詳細画面にアクセス不可 | E-05 | ○ |
| C-16 | ジョブ詳細画面でジョブステータスバーを表示 | E-06 | ○ |
| C-17 | ジョブ詳細画面にOverview/Exceptions/Data Skew/TimeLine/Checkpoints/Configurationのタブがある | E-06 | ○ |
| C-18 | OverviewタブでDAGグラフを表示 | E-02, E-06 | ○ |
| C-19 | DAGグラフ上のノードをクリックすると頂点詳細ドロワーが開く | E-02, E-06 | ○ |
| C-20 | 頂点詳細ドロワーにDetail/Subtasks/TaskManagers/Watermarks/Accumulators/Metrics/Backpressure/Flamegraphのタブがある | E-02 | ○ |
| C-21 | チェックポイント画面でTriggered/In Progress/Completed/Failed/Restoredのカウントを表示 | E-07 | ○ |
| C-22 | チェックポイント設定（Mode/Interval/Timeout等）を表示 | E-07 | ○ |
| C-23 | チェックポイント履歴を一覧表示 | E-07 | ○ |
| C-24 | JobManager画面にMetrics/Configuration/Logs/Stdout/Log List/Thread Dump/Profilerのタブがある | E-08 | ○ |
| C-25 | JobManager画面のデフォルトは/job-manager/metricsにリダイレクト | E-08 | ○ |
| C-26 | TaskManager一覧（/task-manager）でPath/ID/Data Port/Last Heartbeat/All Slots/Free Slots等を表示 | E-09 | ○ |
| C-27 | TaskManager一覧でソート機能が使用可能 | E-09 | ○ |
| C-28 | TaskManagerがブロック状態の場合バッジを表示 | E-09 | ○ |
| C-29 | StatusServiceのrefresh$により画面が自動リフレッシュされる | E-03, E-05, E-09 | ○ |
| C-30 | API通信エラー時はcatchErrorで処理 | E-03, E-05, E-09 | ○ |
| C-31 | ジョブ詳細取得エラー時は例外情報を取得して表示 | E-06 | ○ |
| C-32 | サイドナビゲーションからOverview/Submit New Job/Running Jobs/Completed Jobs/Job Manager/Task Managersにアクセス可能 | E-02, E-03 | ○ |
| C-33 | アプリケーション行クリックでアプリケーション詳細画面に遷移 | E-03 | ○ |
| C-34 | 実行中アプリケーションは/application/running/:idに遷移 | E-03 | ○ |
| C-35 | 完了済みアプリケーションは/application/completed/:idに遷移 | E-03 | ○ |
| C-36 | チェックポイント画面でcheckpointStatsとcheckpointConfigを並列取得 | E-07 | ○ |
| C-37 | チェックポイント画面に手動リフレッシュ機能がある | E-07 | ○ |
| C-38 | TaskManager詳細画面にMetrics/Log List/Thread Dump/Profiler/Logs/Stdoutのタブがある | E-02, E-09 | ○ |
| C-39 | ジョブ一覧でソート機能が使用可能（名前、開始時刻、実行時間、状態） | E-05 | ○ |
| C-40 | TaskBadgeComponentでタスク状態を視覚的に表示 | E-05 | ○ |
| C-41 | JobBadgeComponentでジョブ状態を色分け表示 | E-05 | ○ |
| C-42 | HumanizeBytesPipeでデータサイズをフォーマット表示 | E-07, E-09 | ○ |
| C-43 | 対応ブラウザはChrome/Edge/Safari/Firefox最新版 | **根拠なし** | △ |
| C-44 | デフォルトアクセスポートは8081 | **根拠なし** | △ |
| C-45 | 本システムは権限による機能制限がない | **根拠なし（推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- 対応ブラウザ一覧は公式ドキュメントまたはテスト設定からの確認が必要
  - 候補：package.json（browserlist） / CI設定 / 公式ドキュメント
- デフォルトポート番号8081はFlink設定ファイルからの確認が必要
  - 候補：flink-conf.yaml / FlinkConfiguration.java / ドキュメント
- 権限制御の有無については、認証・認可の設定ファイルの確認が必要
  - 候補：SecurityConfiguration / REST API設定 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、画面構成、基本操作手順（C-01〜C-42）
  - 根拠として画面設計書があり、信頼性が高い
- **1: 中リスク** - 対応ブラウザ、デフォルトポート（C-43, C-44）
  - 一般的な設定値だが、明示的な根拠がない
- **1: 中リスク** - 権限制御の記載（C-45）
  - 画面設計書に「権限制御なし」の記載があるが、セキュリティ設定で変更可能な可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] C-43: 対応ブラウザ一覧が実環境と一致するか確認
- [ ] C-44: デフォルトアクセスポートが実環境と一致するか確認
- [ ] C-45: 実環境での権限制御設定を確認し、必要に応じて記載を修正
- [ ] 業務フロー（STEP1〜5）が実際の運用フローと整合しているか確認
- [ ] トラブルシューティングの内容が実際の運用で有用か確認
- [ ] よくある質問の内容が実際のユーザーニーズを反映しているか確認
