# Apache Flink Web Dashboard 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（オーバービュー画面）](#3-トップページオーバービュー画面)

**【業務フローに沿った機能】**
4. [【STEP1】ジョブのサブミット（デプロイ）](#4-step1ジョブのサブミットデプロイ)
5. [【STEP2-3】ジョブの監視・確認](#5-step2-3ジョブの監視確認)
6. [【STEP3-4】クラスターリソースの管理](#6-step3-4クラスターリソースの管理)
7. [【STEP4-5】問題の診断・対処](#7-step4-5問題の診断対処)

**【サポート機能】**
8. [ログ・スレッドダンプ機能](#8-ログスレッドダンプ機能)
9. [メトリクス・プロファイラ機能](#9-メトリクスプロファイラ機能)
10. [チェックポイント管理](#10-チェックポイント管理)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Apache Flink Web Dashboardとは

Apache Flink Web Dashboardは、Apache Flinkクラスターの監視・管理のためのWebユーザーインターフェースです。オペレーターやデータエンジニアが、ストリーム処理ジョブの状態監視、リソース管理、問題診断を効率的に行うためのツールを提供します。

**主な特徴**:
- クラスター全体の状態をリアルタイムで可視化
- ジョブのデプロイ、監視、キャンセルをブラウザから操作可能
- JobManagerおよびTaskManagerの詳細監視機能
- チェックポイントの健全性監視
- ログ、メトリクス、プロファイリング情報へのアクセス

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ジョブ管理** | ジョブのサブミット（デプロイ）、実行状態の確認、ジョブのキャンセル |
| **クラスター監視** | TaskManager一覧の確認、リソース使用状況の監視、ハートビート確認 |
| **JobManager監視** | メトリクス確認、設定確認、ログ・標準出力の閲覧 |
| **問題診断** | 例外情報の確認、バックプレッシャー分析、データスキュー分析 |
| **パフォーマンス分析** | フレームグラフ、メトリクスチャート、タイムライン分析 |
| **チェックポイント管理** | チェックポイント履歴確認、設定確認、復元操作 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+--------------------------------------------------------------------+
|                        業務フロー                                   |
+--------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】JARファイルをアップロードし、ジョブをサブミット           |
|      |                                                             |
|  【STEP 2】実行中ジョブ一覧で稼働状況を確認                         |
|      |                                                             |
|  【STEP 3】ジョブ詳細画面でDAGグラフ、タスク状態を監視              |
|      |                                                             |
|  【STEP 4】異常検知時に例外情報、ログ、メトリクスで原因調査          |
|      |                                                             |
|  【STEP 5】問題解決後、必要に応じてジョブの再デプロイまたはキャンセル |
|                                                                    |
+--------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **クラスター管理者** | クラスター全体の健全性監視、TaskManager管理、リソース最適化 |
| **データエンジニア** | ジョブのデプロイ、実行状態監視、パフォーマンスチューニング |
| **運用オペレーター** | 日常監視、異常検知時の初期対応、ログ収集 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| オーバービュー | クラスター統計とアプリケーション一覧の表示 | 全STEP |
| ジョブサブミット | JARファイルのアップロードとジョブ実行 | STEP 1 |
| ジョブ一覧 | 実行中・完了済みジョブの一覧表示 | STEP 2 |
| ジョブ詳細 | DAGグラフ、タイムライン、例外情報等の表示 | STEP 3-4 |
| JobManager監視 | メトリクス、設定、ログの表示 | STEP 4-5 |
| TaskManager監視 | リソース状況、ログ、メトリクスの表示 | STEP 3-5 |
| チェックポイント | チェックポイント履歴と設定の表示 | STEP 3-5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 全ユーザー共通 | 本システムは権限による機能制限がなく、アクセス可能な全ユーザーが全機能を利用可能 |

> **注意**: Flink Web Dashboardへのアクセス制御は、ネットワークレベルまたはプロキシレベルで行う必要があります。

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 アクセス方法

Apache Flink Web Dashboardは、デフォルトでは認証機能を持たないため、ログイン操作は不要です。

1. ブラウザでFlink Web DashboardのURL（通常は `http://<JobManager-Host>:8081`）にアクセスします
2. 自動的にオーバービュー画面（`/overview`）が表示されます

**アクセスURL例：**
- スタンドアロンモード: `http://localhost:8081`
- YARNモード: `http://<ResourceManager>:8088` から Flink Application へのリンク
- Kubernetesモード: Ingressまたはポートフォワード経由でアクセス

### 2.2 セッション終了方法

1. ブラウザのタブまたはウィンドウを閉じます
2. 再度アクセスする場合は、URLを入力してアクセスします

### 2.3 Yarn環境でのアクセス

Yarn環境では、Application Masterプロキシを経由するため、一部機能に制限があります。

- **JARアップロード制限**: Yarnプロキシはファイルアップロードを許可しません
- **代替URL**: 画面に表示される代替URLを使用してください

> **メッセージ例**: "Yarn's AM proxy doesn't allow file uploads. You can visit here to access this functionality."

---

## 3. トップページ（オーバービュー画面）

### 3.1 画面概要

オーバービュー画面は、Flink Web Dashboardのデフォルトランディングページです。クラスターの健全性と稼働状況を一目で把握できます。

**URL**: `/overview`

### 3.2 表示内容

#### クラスター統計セクション

| 項目 | 説明 |
|------|------|
| TaskManager数 | 稼働中のTaskManagerの数 |
| ブロック中TaskManager数 | ブロック状態のTaskManager数（非ゼロ時のみ表示） |
| 総スロット数 | クラスター全体のスロット数 |
| 利用可能スロット数 | 現在利用可能なスロット数 |
| Flinkバージョン | 実行中のFlinkバージョン |

#### アプリケーション統計

| 項目 | 説明 |
|------|------|
| 実行中（RUNNING） | 現在実行中のアプリケーション数 |
| 完了（FINISHED） | 正常完了したアプリケーション数 |
| キャンセル（CANCELED） | キャンセルされたアプリケーション数 |
| 失敗（FAILED） | 失敗したアプリケーション数 |

### 3.3 基本操作

#### アプリケーション詳細への遷移

1. アプリケーション一覧から、確認したいアプリケーションの行をクリックします
2. アプリケーション詳細画面に遷移します

#### ナビゲーションメニューの使用

画面左側のサイドナビゲーションから各機能にアクセスできます：

- **Overview**: オーバービュー画面（現在の画面）
- **Submit New Job**: ジョブサブミット画面
- **Running Jobs**: 実行中ジョブ一覧
- **Completed Jobs**: 完了済みジョブ一覧
- **Job Manager**: JobManager監視画面
- **Task Managers**: TaskManager一覧画面

---

## 4. 【STEP1】ジョブのサブミット（デプロイ）

> **業務フローでの位置**: ジョブをFlinkクラスターにデプロイするための最初のステップです。

### 4.1 ジョブサブミット画面へのアクセス

1. ナビゲーションメニューから「Submit New Job」をクリックします
2. ジョブサブミット画面（`/submit`）が表示されます

### 4.2 JARファイルのアップロード

1. 「+ Add New」ボタンをクリックします
2. ファイル選択ダイアログが表示されるので、デプロイするJARファイルを選択します
3. アップロード進捗がプログレスバーで表示されます
4. アップロード完了後、JAR一覧に追加されます

**アップロード可能なファイル**:
- Flinkジョブを含むJARファイル

### 4.3 ジョブの実行

1. アップロードしたJARファイルの行をクリックして展開します
2. 以下のパラメータを設定します：

| 項目 | 説明 | 必須 |
|------|------|------|
| Entry Class | 実行するメインクラスの完全修飾名 | - |
| Parallelism | ジョブの並列度 | - |
| Program Arguments | プログラム引数 | - |
| Savepoint Path | セーブポイントからの復元時のパス | - |
| Allow Non Restored State | 復元されない状態を許可するか | - |

3. 「Show Plan」ボタンで実行計画をプレビューできます（任意）
4. 「Submit」ボタンをクリックしてジョブを実行します
5. 実行が成功すると、自動的にジョブ詳細画面に遷移します

### 4.4 JARファイルの削除

1. JAR一覧の右端にある削除リンク（xアイコン）をクリックします
2. 確認ダイアログが表示されます："Are you sure delete this jar?"
3. 「確認」をクリックして削除します

---

## 5. 【STEP2-3】ジョブの監視・確認

> **業務フローでの位置**: デプロイしたジョブの実行状態を監視し、正常に動作しているか確認するステップです。

### 5.1 実行中ジョブ一覧

#### アクセス方法

ナビゲーションメニューから「Running Jobs」をクリック、または `/job/running` にアクセスします。

#### 表示項目

| 項目 | 説明 |
|------|------|
| Job Name | ジョブの名前 |
| State | ジョブの状態（RUNNING等） |
| Start Time | ジョブの開始日時 |
| Duration | 実行時間 |
| Tasks | タスク状態別カウント（バッジ表示） |

#### 操作方法

- **ソート**: 列ヘッダーをクリックして並び替え
- **詳細表示**: ジョブ行をクリックしてジョブ詳細画面へ遷移

> **注意**: INITIALIZING状態のジョブは詳細画面にアクセスできません。

### 5.2 完了済みジョブ一覧

#### アクセス方法

ナビゲーションメニューから「Completed Jobs」をクリック、または `/job/completed` にアクセスします。

### 5.3 ジョブ詳細画面

#### アクセス方法

ジョブ一覧からジョブをクリック、または `/job/running/:jobId` にアクセスします。

#### ジョブステータスバー

画面上部に以下の情報が表示されます：
- ジョブ名
- 現在のジョブ状態
- 開始時刻 / 終了時刻
- 実行時間
- タスク統計

#### タブナビゲーション

| タブ | 説明 |
|------|------|
| Overview | DAGグラフ表示。ジョブの処理フローを視覚化 |
| Exceptions | 例外情報。エラー発生時の詳細 |
| Data Skew | データスキュー分析。データの偏りを確認 |
| TimeLine | タイムライン。実行時間の推移を表示 |
| Checkpoints | チェックポイント情報 |
| Configuration | ジョブ設定パラメータ |

### 5.4 DAGグラフ（ジョブ概要）の確認

1. ジョブ詳細画面の「Overview」タブを選択します
2. ジョブの処理フローがDAGグラフで表示されます
3. 各ノード（オペレーター）をクリックすると、頂点詳細ドロワーが開きます

#### 頂点詳細ドロワー

| タブ | 説明 |
|------|------|
| Detail | 頂点の基本情報 |
| Subtasks | サブタスク一覧 |
| TaskManagers | 実行TaskManager一覧 |
| Watermarks | ウォーターマーク情報 |
| Accumulators | アキュムレーター（集計値）情報 |
| Metrics | メトリクスチャート |
| Backpressure | バックプレッシャー状態 |
| Flamegraph | フレームグラフ（CPU使用率分析） |

---

## 6. 【STEP3-4】クラスターリソースの管理

> **業務フローでの位置**: クラスターのリソース状況を確認し、適切なリソース配分を行うステップです。

### 6.1 TaskManager一覧

#### アクセス方法

ナビゲーションメニューから「Task Managers」をクリック、または `/task-manager` にアクセスします。

#### 表示項目

| 項目 | 説明 |
|------|------|
| Path, ID | TaskManagerのIDとパス（ホスト名:ポート） |
| Data Port | データ通信用ポート番号 |
| Last Heartbeat | 最後のハートビート受信時刻 |
| All Slots | TaskManagerが持つ全スロット数 |
| Free Slots | 未使用のスロット数 |
| Assigned Tasks | 割り当てられたタスク数 |
| CPU Cores | CPUコア数 |
| Physical MEM | 物理メモリ容量 |
| JVM Heap Size | JVMヒープサイズ |
| Flink Managed MEM | Flink管理メモリ容量 |

#### 操作方法

- **詳細表示**: TaskManager行をクリックして詳細画面へ遷移

### 6.2 TaskManager詳細

#### アクセス方法

TaskManager一覧からTaskManagerをクリック、または `/task-manager/:id/metrics` にアクセスします。

#### タブナビゲーション

| タブ | 説明 |
|------|------|
| Metrics | JVMメモリ、CPU使用率などのメトリクス |
| Log List | ログファイルの一覧 |
| Thread Dump | JVMスレッドダンプ |
| Profiler | CPUプロファイリング |
| Logs | ログのリアルタイム表示 |
| Stdout | 標準出力の表示 |

### 6.3 JobManager監視

#### アクセス方法

ナビゲーションメニューから「Job Manager」をクリック、または `/job-manager` にアクセスします。

#### タブナビゲーション

| タブ | 説明 |
|------|------|
| Metrics | JVMメモリ、CPU使用率などのメトリクス |
| Configuration | JobManagerの設定パラメータ |
| Logs | ログのリアルタイム表示 |
| Stdout | 標準出力の表示 |
| Log List | ログファイルの一覧 |
| Thread Dump | JVMスレッドダンプ |
| Profiler | CPUプロファイリング |

---

## 7. 【STEP4-5】問題の診断・対処

> **業務フローでの位置**: 異常を検知した場合に、原因を特定し、対処するステップです。

### 7.1 例外情報の確認

#### アクセス方法

ジョブ詳細画面の「Exceptions」タブをクリックします。

#### 表示内容

- Root Exception: 根本原因となる例外
- 例外発生時刻
- スタックトレース

### 7.2 バックプレッシャー分析

#### アクセス方法

1. ジョブ詳細画面の「Overview」タブを選択
2. DAGグラフ上のオペレーターをクリック
3. 頂点詳細ドロワーの「Backpressure」タブを選択

#### 表示内容

| 状態 | 説明 |
|------|------|
| OK | バックプレッシャーなし |
| LOW | 低レベルのバックプレッシャー |
| HIGH | 高レベルのバックプレッシャー（対処が必要） |

### 7.3 データスキュー分析

#### アクセス方法

ジョブ詳細画面の「Data Skew」タブをクリックします。

#### 確認ポイント

- サブタスク間でのデータ量の偏り
- 処理時間の偏り

### 7.4 ジョブのキャンセル

1. ジョブ詳細画面のステータスバーで「Cancel」ボタンをクリックします
2. 確認ダイアログが表示されます
3. 「確認」をクリックしてジョブをキャンセルします

> **注意**: キャンセル後、ジョブは「CANCELED」状態になり、完了済みジョブ一覧に移動します。

---

## 8. ログ・スレッドダンプ機能

### 8.1 JobManagerログの確認

#### ログ一覧からの確認

1. JobManager画面の「Log List」タブをクリック
2. ログファイル一覧からファイルを選択
3. ログ詳細画面でログ内容を確認

#### リアルタイムログの確認

1. JobManager画面の「Logs」タブをクリック
2. 最新のログがリアルタイムで表示されます

### 8.2 TaskManagerログの確認

1. TaskManager詳細画面の「Log List」タブをクリック
2. ログファイル一覧からファイルを選択
3. ログ詳細画面でログ内容を確認

### 8.3 スレッドダンプの取得

#### JobManagerの場合

1. JobManager画面の「Thread Dump」タブをクリック
2. 現在のスレッド状態が表示されます

#### TaskManagerの場合

1. TaskManager詳細画面の「Thread Dump」タブをクリック
2. 現在のスレッド状態が表示されます

---

## 9. メトリクス・プロファイラ機能

### 9.1 メトリクスの確認

#### JobManagerメトリクス

1. JobManager画面の「Metrics」タブをクリック
2. 以下のメトリクスを確認できます：
   - JVMメモリ使用量（Heap/Non-Heap）
   - CPU使用率
   - GC統計

#### TaskManagerメトリクス

1. TaskManager詳細画面の「Metrics」タブをクリック
2. 同様のメトリクスを確認できます

### 9.2 フレームグラフの確認

#### アクセス方法

1. ジョブ詳細画面の「Overview」タブを選択
2. DAGグラフ上のオペレーターをクリック
3. 頂点詳細ドロワーの「Flamegraph」タブを選択

#### 分析ポイント

- CPU時間を多く消費している処理の特定
- ボトルネックの発見

### 9.3 プロファイラの使用

#### JobManagerプロファイラ

1. JobManager画面の「Profiler」タブをクリック
2. プロファイリングを開始・停止できます

#### TaskManagerプロファイラ

1. TaskManager詳細画面の「Profiler」タブをクリック
2. 同様にプロファイリングを実行できます

---

## 10. チェックポイント管理

### 10.1 チェックポイント画面へのアクセス

ジョブ詳細画面の「Checkpoints」タブをクリックします。

### 10.2 チェックポイントカウントの確認

| 項目 | 説明 |
|------|------|
| Triggered | トリガーされたチェックポイント総数 |
| In Progress | 進行中のチェックポイント数 |
| Completed | 完了したチェックポイント数 |
| Failed | 失敗したチェックポイント数 |
| Restored | 復元されたチェックポイント数 |

### 10.3 チェックポイント設定の確認

| 項目 | 説明 |
|------|------|
| Checkpointing Mode | チェックポイントモード（exactly_once等） |
| Interval | チェックポイント間隔 |
| Timeout | タイムアウト時間 |
| Minimum Pause | 最小休止時間 |
| Maximum Concurrent | 最大同時実行数 |
| State Backend | 状態バックエンド |
| Unaligned Checkpoints | 非整列チェックポイントの有効/無効 |

### 10.4 チェックポイント履歴の確認

1. 「History」セクションでチェックポイント履歴を確認
2. 各チェックポイントの詳細を展開して確認可能
   - 所要時間
   - データサイズ
   - 状態サイズ

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
================================================================
【STEP 1】JARファイルをアップロードし、ジョブをサブミット → 4章参照
    |
【STEP 2】実行中ジョブ一覧で稼働状況を確認 → 5章参照
    |
【STEP 3】ジョブ詳細画面でDAGグラフ、タスク状態を監視 → 5章参照
    |
【STEP 4】異常検知時に例外情報、ログ、メトリクスで原因調査 → 7章参照
    |
【STEP 5】問題解決後、必要に応じてジョブの再デプロイまたはキャンセル → 4章,7章参照
================================================================
```

### 11.1 【管理者】STEP1: ジョブのデプロイ

新しいジョブをデプロイする際の手順です。

1. 「Submit New Job」画面にアクセス
2. JARファイルをアップロード
3. 実行パラメータ（Entry Class、Parallelism等）を設定
4. 必要に応じて「Show Plan」で実行計画を確認
5. 「Submit」ボタンでジョブを実行

### 11.2 【オペレーター】STEP2: 稼働状況の確認

日常的な監視業務の手順です。

1. オーバービュー画面でクラスター統計を確認
   - TaskManager数が想定通りか
   - 利用可能スロット数に余裕があるか
2. 「Running Jobs」で実行中ジョブを確認
   - 全ジョブがRUNNING状態か
   - タスク状態に異常がないか

### 11.3 【オペレーター】STEP3: ジョブの詳細監視

特定のジョブを詳細に監視する手順です。

1. ジョブ詳細画面でDAGグラフを確認
2. 各オペレーターの処理状況を確認
3. チェックポイントが正常に完了しているか確認
4. バックプレッシャーが発生していないか確認

### 11.4 【管理者】STEP4-5: 問題対応

異常を検知した場合の対応手順です。

1. 「Exceptions」タブで例外情報を確認
2. ログを確認して詳細な原因を調査
3. 必要に応じてスレッドダンプを取得
4. 問題の原因を特定
5. ジョブをキャンセルし、修正後に再デプロイ

---

## 12. よくある質問と対処法

### 12.1 ジョブ関連のQ&A

**Q: ジョブがINITIALIZING状態のまま進まない**

A: 以下を確認してください：
- TaskManagerが十分な数起動しているか
- 利用可能スロット数がジョブの必要スロット数を満たしているか
- JobManagerのログで初期化エラーがないか確認

**Q: ジョブがFAILED状態になった**

A: 以下の手順で原因を調査してください：
1. ジョブ詳細画面の「Exceptions」タブで例外情報を確認
2. TaskManagerのログを確認
3. チェックポイントが失敗していないか確認

### 12.2 チェックポイント関連のQ&A

**Q: チェックポイントが頻繁に失敗する**

A: 以下を確認してください：
- チェックポイントのタイムアウト設定が適切か
- 状態バックエンドのストレージに十分な容量があるか
- ネットワーク遅延やディスクI/Oに問題がないか

### 12.3 リソース関連のQ&A

**Q: TaskManagerがブロック状態になっている**

A: 以下を確認してください：
- TaskManagerのJVMヒープメモリが不足していないか
- ガベージコレクションが頻発していないか
- ネットワーク接続に問題がないか

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "Job detail page is not available while it is in state INITIALIZING." | ジョブが初期化中 | 初期化完了を待つか、リソース不足を確認 |
| "Yarn's AM proxy doesn't allow file uploads." | Yarnプロキシの制限 | 代替URLを使用してアクセス |
| API通信エラー | JobManagerへの接続失敗 | JobManagerの稼働状況、ネットワークを確認 |

### 13.2 よくあるトラブルと解決方法

#### トラブル1: 画面が表示されない

**原因候補**:
- JobManagerが起動していない
- ネットワーク接続の問題
- ブラウザのキャッシュの問題

**解決方法**:
1. JobManagerプロセスの稼働を確認
2. ネットワーク接続を確認
3. ブラウザのキャッシュをクリアして再アクセス

#### トラブル2: ジョブが起動しない

**原因候補**:
- スロット不足
- JARファイルの問題
- Entry Classの指定誤り

**解決方法**:
1. 利用可能スロット数を確認
2. JARファイルを再アップロード
3. Entry Classの完全修飾名を確認

#### トラブル3: チェックポイントがタイムアウトする

**原因候補**:
- 状態サイズが大きすぎる
- バックエンドストレージの速度不足
- ネットワーク帯域の不足

**解決方法**:
1. チェックポイント間隔を調整
2. タイムアウト時間を延長
3. 状態バックエンドの設定を最適化

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を収集してサポートに連絡してください：

- 問題発生時刻
- エラーメッセージ（スクリーンショット）
- JobManagerログ
- TaskManagerログ
- ジョブの設定情報

**Apache Flinkコミュニティリソース**:
- 公式ドキュメント: https://flink.apache.org
- メーリングリスト: https://flink.apache.org/community.html#mailing-lists
- 課題追跡: https://issues.apache.org/jira/browse/FLINK

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-02 | 初版作成 |

---

*本マニュアルは、Apache Flink Web Dashboardのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
