---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに対して設定ファイルまたはソースコードの根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-core/src/main/java/org/apache/flink/configuration/RpcOptions.java`
- E-02: `flink-core/src/main/java/org/apache/flink/configuration/HighAvailabilityOptions.java`
- E-03: `flink-core/src/main/java/org/apache/flink/configuration/CheckpointingOptions.java`
- E-04: `flink-core/src/main/java/org/apache/flink/configuration/SecurityOptions.java`
- E-05: `flink-core/src/main/java/org/apache/flink/configuration/NettyShuffleEnvironmentOptions.java`
- E-06: `flink-dist/src/main/resources/config.yaml`
- E-07: `pom.xml`（プロジェクト設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: RPC呼び出しタイムアウト検証（pekko.ask.timeout=10秒） | E-01 | ○ |
| C-02 | NFT-002: TCP接続タイムアウト検証（pekko.tcp.timeout=20秒） | E-01 | ○ |
| C-03 | NFT-003: メッセージフレームサイズ制限検証（10MB） | E-01 | ○ |
| C-04 | NFT-004: ディスパッチャースループット検証（15メッセージ） | E-01 | ○ |
| C-05 | NFT-005: Fork-Joinエグゼキュータ並列度検証 | E-01 | ○ |
| C-06 | NFT-006: ZooKeeper HAモード有効化検証 | E-02 | ○ |
| C-07 | NFT-007: JobManager障害時フェイルオーバー検証 | E-02 | ○ |
| C-08 | NFT-008: ZooKeeperセッションタイムアウト検証（60秒） | E-02 | ○ |
| C-09 | NFT-009: ZooKeeper接続リトライ検証（3回、5秒間隔） | E-02 | ○ |
| C-10 | NFT-010: チェックポイント取得タイムアウト検証（10分） | E-03 | ○ |
| C-11 | NFT-011: 同時チェックポイント数制限検証（1） | E-03 | ○ |
| C-12 | NFT-012: Exactly-Onceモード検証 | E-03 | ○ |
| C-13 | NFT-013: 非整列チェックポイント検証 | E-03 | ○ |
| C-14 | NFT-014: インクリメンタルチェックポイント検証 | E-03 | ○ |
| C-15 | NFT-015: チェックポイント失敗許容数検証（3回） | E-03 | ○ |
| C-16 | NFT-016: Kerberos認証設定検証 | E-04 | ○ |
| C-17 | NFT-017: Kerberosチケットキャッシュ利用検証 | E-04 | ○ |
| C-18 | NFT-018: Kerberos再ログイン検証（1分間隔） | E-04 | ○ |
| C-19 | NFT-019: 内部SSL有効化検証 | E-04 | ○ |
| C-20 | NFT-020: REST API SSL有効化検証 | E-04 | ○ |
| C-21 | NFT-021: REST API相互認証検証 | E-04 | ○ |
| C-22 | NFT-022: SSLプロトコルバージョン検証（TLSv1.2） | E-04 | ○ |
| C-23 | NFT-023: SSL暗号スイート検証 | E-04 | ○ |
| C-24 | NFT-024: ZooKeeper SASL認証検証 | E-04 | ○ |
| C-25 | NFT-025: 委任トークン有効化検証 | E-04 | ○ |
| C-26 | NFT-026: TaskManagerスロット数検証 | E-06 | ○ |
| C-27 | NFT-027: JobManagerメモリサイズ検証（1600MB） | E-06 | ○ |
| C-28 | NFT-028: TaskManagerメモリサイズ検証（1728MB） | E-06 | ○ |
| C-29 | NFT-029: デフォルト並列度検証 | E-06 | ○ |
| C-30 | NFT-030: ネットワークバッファリクエストタイムアウト検証（30秒） | E-05 | ○ |
| C-31 | NFT-031: ソートシャッフル最小バッファ数検証（512） | E-05 | ○ |
| C-32 | NFT-032: シャッフル圧縮コーデック検証（LZ4） | E-05 | ○ |
| C-33 | NFT-033: Java 17互換性検証 | E-06 | ○ |
| C-34 | NFT-034: HashMapStateBackend互換性検証 | E-03 | ○ |
| C-35 | NFT-035: RocksDBStateBackend互換性検証 | E-03 | ○ |
| C-36 | NFT-036: ライフサイクルイベントログ検証 | E-01 | ○ |
| C-37 | NFT-037: 詳細ネットワークメトリクス検証 | E-05 | ○ |
| C-38 | NFT-038: 動的プロパティオーバーライド検証 | E-06, E-07 | ○ |
| C-39 | NFT-039: リージョンフェイルオーバー戦略検証 | E-06 | ○ |
| C-40 | NFT-040: データ転送SSL検証 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本レポートの全テストケースは、Apache Flink設定オプションのソースコードに基づいて作成されています
- 具体的なSLA目標値（例：レスポンス時間の具体的なms値）は、プロジェクト固有の要件定義書に記載がないため、設定オプションのデフォルト値を基準としています
  - 候補：プロジェクト固有のSLA定義書 / 運用要件定義書 / パフォーマンス要件仕様書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースはApache Flinkの公式設定オプションに基づいており、根拠が明確です
- 本テストケースはコード解析による自動生成であり、実際のテスト実行環境に応じた調整が必要な場合があります

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が実際のプロジェクト要件と合致しているか
- [ ] 合格基準の数値（タイムアウト値、リトライ回数等）が本番環境の要件と一致しているか
- [ ] セキュリティテストケース（SSL/TLS、Kerberos）が組織のセキュリティポリシーを満たしているか
- [ ] 高可用性テストケースのフェイルオーバーシナリオが実際のインフラ構成と整合しているか
- [ ] スケーラビリティテストのリソース設定値が本番環境の想定と一致しているか
- [ ] テスト環境（Java版本、OS、ネットワーク構成）の前提条件が明確か
