---
generated_at: 2026-02-02 16:15:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先的にレビューすべき項目はありません。

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-core/src/main/java/org/apache/flink/configuration/RpcOptions.java`
- E-02: `flink-core/src/main/java/org/apache/flink/configuration/RestOptions.java`
- E-03: `flink-core/src/main/java/org/apache/flink/configuration/CheckpointingOptions.java`
- E-04: `flink-core/src/main/java/org/apache/flink/configuration/HighAvailabilityOptions.java`
- E-05: `flink-core/src/main/java/org/apache/flink/configuration/HeartbeatManagerOptions.java`
- E-06: `flink-core/src/main/java/org/apache/flink/configuration/SecurityOptions.java`
- E-07: `flink-core/src/main/java/org/apache/flink/configuration/TaskManagerOptions.java`
- E-08: `flink-core/src/main/java/org/apache/flink/configuration/RestartStrategyOptions.java`
- E-09: `flink-core/src/main/java/org/apache/flink/configuration/MetricOptions.java`
- E-10: `flink-core/src/main/java/org/apache/flink/configuration/NettyShuffleEnvironmentOptions.java`
- E-11: `flink-core/src/main/java/org/apache/flink/api/common/io/ratelimiting/FlinkConnectorRateLimiter.java`
- E-12: `flink-core/src/main/java/org/apache/flink/api/connector/source/util/ratelimit/RateLimiter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### 性能要件 - レスポンスタイム
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RPC応答タイムアウト: 10秒 | E-01 (ASK_TIMEOUT_DURATION) | ○ |
| C-02 | TCP接続タイムアウト: 20秒 | E-01 (TCP_TIMEOUT) | ○ |
| C-03 | REST接続タイムアウト: 15秒 | E-02 (CONNECTION_TIMEOUT) | ○ |
| C-04 | Nettyクライアント接続タイムアウト: 120秒 | E-10 (CLIENT_CONNECT_TIMEOUT_SECONDS) | ○ |
| C-05 | チェックポイントタイムアウト: 10分 | E-03 (CHECKPOINTING_TIMEOUT) | ○ |
| C-06 | ZooKeeperセッションタイムアウト: 60秒 | E-04 (ZOOKEEPER_SESSION_TIMEOUT) | ○ |
| C-07 | ZooKeeper接続タイムアウト: 15秒 | E-04 (ZOOKEEPER_CONNECTION_TIMEOUT) | ○ |
| C-08 | TaskManager登録タイムアウト: 5分 | E-07 (REGISTRATION_TIMEOUT) | ○ |
| C-09 | スロットタイムアウト: 10秒 | E-07 (SLOT_TIMEOUT) | ○ |

### 性能要件 - スループット
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | Pekkoメッセージフレームサイズ: 10MB | E-01 (FRAMESIZE) | ○ |
| C-11 | RESTサーバー最大コンテンツ長: 100MB | E-02 (SERVER_MAX_CONTENT_LENGTH) | ○ |
| C-12 | RESTクライアント最大コンテンツ長: 100MB | E-02 (CLIENT_MAX_CONTENT_LENGTH) | ○ |
| C-13 | RESTサーバースレッド数: 4 | E-02 (SERVER_NUM_THREADS) | ○ |
| C-14 | 最大同時チェックポイント数: 1 | E-03 (MAX_CONCURRENT_CHECKPOINTS) | ○ |
| C-15 | TaskManagerタスクスロット数: 1 | E-07 (NUM_TASK_SLOTS) | ○ |
| C-16 | メモリセグメントサイズ: 32KB | E-07 (MEMORY_SEGMENT_SIZE) | ○ |
| C-17 | ネットワークバッファリクエストタイムアウト: 30秒 | E-10 (NETWORK_BUFFERS_REQUEST_TIMEOUT) | ○ |

### 可用性要件
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | ハートビート間隔: 10秒 | E-05 (HEARTBEAT_INTERVAL) | ○ |
| C-19 | ハートビートタイムアウト: 50秒 | E-05 (HEARTBEAT_TIMEOUT) | ○ |
| C-20 | ハートビートRPC失敗閾値: 2 | E-05 (HEARTBEAT_RPC_FAILURE_THRESHOLD) | ○ |
| C-21 | 高可用性モード: NONE | E-04 (HA_MODE) | ○ |
| C-22 | ZooKeeperリトライ待機時間: 5秒 | E-04 (ZOOKEEPER_RETRY_WAIT) | ○ |
| C-23 | ZooKeeper最大リトライ待機時間: 60秒 | E-04 (ZOOKEEPER_MAX_RETRY_WAIT) | ○ |
| C-24 | ZooKeeper最大リトライ回数: 3 | E-04 (ZOOKEEPER_MAX_RETRY_ATTEMPTS) | ○ |
| C-25 | チェックポイント保持数: 1 | E-03 (MAX_RETAINED_CHECKPOINTS) | ○ |
| C-26 | 許容チェックポイント失敗数: 0 | E-03 (TOLERABLE_FAILURE_NUMBER) | ○ |
| C-27 | チェックポイントモード: EXACTLY_ONCE | E-03 (CHECKPOINTING_CONSISTENCY_MODE) | ○ |

### セキュリティ要件 - SSL/TLS
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | 内部SSL有効化: false | E-06 (SSL_INTERNAL_ENABLED) | ○ |
| C-29 | REST SSL有効化: false | E-06 (SSL_REST_ENABLED) | ○ |
| C-30 | REST相互認証有効化: false | E-06 (SSL_REST_AUTHENTICATION_ENABLED) | ○ |
| C-31 | SSLプロトコル: TLSv1.2 | E-06 (SSL_PROTOCOL) | ○ |
| C-32 | SSLアルゴリズム: TLS_RSA_WITH_AES_128_CBC_SHA | E-06 (SSL_ALGORITHMS) | ○ |
| C-33 | ホスト名検証: false | E-06 (SSL_VERIFY_HOSTNAME) | ○ |
| C-34 | SSLプロバイダー: JDK | E-06 (SSL_PROVIDER) | ○ |
| C-35 | データ転送SSL有効化: true | E-10 (DATA_SSL_ENABLED) | ○ |
| C-36 | PekkoSSL有効化: true | E-01 (SSL_ENABLED) | ○ |

### セキュリティ要件 - Kerberos
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | チケットキャッシュ使用: true | E-06 (KERBEROS_LOGIN_USETICKETCACHE) | ○ |
| C-38 | Kerberos再ログイン間隔: 1分 | E-06 (KERBEROS_RELOGIN_PERIOD) | ○ |

### セキュリティ要件 - ZooKeeper
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | SASL無効化: false | E-06 (ZOOKEEPER_SASL_DISABLE) | ○ |
| C-40 | SASLサービス名: zookeeper | E-06 (ZOOKEEPER_SASL_SERVICE_NAME) | ○ |
| C-41 | SASLログインコンテキスト: Client | E-06 (ZOOKEEPER_SASL_LOGIN_CONTEXT_NAME) | ○ |
| C-42 | ZooKeeperACL: open | E-04 (ZOOKEEPER_CLIENT_ACL) | ○ |

### セキュリティ要件 - 委任トークン
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | 委任トークン有効化: true | E-06 (DELEGATION_TOKENS_ENABLED) | ○ |
| C-44 | トークン更新リトライバックオフ: 1時間 | E-06 (DELEGATION_TOKENS_RENEWAL_RETRY_BACKOFF) | ○ |
| C-45 | トークン更新時間比率: 0.75 | E-06 (DELEGATION_TOKENS_RENEWAL_TIME_RATIO) | ○ |

### 拡張性要件
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | マネージドメモリ割合: 0.4 | E-07 (MANAGED_MEMORY_FRACTION) | ○ |
| C-47 | ネットワークメモリ割合: 0.1 | E-07 (NETWORK_MEMORY_FRACTION) | ○ |
| C-48 | ネットワークメモリ最小: 64MB | E-07 (NETWORK_MEMORY_MIN) | ○ |
| C-49 | JVMメタスペース: 256MB | E-07 (JVM_METASPACE) | ○ |
| C-50 | JVMオーバーヘッド割合: 0.1 | E-07 (JVM_OVERHEAD_FRACTION) | ○ |
| C-51 | フレームワークヒープメモリ: 128MB | E-07 (FRAMEWORK_HEAP_MEMORY) | ○ |
| C-52 | フレームワークオフヒープメモリ: 128MB | E-07 (FRAMEWORK_OFF_HEAP_MEMORY) | ○ |

### レートリミット
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | FlinkConnectorRateLimiterインターフェース存在 | E-11 | ○ |
| C-54 | SourceRateLimiterインターフェース存在 | E-12 | ○ |

### 保守性要件 - リスタート戦略
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | fixed-delay試行回数: 1 | E-08 (RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS) | ○ |
| C-56 | fixed-delay遅延: 1秒 | E-08 (RESTART_STRATEGY_FIXED_DELAY_DELAY) | ○ |
| C-57 | failure-rate最大失敗数: 1 | E-08 (RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL) | ○ |
| C-58 | failure-rate間隔: 1分 | E-08 (RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL) | ○ |
| C-59 | failure-rate遅延: 1秒 | E-08 (RESTART_STRATEGY_FAILURE_RATE_DELAY) | ○ |
| C-60 | exponential-delay初期バックオフ: 1秒 | E-08 (RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF) | ○ |
| C-61 | exponential-delay最大バックオフ: 1分 | E-08 (RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF) | ○ |
| C-62 | exponential-delay乗数: 1.5 | E-08 (RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER) | ○ |
| C-63 | exponential-delayジッター: 0.1 | E-08 (RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR) | ○ |
| C-64 | exponential-delayリセット閾値: 1時間 | E-08 (RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD) | ○ |

### 保守性要件 - タスクキャンセレーション
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | キャンセル間隔: 30秒 | E-07 (TASK_CANCELLATION_INTERVAL) | ○ |
| C-66 | キャンセルタイムアウト: 180秒 | E-07 (TASK_CANCELLATION_TIMEOUT) | ○ |
| C-67 | タイマー終了タイムアウト: 7.5秒 | E-07 (TASK_CANCELLATION_TIMEOUT_TIMERS) | ○ |

### 運用・監視要件 - メトリクス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | メトリクスレポーター間隔: 10秒 | E-09 (REPORTER_INTERVAL) | ○ |
| C-69 | レイテンシトラッキング間隔: 0 | E-09 (LATENCY_INTERVAL) | ○ |
| C-70 | レイテンシ粒度: operator | E-09 (LATENCY_SOURCE_GRANULARITY) | ○ |
| C-71 | レイテンシ履歴サイズ: 128 | E-09 (LATENCY_HISTORY_SIZE) | ○ |
| C-72 | システムリソースメトリクス: false | E-09 (SYSTEM_RESOURCE_METRICS) | ○ |
| C-73 | システムリソースプローブ間隔: 5秒 | E-09 (SYSTEM_RESOURCE_METRICS_PROBING_INTERVAL) | ○ |
| C-74 | メトリクスフェッチャー更新間隔: 10秒 | E-09 (METRIC_FETCHER_UPDATE_INTERVAL) | ○ |
| C-75 | 詳細ネットワークメトリクス: false | E-10 (NETWORK_DETAILED_METRICS) | ○ |

### 運用・監視要件 - ログ・デバッグ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | メモリ使用ログ: false | E-07 (DEBUG_MEMORY_LOG) | ○ |
| C-77 | メモリ使用ログ間隔: 5秒 | E-07 (DEBUG_MEMORY_USAGE_LOG_INTERVAL_MS) | ○ |
| C-78 | System.outモード: DEFAULT | E-07 (TASK_MANAGER_SYSTEM_OUT_MODE) | ○ |
| C-79 | Pekkoライフサイクルログ: false | E-01 (LOG_LIFECYCLE_EVENTS) | ○ |
| C-80 | OOM時JVM終了: false | E-07 (KILL_ON_OUT_OF_MEMORY) | ○ |
| C-81 | 致命的Pekkoエラー時JVM終了: true | E-01 (JVM_EXIT_ON_FATAL_ERROR) | ○ |

### 運用・監視要件 - REST API
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | RESTポート: 8081 | E-02 (PORT) | ○ |
| C-83 | リーダー待機タイムアウト: 30秒 | E-02 (AWAIT_LEADER_TIMEOUT) | ○ |
| C-84 | リトライ最大回数: 20 | E-02 (RETRY_MAX_ATTEMPTS) | ○ |
| C-85 | リトライ遅延: 3秒 | E-02 (RETRY_DELAY) | ○ |

## 4) 不足情報（Unknown / Missing）

- 根拠なしの項目はありません。全ての主張はソースコード内の設定オプションクラスから直接抽出されています。

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての非機能要件はソースコード内のConfigOptionとして定義されており、デフォルト値と説明が明確に記載されています。
- 注意点：
  - 実運用環境での最適値は、ワークロードやインフラストラクチャによって異なるため、デフォルト値のまま使用せず、適切なチューニングが必要です。
  - 一部の設定（FlameGraph、Profiler、ファイルマージング等）は実験的機能としてマークされており、本番環境での使用には注意が必要です。

## 6) レビュアーチェックリスト（最小）

- [ ] 各タイムアウト値がプロジェクトの要件に適合しているか確認
- [ ] メモリ設定値がターゲット環境のリソースに適合しているか確認
- [ ] セキュリティ設定（SSL/TLS、Kerberos）が組織のセキュリティポリシーに準拠しているか確認
- [ ] 高可用性設定がSLAの要件を満たしているか確認
- [ ] リスタート戦略がアプリケーションの特性に適合しているか確認
- [ ] メトリクス設定が監視要件を満たしているか確認
