# 非機能要件定義書

## 概要

本ドキュメントは、Apache Flinkプロジェクトのソースコードから抽出した非機能要件を定義するものです。Apache Flinkは分散ストリーム/バッチ処理フレームワークであり、高いスループット、低レイテンシ、高可用性を実現するための様々な設定オプションを提供しています。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| RPC応答タイムアウト | 10秒（デフォルト） | `pekko.ask.timeout`で設定。全ての非同期RPC呼び出しに適用 |
| TCP接続タイムアウト | 20秒（デフォルト） | `pekko.tcp.timeout`で設定。ネットワークが遅い場合は増加を推奨 |
| REST接続タイムアウト | 15秒（デフォルト） | `rest.connection-timeout`で設定 |
| Nettyクライアント接続タイムアウト | 120秒（デフォルト） | `taskmanager.network.netty.client.connectTimeoutSec`で設定 |
| チェックポイントタイムアウト | 10分（デフォルト） | `execution.checkpointing.timeout`で設定 |
| ZooKeeperセッションタイムアウト | 60秒（デフォルト） | `high-availability.zookeeper.client.session-timeout`で設定 |
| ZooKeeper接続タイムアウト | 15秒（デフォルト） | `high-availability.zookeeper.client.connection-timeout`で設定 |
| TaskManager登録タイムアウト | 5分（デフォルト） | `taskmanager.registration.timeout`で設定 |
| スロットタイムアウト | 10秒（デフォルト） | `taskmanager.slot.timeout`で設定 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| Pekkoメッセージフレームサイズ | 10MB（デフォルト） | `pekko.framesize`で設定。大きなメッセージを扱う場合は増加 |
| RESTサーバー最大コンテンツ長 | 100MB（デフォルト） | `rest.server.max-content-length`で設定 |
| RESTクライアント最大コンテンツ長 | 100MB（デフォルト） | `rest.client.max-content-length`で設定 |
| RESTサーバースレッド数 | 4（デフォルト） | `rest.server.numThreads`で設定 |
| 最大同時チェックポイント数 | 1（デフォルト） | `execution.checkpointing.max-concurrent-checkpoints`で設定 |
| TaskManagerタスクスロット数 | 1（デフォルト） | `taskmanager.numberOfTaskSlots`で設定。CPUコア数に比例して設定を推奨 |
| メモリセグメントサイズ | 32KB（デフォルト） | `taskmanager.memory.segment-size`で設定 |
| ネットワークバッファリクエストタイムアウト | 30秒（デフォルト） | `taskmanager.network.memory.buffers-request-timeout`で設定 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| ハートビート間隔 | 10秒（デフォルト） | `heartbeat.interval`で設定。送信側から受信側へのハートビートRPCリクエスト間隔 |
| ハートビートタイムアウト | 50秒（デフォルト） | `heartbeat.timeout`で設定。タイムアウト後にコンポーネントは到達不能と判断 |
| ハートビートRPC失敗閾値 | 2（デフォルト） | `heartbeat.rpc-failure-threshold`で設定。連続失敗回数がこの値を超えると到達不能と判断 |
| 高可用性モード | NONE（デフォルト） | `high-availability.type`で設定。ZOOKEEPER、KUBERNETESをサポート |
| ZooKeeperリトライ待機時間 | 5秒（デフォルト） | `high-availability.zookeeper.client.retry-wait`で設定 |
| ZooKeeper最大リトライ待機時間 | 60秒（デフォルト） | `high-availability.zookeeper.client.max-retry-wait`で設定 |
| ZooKeeper最大リトライ回数 | 3（デフォルト） | `high-availability.zookeeper.client.max-retry-attempts`で設定 |
| チェックポイント保持数 | 1（デフォルト） | `execution.checkpointing.num-retained`で設定。障害復旧時に利用可能なチェックポイント数 |
| 許容チェックポイント失敗数 | 0（デフォルト） | `execution.checkpointing.tolerable-failed-checkpoints`で設定 |
| チェックポイントモード | EXACTLY_ONCE（デフォルト） | `execution.checkpointing.mode`で設定。AT_LEAST_ONCEも選択可能 |

## セキュリティ要件

### SSL/TLS設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| 内部SSL有効化 | false | `security.ssl.internal.enabled`で設定。RPC、データ転送、BLOBサーバーに適用 |
| REST SSL有効化 | false | `security.ssl.rest.enabled`で設定。外部REST通信に適用 |
| REST相互認証有効化 | false | `security.ssl.rest.authentication-enabled`で設定 |
| SSLプロトコル | TLSv1.2 | `security.ssl.protocol`で設定 |
| SSLアルゴリズム | TLS_RSA_WITH_AES_128_CBC_SHA | `security.ssl.algorithms`で設定 |
| ホスト名検証 | false | `security.ssl.verify-hostname`で設定 |
| SSLプロバイダー | JDK | `security.ssl.provider`で設定。OPENSSLも選択可能 |
| データ転送SSL有効化 | true | `taskmanager.data.ssl.enabled`で設定（内部SSL有効時に適用） |
| PekkoSSL有効化 | true | `pekko.ssl.enabled`で設定（グローバルSSL有効時に適用） |

### Kerberos認証

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| チケットキャッシュ使用 | true | `security.kerberos.login.use-ticket-cache`で設定 |
| Kerberos再ログイン間隔 | 1分 | `security.kerberos.relogin.period`で設定 |

### ZooKeeperセキュリティ

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| SASL無効化 | false | `zookeeper.sasl.disable`で設定 |
| SASLサービス名 | zookeeper | `zookeeper.sasl.service-name`で設定 |
| SASLログインコンテキスト | Client | `zookeeper.sasl.login-context-name`で設定 |
| ZooKeeperACL | open | `high-availability.zookeeper.client.acl`で設定。creatorも選択可能 |

### 委任トークン

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| 委任トークン有効化 | true | `security.delegation.tokens.enabled`で設定 |
| トークン更新リトライバックオフ | 1時間 | `security.delegation.tokens.renewal.retry.backoff`で設定 |
| トークン更新時間比率 | 0.75 | `security.delegation.tokens.renewal.time-ratio`で設定 |

## 拡張性要件

### スケーリング設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| TaskManagerメモリ（総プロセス） | 未設定 | `taskmanager.memory.process.size`で設定。コンテナ環境ではコンテナメモリと一致させる |
| TaskManagerメモリ（Flink用） | 未設定 | `taskmanager.memory.flink.size`で設定 |
| マネージドメモリ割合 | 0.4（40%） | `taskmanager.memory.managed.fraction`で設定 |
| ネットワークメモリ割合 | 0.1（10%） | `taskmanager.memory.network.fraction`で設定 |
| ネットワークメモリ最小 | 64MB | `taskmanager.memory.network.min`で設定 |
| JVMメタスペース | 256MB | `taskmanager.memory.jvm-metaspace.size`で設定 |
| JVMオーバーヘッド割合 | 0.1（10%） | `taskmanager.memory.jvm-overhead.fraction`で設定 |
| フレームワークヒープメモリ | 128MB | `taskmanager.memory.framework.heap.size`で設定 |
| フレームワークオフヒープメモリ | 128MB | `taskmanager.memory.framework.off-heap.size`で設定 |

### レートリミット

| 項目 | 説明 |
| --- | --- |
| FlinkConnectorRateLimiter | コネクタ用レートリミッターインターフェース。Guava実装（GuavaFlinkConnectorRateLimiter）を提供 |
| SourceRateLimiter | ソース読み取り用レートリミッター。秒間レコード数の制御が可能 |
| RateLimiterStrategy | レートリミット戦略を定義するインターフェース |

## 保守性要件

### リスタート戦略

| 戦略 | デフォルト設定 | 説明 |
| --- | --- | --- |
| disable | - | リスタートなし |
| fixed-delay | 試行回数: 1回、遅延: 1秒 | 固定遅延でのリスタート |
| failure-rate | 最大失敗数: 1、間隔: 1分、遅延: 1秒 | 失敗率に基づくリスタート |
| exponential-delay（デフォルト） | 初期バックオフ: 1秒、最大バックオフ: 1分、乗数: 1.5、ジッター: 0.1、リセット閾値: 1時間 | 指数バックオフでのリスタート。チェックポイント有効時のデフォルト |

### タスクキャンセレーション

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| キャンセル間隔 | 30秒 | `task.cancellation.interval`で設定 |
| キャンセルタイムアウト | 180秒 | `task.cancellation.timeout`で設定。0で無効化 |
| タイマー終了タイムアウト | 7.5秒 | `task.cancellation.timers.timeout`で設定 |

### クリーンアップ設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| チェックポイント並列クリーンアップ | true | `execution.checkpointing.cleaner.parallel-mode`で設定 |

## 運用・監視要件

### メトリクス設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| メトリクスレポーター間隔 | 10秒 | `metrics.reporter.<name>.interval`で設定 |
| レイテンシトラッキング間隔 | 0（無効） | `metrics.latency.interval`で設定。有効化すると性能に影響 |
| レイテンシ粒度 | operator | `metrics.latency.granularity`で設定。single/operator/subtask |
| レイテンシ履歴サイズ | 128 | `metrics.latency.history-size`で設定 |
| システムリソースメトリクス | false | `metrics.system-resource`で設定 |
| システムリソースプローブ間隔 | 5秒 | `metrics.system-resource-probing-interval`で設定 |
| メトリクスフェッチャー更新間隔 | 10秒 | `metrics.fetcher.update-interval`で設定 |
| 詳細ネットワークメトリクス | false | `taskmanager.network.detailed-metrics`で設定 |

### ログ・デバッグ設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| メモリ使用ログ | false | `taskmanager.debug.memory.log`で設定 |
| メモリ使用ログ間隔 | 5秒 | `taskmanager.debug.memory.log-interval`で設定 |
| System.outモード | DEFAULT | `taskmanager.system-out.mode`で設定。DEFAULT/LOG/IGNORE |
| Pekkoライフサイクルログ | false | `pekko.log.lifecycle.events`で設定 |
| OOM時JVM終了 | false | `taskmanager.jvm-exit-on-oom`で設定 |
| 致命的Pekkoエラー時JVM終了 | true | `pekko.jvm-exit-on-fatal-error`で設定 |

### REST API設定

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| RESTポート | 8081 | `rest.port`で設定 |
| リーダー待機タイムアウト | 30秒 | `rest.await-leader-timeout`で設定 |
| リトライ最大回数 | 20 | `rest.retry.max-attempts`で設定 |
| リトライ遅延 | 3秒 | `rest.retry.delay`で設定 |
| アイドルタイムアウト | 5分 | `rest.idleness-timeout`で設定 |
| 非同期操作結果保存期間 | 5分 | `rest.async.store-duration`で設定 |
| チェックポイント統計キャッシュサイズ | 1000 | `rest.cache.checkpoint-statistics.size`で設定 |

### FlameGraph/Profiler（実験的機能）

| 項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| FlameGraph有効化 | false | `rest.flamegraph.enabled`で設定 |
| FlameGraphサンプル数 | 100 | `rest.flamegraph.num-samples`で設定 |
| FlameGraphサンプル間隔 | 50ms | `rest.flamegraph.delay-between-samples`で設定 |
| FlameGraphスタック深度 | 100 | `rest.flamegraph.stack-depth`で設定 |
| Profiler有効化 | false | `rest.profiling.enabled`で設定 |
| Profiler最大期間 | 300秒 | `rest.profiling.duration-max`で設定 |
| Profiler履歴サイズ | 10 | `rest.profiling.history-size`で設定 |

## 備考

### ネットワーク設定

- **バックオフ設定**: パーティションリクエストの初期バックオフは100ms、最大バックオフは10000ms（`taskmanager.network.request-backoff.initial/max`）
- **ネットワークリトライ**: デフォルトは0回（`taskmanager.network.retries`）
- **TCP接続再利用**: ジョブ間でのTCP接続再利用はデフォルトで有効（`taskmanager.network.tcp-connection.enable-reuse-across-jobs`）
- **シャッフル圧縮**: デフォルトコーデックはLZ4（`taskmanager.network.compression.codec`）。NONE/LZO/ZSTDも選択可能

### スレッドプール設定

- **Pekko Fork-Joinエグゼキューター**: 並列度係数2.0、最小8スレッド、最大64スレッド
- **リモートFork-Joinエグゼキューター**: 並列度係数2.0、最小8スレッド、最大16スレッド
- **クライアントソケットワーカープール**: 最小1、最大2スレッド
- **サーバーソケットワーカープール**: 最小1、最大2スレッド

### チェックポイント詳細設定

- **増分チェックポイント**: デフォルトは無効（`execution.checkpointing.incremental`）
- **アンアラインドチェックポイント**: デフォルトは無効（`execution.checkpointing.unaligned.enabled`）。EXACTLY_ONCEモードでのみ使用可能
- **ファイルマージング**: デフォルトは無効（`execution.checkpointing.file-merging.enabled`）。実験的機能
- **小ファイル閾値**: 20KB（`execution.checkpointing.data-inline-threshold`）。これ以下の状態データはメタデータファイルにインライン保存
- **書き込みバッファサイズ**: 4KB（`execution.checkpointing.write-buffer-size`）
