---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **virtual_oss の HTTP オプション (-H/-P)**: man ページに記載が見当たらず、ソースコードのみから推測
  2. **ctlstat Prometheus モードのレスポンスボディ形式**: 出力内容の詳細はソースコード解析が必要
  3. **prometheus_sysctl_exporter の TCP ポート 9124**: man ページに記載はあるがIANA登録の確認は未実施
  4. **libfetch の fetchReqHTTP 関数のパラメータ意味**: ヘッダーファイルのみからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/virtual_oss/virtual_oss/httpd.c` -- virtual_oss HTTP サーバー実装
- E-02: `usr.sbin/virtual_oss/virtual_oss/virtual_oss.8` -- virtual_oss man ページ
- E-03: `usr.sbin/prometheus_sysctl_exporter/prometheus_sysctl_exporter.c` -- Prometheus sysctl エクスポーター実装
- E-04: `usr.sbin/prometheus_sysctl_exporter/prometheus_sysctl_exporter.8` -- Prometheus sysctl エクスポーター man ページ
- E-05: `usr.bin/ctlstat/ctlstat.c` -- ctlstat 実装 (Prometheus モード)
- E-06: `lib/libfetch/fetch.h` -- libfetch ヘッダーファイル (API 定義)
- E-07: `sys/netinet/accf_http.c` -- HTTP accept filter カーネルモジュール
- E-08: `tools/tools/netrate/httpd/httpd.c` -- ベンチマーク用簡易 HTTP サーバー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | virtual_oss は HTTP ストリーミングサーバーを内蔵する | E-01 | ○ |
| C-02 | エンドポイント GET / が HTML インデックスページを返す | E-01 (480-534行) | ○ |
| C-03 | エンドポイント GET /stream.wav が WAV オーディオストリームを返す | E-01 (483行, 536-568行) | ○ |
| C-04 | エンドポイント GET /stream.m3u が M3U プレイリストを返す | E-01 (485行, 570-583行) | ○ |
| C-05 | HTTP Range リクエストに対応し 206 Partial Content を返す | E-01 (419-428行) | ○ |
| C-06 | 不正な Range で 416 Range Not Satisfiable を返す | E-01 (558-561行) | ○ |
| C-07 | 接続スロット満杯時に 503 Out of Resources を返す | E-01 (566-568行) | ○ |
| C-08 | 不正なパスで 404 Not Found を返す | E-01 (585-595行) | ○ |
| C-09 | WAV ヘッダーは PCM フォーマット (audioformat=0x01) | E-01 (364-365行) | ○ |
| C-10 | 最大ストリーミング時間は 3 時間 (10,800 秒) | E-01 (61行 VOSS_HTTPD_MAX_STREAM_TIME) | ○ |
| C-11 | Server ヘッダーは virtual_oss/1.0 | E-01 (499行, 421行) | ○ |
| C-12 | Cache-Control: no-cache, no-store が設定される | E-01 (500行, 422行) | ○ |
| C-13 | M3U で RTP 設定時は rtp://239.255.0.1:{port} を返す | E-01 (578行) | ○ |
| C-14 | M3U で HTTP 時は http://{host}:{port}/stream.wav を返す | E-01 (580-581行) | ○ |
| C-15 | virtual_oss の HTTP は -H host -P port オプションで有効化 | E-01 (784行 条件チェック) | △ |
| C-16 | 同時接続数は起動時オプションで設定される | E-01 (784行 nstate 参照) | △ |
| C-17 | prometheus_sysctl_exporter は sysctl メトリクスを Prometheus 形式で出力 | E-03, E-04 | ○ |
| C-18 | prometheus_sysctl_exporter は -h オプションで HTTP モード有効化 | E-03 (599-601行), E-04 | ○ |
| C-19 | HTTP レスポンスに Content-Encoding: gzip が含まれる (-g 時) | E-03 (676行) | ○ |
| C-20 | Content-Type は text/plain; version=0.0.4 | E-03 (691行), E-05 (982行) | ○ |
| C-21 | TCP ポート 9124 が割り当てられている | E-04 (71行) | ○ |
| C-22 | メトリクス名は sysctl_ プレフィックス付き | E-04 (52-53行) | ○ |
| C-23 | ctlstat は -P オプションで Prometheus モード | E-05 (974行) | ○ |
| C-24 | ctlstat の HTTP レスポンスに Content-Length は含まれない | E-05 (977-978行 コメント参照) | ○ |
| C-25 | 認証機構は実装されていない | E-01, E-03, E-05 (全体) | ○ |
| C-26 | libfetch の HTTP 関連関数一覧 (fetchGetHTTP 等) | E-06 (100-107行) | ○ |
| C-27 | ctlstat Prometheus モードの出力内容 (LUN/ポート統計) | E-05 (989-991行) | △ |
| C-28 | libfetch の fetchReqHTTP は任意の HTTP メソッドを送信可能 | E-06 (106-107行) | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: virtual_oss の HTTP 有効化オプションの正確な名称と使用方法。man ページ (E-02) にはHTTP関連オプションの詳細記載が見当たらなかった。ソースコード内の条件チェック (`pvp->http.host`, `pvp->http.port`) から推測している。
  - 候補：virtual_oss(8) の最新 man ページ / virtual_oss のコマンドラインパーサー (main.c) / CHANGES ファイル
- C-16: 同時接続数の設定オプション名。`nstate` 変数がコマンドラインから設定されることはソースから読み取れるが、オプション名は未確認。
  - 候補：main.c のオプションパーサー / -n オプションの確認
- C-27: ctlstat Prometheus モードが出力する具体的なメトリクス名とラベル構造。`get_and_print_stats` 関数の詳細解析が必要。
  - 候補：ctlstat.c の get_and_print_stats 関数 / ctlstat(8) man ページ
- C-28: fetchReqHTTP の第2-5引数の正確な意味。ヘッダーファイルのプロトタイプ宣言のみで引数名が不明。
  - 候補：fetch(3) man ページ / http.c の実装

## 5) リスクフラグ（レビュー観点）
- リスク 1（中リスク）：virtual_oss の HTTP オプション記載が man ページと一致しない可能性がある。main.c のコマンドラインパーサーとの照合を推奨。
- リスク 0（低リスク）：prometheus_sysctl_exporter の記載はソースコードと man ページの両方で裏付けられている。
- リスク 0（低リスク）：libfetch の API 定義はヘッダーファイルから直接取得しており、信頼性は高い。
- リスク 1（中リスク）：FreeBSD はオペレーティングシステムであるため、本ドキュメントが対象とする「HTTP API」の範囲が適切かどうかは、プロジェクトの文脈に依存する。

## 6) レビュアーチェックリスト（最小）
- [ ] virtual_oss の main.c を確認し、HTTP 有効化オプション (-H/-P) の正確な記述を検証する
- [ ] virtual_oss の同時接続数設定オプション名を main.c から確認する
- [ ] ctlstat の Prometheus 出力形式の詳細を get_and_print_stats 関数から確認する
- [ ] fetchReqHTTP の引数の意味を fetch(3) man ページまたは http.c 実装から確認する
- [ ] 本ドキュメントの対象範囲 (HTTP API のみ) がプロジェクトの要件に合致するか確認する
- [ ] contrib/ ディレクトリ配下のサードパーティ HTTP コンポーネントを対象外としたことの妥当性を確認する
