# FreeBSD Source Tree (freebsd-src)

## 概要

FreeBSD は、モダンなサーバー、デスクトップ、組み込みプラットフォームを動かすために使用されるオープンソースのオペレーティングシステムである。30年以上にわたり大規模なコミュニティによって継続的に開発されており、高度なネットワーキング、セキュリティ、ストレージ機能を備えている。本リポジトリは FreeBSD OS のカーネルおよびユーザーランドのソースコード一式を含む。現在のメイン開発ブランチは FreeBSD 16.0 を対象としている。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| カーネル | モノリシックカーネル。amd64、arm64、i386、arm、riscv、powerpc 等の複数アーキテクチャをサポート |
| ネットワーキング | TCP/IP スタック、pf ファイアウォール、VNET (仮想ネットワークスタック)、netgraph フレームワーク |
| ストレージ | ZFS、UFS、GEOM ストレージフレームワーク、NVMe/NVMoF サポート |
| セキュリティ | MAC フレームワーク、Capsicum ケーパビリティモード、監査 (BSM)、Kerberos5 (Heimdal) |
| 仮想化 | bhyve ハイパーバイザー、jail コンテナ、Linux バイナリ互換 |
| デバイスドライバ | CAM (Common Access Method)、ネットワークドライバ (iwlwifi, aq, rge 等)、USB、PCIe |
| ユーザーランド | POSIX 準拠のコマンド群、libc、システムデーモン群、ブートローダー |
| ビルドシステム | bmake ベースのビルドシステム。クロスビルド、universe ビルド対応 |
| テスト | Kyua テストフレームワークによるリグレッションテスト |

## 技術スタック

### コア

- 言語: C (カーネル・ユーザーランドの主要部分)、C++ (一部のユーザーランドツール)、アセンブリ (アーキテクチャ固有コード)
- ビルドシステム: bmake (BSD make)
- カーネル: モノリシックカーネル + ローダブルカーネルモジュール
- ファイルシステム: ZFS、UFS/FFS
- ファイアウォール: pf (Packet Filter)
- ライセンス: BSD 2-Clause License

### 主要ライブラリ

- libc: FreeBSD 標準 C ライブラリ
- libcrypto / libssl: 暗号化ライブラリ (OpenSSL ベース)
- libc++: C++ 標準ライブラリ (LLVM プロジェクト由来)
- libarchive: アーカイブ操作ライブラリ
- libbearssl: 組み込み向け TLS ライブラリ (ブートローダー用)
- libcapsicum / libcasper: Capsicum サンドボックスフレームワーク
- libgeom: GEOM ストレージフレームワークライブラリ
- libcam: CAM (SCSI/ATA) サブシステムライブラリ

## ディレクトリ構成

```
freebsd-src-main/
├── bin/             # 基本ユーザーコマンド (/bin)
├── cddl/            # CDDL ライセンスのコマンド・ライブラリ (DTrace, ZFS 等)
├── contrib/         # サードパーティ提供パッケージ
├── crypto/          # 暗号化関連ソース
├── etc/             # /etc 用テンプレートファイル
├── gnu/             # GPL/LGPL ライセンスのコマンド・ライブラリ
├── include/         # システムインクルードファイル
├── kerberos5/       # Kerberos5 (Heimdal) パッケージ
├── lib/             # システムライブラリ群
├── libexec/         # システムデーモン群
├── release/         # リリースビルド用 Makefile・ツール
├── rescue/          # 静的リンクされた /rescue ユーティリティ
├── sbin/            # システム管理コマンド (/sbin)
├── secure/          # 暗号化ライブラリ・コマンド
├── share/           # 共有リソース (manページ、タイムゾーンデータ等)
├── stand/           # ブートローダーソース
├── sys/             # カーネルソース
│   ├── amd64/       #   x86-64 アーキテクチャ固有コード
│   ├── arm64/       #   AArch64 アーキテクチャ固有コード
│   ├── kern/        #   カーネルコア
│   ├── dev/         #   デバイスドライバ
│   ├── net/         #   ネットワークスタック
│   ├── fs/          #   ファイルシステム
│   ├── vm/          #   仮想メモリサブシステム
│   └── modules/     #   ローダブルカーネルモジュール
├── targets/         # 実験的 DIRDEPS_BUILD サポート
├── tests/           # Kyua リグレッションテスト
├── tools/           # ビルド・テスト用ユーティリティ
├── usr.bin/         # ユーザーコマンド (/usr/bin)
└── usr.sbin/        # システム管理コマンド (/usr/sbin)
```

## セットアップ

### 必要条件

- FreeBSD が動作するシステム (クロスビルドの場合は対応するツールチェーン)
- ディスク容量: `buildworld` に最低 6GB、`universe` ビルドには約 167GB (ZFS lz4 圧縮で約 81GB)
- bmake (FreeBSD 標準の make)

### ソースの取得

```sh
git clone https://git.freebsd.org/src.git /usr/src
```

または GitHub ミラーから:

```sh
git clone https://github.com/freebsd/freebsd-src.git /usr/src
```

### ビルド手順 (ソースからのアップグレード)

```sh
cd /usr/src
make buildworld
make buildkernel KERNCONF=GENERIC
make installkernel KERNCONF=GENERIC
# シングルユーザーモードで再起動
reboot
etcupdate -p
make installworld
etcupdate -B
make delete-old
reboot
make delete-old-libs
```

### クロスビルド

特定のアーキテクチャ向けにクロスビルドする場合:

```sh
make buildworld TARGET=arm64 TARGET_ARCH=aarch64
make buildkernel TARGET=arm64 TARGET_ARCH=aarch64 KERNCONF=GENERIC
```

GCC を使用したクロスビルド:

```sh
pkg install amd64-gcc13
make buildworld CROSS_TOOLCHAIN=amd64-gcc13
```

## 開発

### コーディングスタイル

- C コード: style(9) に準拠。`.clang-format` ファイルによる Clang Format 対応
- Lua コード: style.lua(9) に準拠
- Makefile: style.Makefile(5) に準拠
- マニュアルページ: style.mdoc(5) に準拠。`mandoc -Tlint` および `igor` でチェック
- シェルスクリプト: /bin/sh (POSIX sh) を使用。bash は使用不可

### スタイルチェック

```sh
tools/build/checkstyle9.pl <対象ファイル>
```

### テストの実行

テストは Kyua フレームワークを使用:

```sh
make checkworld
```

または個別テスト:

```sh
cd /usr/tests
kyua test
kyua report
```

### 主要ビルドターゲット

| ターゲット | 説明 |
| --- | --- |
| `buildworld` | ユーザーランド全体をリビルド |
| `installworld` | buildworld でビルドしたものをインストール |
| `buildkernel` | カーネルとカーネルモジュールをリビルド |
| `installkernel` | カーネルとカーネルモジュールをインストール |
| `world` | buildworld + installworld |
| `kernel` | buildkernel + installkernel |
| `universe` | 全アーキテクチャの buildworld + 全カーネルをビルド |
| `checkworld` | インストール済みワールドに対しテストスイートを実行 |
| `delete-old` | 廃止されたディレクトリ・ファイルを削除 |

### コントリビューション方法

- GitHub Pull Request (小規模な変更に推奨)
- Phabricator コードレビュー
- Bugzilla チケットへの添付
- Git リポジトリへの直接コミット (コミッター権限保持者)

詳細は [CONTRIBUTING.md](../../CONTRIBUTING.md) を参照。
