---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **universe ビルドのディスク容量 (167GB / 81GB)**：Makefile コメントに r340283 (2018-11) 時点の数値として記載あるが、現在のバージョンでは変動している可能性
  2. **主要ライブラリの一覧の網羅性**：lib/ ディレクトリから代表的なものを選定したが、選定基準が主観的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` (プロジェクトルート)
- E-02: `Makefile` (プロジェクトルート、ビルドターゲット・手順のコメント)
- E-03: `CONTRIBUTING.md` (コントリビューション方法・スタイルガイド)
- E-04: `RELNOTES` (FreeBSD 16.0 リリースノート)
- E-05: `UPDATING` (FreeBSD-CURRENT 更新情報)
- E-06: `COPYRIGHT` (ライセンス情報)
- E-07: `sys/` ディレクトリ構成 (カーネルソースの実在確認)
- E-08: `lib/` ディレクトリ構成 (ライブラリの実在確認)
- E-09: `tests/` ディレクトリ構成 (テストフレームワークの確認)
- E-10: `Makefile.inc1` (参照元として Makefile コメントに記載)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeBSD は30年以上開発されているオープンソース OS | E-01 | ○ |
| C-02 | サーバー、デスクトップ、組み込みプラットフォーム向け | E-01 | ○ |
| C-03 | 現在の開発対象は FreeBSD 16.0 | E-04, E-05 | ○ |
| C-04 | amd64, arm64, i386, arm, riscv, powerpc 等のアーキテクチャサポート | E-07 (sys/ 配下のディレクトリ) | ○ |
| C-05 | pf ファイアウォールのサポート | E-04 (IPv6 divert-to 対応の記載) | ○ |
| C-06 | ZFS, UFS ファイルシステムサポート | E-01 (cddl ディレクトリ説明) | ○ |
| C-07 | MAC フレームワーク (jail 操作拡張含む) | E-04 (mac(4) jail 拡張の記載) | ○ |
| C-08 | bhyve ハイパーバイザー | E-04 (bhyve VNC unix socket 対応) | ○ |
| C-09 | Capsicum ケーパビリティモード | E-08 (libcapsicum, libcasper の実在) | ○ |
| C-10 | Kyua テストフレームワーク | E-01 (tests ディレクトリ説明), E-09 | ○ |
| C-11 | 主要言語は C | E-03 (style(9) の参照), E-07 | ○ |
| C-12 | ビルドシステムは bmake | E-02, E-03 (GNU Make ではなく in-tree make) | ○ |
| C-13 | BSD 2-Clause ライセンス | E-06 | ○ |
| C-14 | ディレクトリ構成の各項目 | E-01 (Source Roadmap テーブル) | ○ |
| C-15 | buildworld に最低 6GB 必要 | E-02 (Makefile コメント) | ○ |
| C-16 | universe ビルドに約 167GB (ZFS lz4 で 81GB) | E-02 (Makefile コメント, r340283 時点) | △ |
| C-17 | git clone URL (git.freebsd.org) | E-01 (ソース同期の参照リンク) | ○ |
| C-18 | ビルド手順 (buildworld/buildkernel/installkernel 等) | E-02 (Makefile コメントの手順) | ○ |
| C-19 | クロスビルド手順 (TARGET/TARGET_ARCH) | E-02 (Makefile コメント) | ○ |
| C-20 | GCC クロスツールチェーンの使用方法 | E-02 (Makefile コメント) | ○ |
| C-21 | checkstyle9.pl によるスタイルチェック | E-03 (CONTRIBUTING.md) | ○ |
| C-22 | コントリビューション方法 (GitHub PR, Phabricator, Bugzilla, Git 直接) | E-03 | ○ |
| C-23 | 主要ライブラリ一覧 (libc, libcrypto, libc++, libarchive 等) | E-08 (lib/ ディレクトリの実在) | ○ |
| C-24 | libbearssl がブートローダー用 | **根拠なし** | △ |
| C-25 | Kerberos5 が Heimdal ベース | E-01 (kerberos5 ディレクトリ説明) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-16: universe ビルドのディスク容量は Makefile コメントに 2018年11月 (r340283) 時点の数値として記載されている。現行の FreeBSD 16.0 開発ブランチでは変動している可能性がある
  - 候補：最新の universe ビルドログ / CI 環境のディスク使用量レポート / 開発者メーリングリストの情報
- C-24: libbearssl の用途（ブートローダー用）について、lib/libbearssl 内のソースや stand/ ディレクトリとの関連を直接確認していない
  - 候補：`lib/libbearssl/Makefile` / `stand/` 配下の bearssl 参照 / FreeBSD ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロジェクト概要・ディレクトリ構成は公式 README.md との整合性が高い
- 0: 低リスク - ビルド手順は Makefile コメントに明確に記載されている
- 1: 中リスク - ディスク容量の数値は 2018年時点のもので、現在と乖離がある可能性
- 0: 低リスク - コントリビューション方法は CONTRIBUTING.md と完全に一致
- 1: 中リスク - 主要ライブラリの選定は主観的であり、網羅性の保証がない

## 6) レビュアーチェックリスト（最小）
- [ ] 対応アーキテクチャの一覧が最新の sys/ ディレクトリと一致しているか
- [ ] universe ビルドのディスク容量が現行バージョンで妥当か
- [ ] 主要ライブラリの選定が適切か（過不足がないか）
- [ ] git clone の URL が現在有効か
- [ ] ビルド手順が UPDATING の最新エントリと矛盾しないか
- [ ] libbearssl の用途説明が正確か
