---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **readシステムコールのデータフロー詳細**：完全なコールチェーンの実コード検証が未実施
  2. **VFS ops / 関数ポインタ経由の追跡手順**：一般的な説明にとどまり具体的なコード根拠が不足
  3. **style(9)準拠の詳細（中括弧ルール等）**：style(9) manpageの直接確認未実施
  4. **ビルドシステム（Makefile.inc1）の詳細動作**：内容の直接解析未実施
  5. **DTrace/KTR/WITNESSの具体的使用方法**：概要記載のみで実コード根拠が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `README.md` -- プロジェクト概要とディレクトリ構成表
- E-02: `sys/kern/init_main.c` -- カーネル起動コード（proc0, thread0, mi_startup, SYSINIT）
- E-03: `sys/sys/kernel.h` -- SYSINIT列挙型定義 (enum sysinit_sub_id)
- E-04: `sys/kern/kern_proc.c` -- プロセス管理コード（ヘッダ・インクルード構造）
- E-05: `sys/kern/kern_malloc.c` -- カーネルメモリアロケータ（malloc(9)実装、UMAバックエンド）
- E-06: `sys/dev/ahci/ahci.c` -- AHCIデバイスドライバ（典型的なドライバ構造）
- E-07: `sys/net/if.c` -- ネットワークインタフェース管理
- E-08: `bin/cat/cat.c` -- ユーザランドコマンドの構造例
- E-09: `sys/sys/param.h` -- システムパラメータ・バージョン定義
- E-10: `sys/sys/proc.h` -- プロセス構造体定義
- E-11: `Makefile` -- トップレベルビルドターゲット定義
- E-12: `sys/conf/` ディレクトリ一覧 -- カーネルコンフィグ・ビルド設定ファイル
- E-13: `sys/dev/` ディレクトリ一覧 -- デバイスドライバサブディレクトリ
- E-14: `sys/fs/` ディレクトリ一覧 -- ファイルシステム実装
- E-15: `sys/net/` ディレクトリ一覧 -- ネットワーク関連ソースファイル
- E-16: `sys/vm/` ディレクトリ一覧 -- 仮想メモリサブシステム
- E-17: `sys/modules/` ディレクトリ一覧 -- カーネルモジュール
- E-18: `share/man/man9/` ディレクトリ一覧 -- カーネルAPIマニュアル
- E-19: `sys/kern/` ディレクトリ一覧 -- カーネルコアファイル名パターン

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeBSDは主にC言語（C99/C11準拠）で記述されている | E-02, E-04, E-05, E-06 | ○ |
| C-02 | カーネルソースファイルはライセンスヘッダ、include、型定義、プロトタイプ、関数実装の順で構成 | E-02, E-05, E-06 | ○ |
| C-03 | sys/param.hは必ず最初にインクルードされる | E-02, E-04, E-05, E-06 | ○ |
| C-04 | opt_*.hはカーネルコンフィグオプションのヘッダで最初にインクルードされる | E-02, E-04, E-05 | ○ |
| C-05 | FreeBSDのカーネル初期化はSYSINITフレームワークで管理される | E-02, E-03 | ○ |
| C-06 | SYSINIT列挙型の数値順にサブシステムが初期化される | E-03 | ○ |
| C-07 | proc0とthread0がカーネル最初のプロセス/スレッドとして定義 | E-02 | ○ |
| C-08 | デバイスドライバはnewbusフレームワークに基づく | E-06, E-12 | ○ |
| C-09 | ドライバはprobe/attach/detach/suspend/resumeパターンに従う | E-06 | ○ |
| C-10 | SYSCTL_INTマクロでランタイムパラメータを宣言する | E-02 | ○ |
| C-11 | kern_*.cがカーネルコア機能の命名パターン | E-19 | ○ |
| C-12 | if_*.cがネットワークインタフェースの命名パターン | E-15 | ○ |
| C-13 | vm_*.cが仮想メモリサブシステムの命名パターン | E-16 | ○ |
| C-14 | *_if.mがデバイスインタフェース定義ファイル | E-19 | ○ |
| C-15 | ディレクトリ構造（bin, sbin, sys, lib等）の役割説明 | E-01 | ○ |
| C-16 | sys/kern/がカーネルコア機能を含む | E-19, E-02, E-04, E-05 | ○ |
| C-17 | sys/dev/がデバイスドライバを含む | E-13 | ○ |
| C-18 | sys/fs/がファイルシステム実装を含む | E-14 | ○ |
| C-19 | sys/net/がネットワーク基盤を含む | E-15 | ○ |
| C-20 | FreeBSDはモノリシックカーネル+KLDアーキテクチャ | E-03, E-17 | ○ |
| C-21 | カーネルメモリアロケータはmalloc(9)でUMAバックエンド | E-05 | ○ |
| C-22 | M_WAITOK/M_NOWAIT/M_ZEROフラグの説明 | E-05 | ○ |
| C-23 | queue.hマクロ（SLIST, LIST, STAILQ, TAILQ）が広範に使用 | E-02 | ○ |
| C-24 | mi_startup()がカーネル初期化のエントリーポイント | E-02 | ○ |
| C-25 | __unusedアトリビュートで未使用パラメータを明示 | E-02 | ○ |
| C-26 | 関数の戻り値を括弧付きでreturnする慣習 | E-02 | ○ |
| C-27 | ユーザランドコマンドは標準的なCプログラム構造に従う | E-08 | ○ |
| C-28 | share/man/man9/にカーネルAPIリファレンスが存在 | E-18 | ○ |
| C-29 | Makefileのbuildworld/buildkernelターゲット | E-11 | ○ |
| C-30 | sys/conf/optionsからopt_*.hが生成される | E-12 | ○ |
| C-31 | readシステムコールの完全なデータフロー（sys_read→vn_read→FS→デバイス） | **根拠なし** | △ |
| C-32 | style(9)に準拠したコーディングスタイル（中括弧は1行でも省略しない等） | **根拠なし** | △ |
| C-33 | gotoパターンが正常なエラーハンドリングとして広く使用される | **根拠なし** | △ |
| C-34 | ロッキングプリミティブの種類と用途（mutex, sx, rwlock, rmlock, epoch） | **根拠なし** | △ |
| C-35 | DTrace/KTR/WITNESSの具体的なデバッグ利用方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-31: readシステムコールのデータフローは一般的なFreeBSDカーネルの知識に基づく記述であり、`sys/kern/sys_generic.c` や `sys/kern/vfs_vnops.c` の実コードを直接確認していない
  - 候補：`sys/kern/sys_generic.c` / `sys/kern/vfs_vnops.c` / `sys/kern/vfs_lookup.c`
- C-32: style(9) manpageの直接内容確認を行っていない。コーディングスタイルの記述はソースコード観察から推定
  - 候補：`share/man/man9/style.9` / FreeBSD公式ドキュメント
- C-33: gotoパターンは一般的なBSDカーネルコーディング慣習として知られているが、本プロジェクト内での具体的な使用例の直接確認が限定的
  - 候補：`sys/kern/` 配下の任意のファイルでgoto使用箇所を検索
- C-34: ロッキングプリミティブの説明は一般的なFreeBSD知識に基づく。各ヘッダファイルの直接確認は未実施
  - 候補：`sys/sys/mutex.h` / `sys/sys/sx.h` / `sys/sys/rwlock.h` / `sys/sys/epoch.h`
- C-35: デバッグ機能の説明は一般知識に基づく。具体的な設定手順やコード例の直接確認は未実施
  - 候補：`sys/ddb/` / `sys/kern/subr_witness.c` / `cddl/contrib/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- ディレクトリ構造、ファイル命名規則、インクルードパターン（直接確認済み）
- 1: 中リスク -- readシステムコールのデータフロー、gotoパターンの普遍性、ロッキングプリミティブ一覧（一般知識ベースだが高い確度）
- 1: 中リスク -- style(9)準拠のコーディングスタイル詳細（manpage未確認）
- 0: 低リスク -- SYSINITフレームワーク、デバイスドライバパターン（実コードで確認済み）
- 1: 中リスク -- デバッグツール（DTrace, KTR, WITNESS）の具体的手順（概要レベルの記載）

## 6) レビュアーチェックリスト（最小）
- [ ] readシステムコールのデータフロー（C-31）が `sys/kern/sys_generic.c` のコードと整合しているか確認
- [ ] style(9) manpageの内容と「中括弧の省略しない傾向」等の記述が一致するか確認
- [ ] gotoパターンが実際にカーネルコードで広く使用されているか `sys/kern/` 配下でサンプル確認
- [ ] ロッキングプリミティブ（mutex, sx, rwlock, rmlock, epoch）の説明が各ヘッダファイルと整合するか確認
- [ ] デバッグ関連の記述（DDB, KTR, WITNESS, DTrace）が現在のFreeBSDバージョンで有効か確認
- [ ] SYSINIT列挙型の値が `sys/sys/kernel.h` の最新版と一致しているか確認
- [ ] ファイルパスと行番号の参照が実際のソースと一致するか確認
