---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **ZFS 関連記述（CDDL配下）**：cddl/contrib/openzfs/ の正確なパス構成が未確認
  2. **libpthread の正確なパス**：lib/libpthread/ vs lib/libthr/ の命名確認が必要
  3. **DTrace の正確な配置パス**：cddl/ 配下の詳細構造が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `README.md`（ソースツリーロードマップ）
- E-02: `sys/kern/` ディレクトリ一覧（init_main.c, init_sysent.c, kern_fork.c, kern_exit.c 等の存在確認）
- E-03: `sys/vm/` ディレクトリ一覧（uma_core.c, vm_fault.c 等の存在確認）
- E-04: `sys/net/` ディレクトリ一覧
- E-05: `sys/netinet/` ディレクトリの存在確認
- E-06: `sys/netinet6/` ディレクトリの存在確認
- E-07: `sys/fs/` ディレクトリ一覧（autofs, cd9660, devfs, ext2fs, fuse, msdosfs, nullfs, procfs, tmpfs 等）
- E-08: `sys/ufs/` ディレクトリの存在確認
- E-09: `sys/dev/` ディレクトリ一覧（多数のデバイスドライバ）
- E-10: `sys/cam/` ディレクトリの存在確認
- E-11: `sys/geom/` ディレクトリの存在確認
- E-12: `sys/security/` ディレクトリ一覧（audit, mac, mac_biba, mac_mls, mac_lomac 等）
- E-13: `sys/opencrypto/` ディレクトリ一覧（crypto.c, cryptodev.c 等）
- E-14: `sys/ddb/` ディレクトリの存在確認
- E-15: `sys/gdb/` ディレクトリの存在確認
- E-16: `sys/compat/` ディレクトリの存在確認
- E-17: `sys/conf/` ディレクトリ一覧（ビルド設定ファイル）
- E-18: `sys/modules/` ディレクトリの存在確認
- E-19: `sys/amd64/`, `sys/arm64/`, `sys/arm/`, `sys/i386/`, `sys/powerpc/`, `sys/riscv/` ディレクトリの存在確認
- E-20: `sys/x86/` ディレクトリの存在確認
- E-21: `stand/` ディレクトリの存在確認
- E-22: `sys/netpfil/` ディレクトリの存在確認
- E-23: `sys/netipsec/` ディレクトリの存在確認
- E-24: `sys/netlink/` ディレクトリの存在確認
- E-25: `sys/netgraph/` ディレクトリの存在確認
- E-26: `sys/xen/` ディレクトリの存在確認
- E-27: `sys/rpc/` ディレクトリの存在確認
- E-28: `sys/nfsclient/`, `sys/nfsserver/` ディレクトリの存在確認
- E-29: `Makefile` 先頭部分（ビルドターゲット定義）
- E-30: `sys/kern/` のファイル一覧（bus_if.m, device_if.m 等のインターフェース定義ファイル）
- E-31: `sbin/` ディレクトリ一覧
- E-32: `lib/` ディレクトリ一覧
- E-33: `sys/crypto/` ディレクトリの存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeBSD はモノリシックカーネルアーキテクチャを採用 | E-02, E-18 | ○ |
| C-02 | ソースツリーは README.md に記載のロードマップ通りの構造 | E-01 | ○ |
| C-03 | sys/kern/ がカーネルコア（プロセス管理、VFS、IPC）を含む | E-02 | ○ |
| C-04 | sys/vm/ が仮想メモリサブシステムを含む | E-03 | ○ |
| C-05 | sys/net/, sys/netinet/, sys/netinet6/ がネットワークスタックを構成 | E-04, E-05, E-06 | ○ |
| C-06 | sys/fs/ に多数のファイルシステム実装が存在 | E-07 | ○ |
| C-07 | sys/ufs/ に UFS/FFS が存在 | E-08 | ○ |
| C-08 | sys/dev/ にデバイスドライバ群が存在 | E-09 | ○ |
| C-09 | sys/cam/ が Common Access Method を提供 | E-10 | ○ |
| C-10 | sys/geom/ が GEOM ストレージフレームワークを提供 | E-11 | ○ |
| C-11 | sys/security/ に MAC フレームワークと監査機能が存在 | E-12 | ○ |
| C-12 | MAC ポリシーモジュール（Biba, MLS, LOMAC等）が存在 | E-12 | ○ |
| C-13 | sys/opencrypto/ に暗号フレームワークが存在 | E-13 | ○ |
| C-14 | sys/ddb/, sys/gdb/ にデバッグ機能が存在 | E-14, E-15 | ○ |
| C-15 | sys/compat/ にOS互換レイヤーが存在 | E-16 | ○ |
| C-16 | 複数CPUアーキテクチャ（amd64, arm64, i386, riscv, powerpc）をサポート | E-19 | ○ |
| C-17 | sys/x86/ にamd64/i386共有コードが存在 | E-20 | ○ |
| C-18 | stand/ にブートローダソースが存在 | E-21 | ○ |
| C-19 | sys/netpfil/ にパケットフィルタ（pf, ipfw）が存在 | E-22 | ○ |
| C-20 | sys/netipsec/ に IPsec が存在 | E-23 | ○ |
| C-21 | sys/netlink/ に Netlink が存在 | E-24 | ○ |
| C-22 | sys/netgraph/ にネットワークグラフフレームワークが存在 | E-25 | ○ |
| C-23 | sys/xen/ に Xen パラバーチャル化サポートが存在 | E-26 | ○ |
| C-24 | NFS クライアント/サーバが sys/nfsclient/, sys/nfsserver/ に存在 | E-28 | ○ |
| C-25 | bus_if.m, device_if.m による Newbus デバイスモデル | E-30 | ○ |
| C-26 | ビルドシステムは BSD make ベース | E-17, E-29 | ○ |
| C-27 | tests/ にリグレッションテスト（Kyua）が存在 | E-01 | ○ |
| C-28 | ZFS は cddl/contrib/openzfs/ に配置 | **根拠なし** | △ |
| C-29 | lib/libpthread/ がPOSIXスレッドライブラリを提供 | **根拠なし** | △ |
| C-30 | DTrace が sys/cddl/ 配下に存在 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: cddl/ ディレクトリの詳細な内部構造を確認していないため、ZFS のソースコードの正確な配置パスが未検証
  - 候補：cddl/contrib/openzfs/ / cddl/contrib/opensolaris/ / sys/contrib/openzfs/
- C-29: lib/ ディレクトリ一覧に libpthread が直接確認できず、libthr として実装されている可能性がある
  - 候補：lib/libpthread/ / lib/libthr/ / lib/libpthread がlibthrへのシンボリックリンク
- C-30: sys/cddl/ の内部構造の詳細確認が未実施
  - 候補：sys/cddl/dev/dtrace/ / sys/cddl/contrib/opensolaris/ / cddl/contrib/opensolaris/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースツリー全体構造の記述（README.md と実際のディレクトリ構造で十分に裏付けあり）
- 0: 低リスク - カーネルサブシステム（kern, vm, net, fs, dev, cam, geom）の記述（ディレクトリ存在を確認済み）
- 0: 低リスク - セキュリティフレームワーク（MAC, audit, opencrypto）の記述（ディレクトリ内容を確認済み）
- 1: 中リスク - CDDL 関連コンポーネント（ZFS, DTrace）の正確なパスと構成（詳細未確認）
- 1: 中リスク - 個別ファイル名の正確性（ソースファイルの内容解析は限定的）
- 0: 低リスク - アーキテクチャスタイル（モノリシックカーネル）の記述（FreeBSD の公知の設計方針）

## 6) レビュアーチェックリスト（最小）
- [ ] ZFS のソースコード配置パス（cddl/contrib/openzfs/ vs 他）が正確か確認
- [ ] libpthread / libthr の正確な名称とパスを確認
- [ ] DTrace の正確な配置パスを確認（sys/cddl/ 内の構造）
- [ ] Soft Updates の記述（ffs_softdep.c）が現行コードと一致するか確認
- [ ] Capsicum 関連ファイル（sys_capability.c）の正確なパスを確認
- [ ] style(9) の記述が最新のコーディング規約と一致するか確認
- [ ] GEOM サブモジュール（ELI, Mirror, Stripe等）の存在を確認
