# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph UserLand["ユーザランド"]
        BIN["bin/<br/>基本コマンド<br/>(sh, ls, cp)"]
        SBIN["sbin/<br/>システム管理コマンド<br/>(mount, ifconfig, fsck)"]
        USRBIN["usr.bin/<br/>ユーザコマンド<br/>(cc, make, grep)"]
        USRSBIN["usr.sbin/<br/>管理デーモン<br/>(sshd, cron)"]
        LIBEXEC["libexec/<br/>システムデーモン"]
    end

    subgraph SysLib["システムライブラリ (lib/)"]
        LIBC["libc<br/>標準Cライブラリ"]
        LIBPTHREAD["libpthread<br/>スレッドライブラリ"]
        LIBCRYPTO["libcrypto<br/>暗号ライブラリ"]
        LIBPAM["libpam<br/>認証モジュール"]
    end

    subgraph Kernel["カーネル (sys/)"]
        subgraph KernCore["カーネルコア (sys/kern/)"]
            SYSCALL["システムコール<br/>ディスパッチ<br/>(init_sysent.c)"]
            PROC["プロセス管理<br/>(kern_fork, kern_exit,<br/>sched_ule)"]
            IPC["IPC<br/>(pipe, socket,<br/>shm, mqueue)"]
            VFS["VFS層<br/>(vfs_vnops,<br/>vfs_bio, vfs_cache)"]
        end

        subgraph VM["仮想メモリ (sys/vm/)"]
            VMFAULT["vm_fault"]
            VMPAGE["vm_page"]
            UMA["UMAアロケータ<br/>(uma_core.c)"]
        end

        subgraph NetStack["ネットワーク"]
            NET["net/<br/>共通ネットワーク層"]
            NETINET["netinet/<br/>IPv4"]
            NETINET6["netinet6/<br/>IPv6"]
            NETPFIL["netpfil/<br/>パケットフィルタ<br/>(pf, ipfw)"]
            NETIPSEC["netipsec/<br/>IPsec"]
            NETLINK["netlink/"]
            NETGRAPH["netgraph/<br/>ネットワークグラフ"]
        end

        subgraph FS["ファイルシステム"]
            UFS["ufs/<br/>UFS2/FFS"]
            FSMISC["fs/<br/>tmpfs, nullfs, devfs,<br/>procfs, fuse, ext2fs,<br/>msdosfs, cd9660 等"]
            NFS["nfsclient/<br/>nfsserver/"]
        end

        subgraph Storage["ストレージ"]
            GEOM["geom/<br/>GEOMフレームワーク"]
            CAM["cam/<br/>Common Access Method"]
        end

        subgraph Security["セキュリティ"]
            MAC["security/mac/<br/>MACフレームワーク"]
            AUDIT["security/audit/<br/>BSM監査"]
            CRYPTO["opencrypto/<br/>暗号フレームワーク"]
        end

        subgraph DevDrivers["デバイスドライバ (sys/dev/)"]
            DEVNET["ネットワーク<br/>ドライバ"]
            DEVSTOR["ストレージ<br/>ドライバ"]
            DEVMISC["その他<br/>ドライバ"]
        end

        subgraph MDLayer["マシン依存層"]
            AMD64["amd64/"]
            ARM64["arm64/"]
            I386["i386/"]
            RISCV["riscv/"]
            POWERPC["powerpc/"]
        end

        DDB["ddb/<br/>カーネルデバッガ"]
        COMPAT["compat/<br/>OS互換レイヤー"]
    end

    subgraph Boot["ブートローダ (stand/)"]
        LOADER["loader<br/>カーネルロード"]
    end

    subgraph HW["ハードウェア"]
        CPU["CPU"]
        MEM["メモリ"]
        DISK["ストレージデバイス"]
        NIC["ネットワークデバイス"]
    end

    BIN --> LIBC
    SBIN --> LIBC
    USRBIN --> LIBC
    USRSBIN --> LIBC
    LIBEXEC --> LIBC
    LIBC --> SYSCALL

    SYSCALL --> PROC
    SYSCALL --> VFS
    SYSCALL --> IPC

    IPC --> NET

    VFS --> UFS
    VFS --> FSMISC
    VFS --> NFS

    UFS --> GEOM
    GEOM --> CAM
    CAM --> DEVSTOR

    NET --> NETINET
    NET --> NETINET6
    NETINET --> NETPFIL
    NETINET --> NETIPSEC
    NET --> DEVNET

    PROC --> VM
    VFS --> VM

    MAC --> VFS
    MAC --> PROC
    AUDIT --> SYSCALL
    CRYPTO --> NETIPSEC

    MDLayer --> CPU
    MDLayer --> MEM
    DEVSTOR --> DISK
    DEVNET --> NIC

    LOADER --> MDLayer

    style UserLand fill:#e1f5fe,stroke:#0288d1
    style SysLib fill:#e8f5e9,stroke:#388e3c
    style Kernel fill:#fff3e0,stroke:#f57c00
    style Boot fill:#f3e5f5,stroke:#7b1fa2
    style HW fill:#fce4ec,stroke:#c62828
```

## カーネル内部レイヤー構成図

```mermaid
graph LR
    subgraph Layer1["システムコール境界"]
        SC["syscall<br/>ディスパッチ"]
    end

    subgraph Layer2["カーネル上位サブシステム (MI)"]
        PROC2["プロセス管理"]
        VFS2["VFS"]
        SOCK["ソケット層"]
        VM2["VM"]
    end

    subgraph Layer3["プロトコル・FS実装"]
        TCP["TCP/UDP"]
        IP["IP"]
        FFS["FFS/UFS2"]
        ZFS2["ZFS"]
        TMPFS["tmpfs"]
    end

    subgraph Layer4["フレームワーク層"]
        GEOM2["GEOM"]
        CAM2["CAM"]
        NEWBUS["Newbus"]
    end

    subgraph Layer5["デバイスドライバ"]
        DRV["各種ドライバ"]
    end

    subgraph Layer6["マシン依存層 (MD)"]
        TRAP["トラップ処理"]
        PMAP["pmap (MMU)"]
        INTR["割り込み処理"]
    end

    SC --> Layer2
    Layer2 --> Layer3
    Layer3 --> Layer4
    Layer4 --> Layer5
    Layer5 --> Layer6

    style Layer1 fill:#e3f2fd,stroke:#1565c0
    style Layer2 fill:#e8f5e9,stroke:#2e7d32
    style Layer3 fill:#fff9c4,stroke:#f9a825
    style Layer4 fill:#ffe0b2,stroke:#ef6c00
    style Layer5 fill:#ffccbc,stroke:#d84315
    style Layer6 fill:#f8bbd0,stroke:#ad1457
```

## ストレージI/Oフロー図

```mermaid
graph TD
    APP["ユーザアプリケーション<br/>write()/read()"] --> LIBC2["libc"]
    LIBC2 --> SYSCALL2["システムコール"]
    SYSCALL2 --> VFS3["VFS層<br/>(vfs_vnops.c)"]
    VFS3 --> BUF["バッファキャッシュ<br/>(vfs_bio.c)"]
    BUF --> FFS2["FFS/UFS2<br/>(ffs_vnops.c)"]
    FFS2 --> GEOM3["GEOM<br/>変換スタック"]
    GEOM3 --> GELI["GEOM ELI<br/>(暗号化)"]
    GEOM3 --> GMIRROR["GEOM Mirror<br/>(ミラーリング)"]
    GEOM3 --> GSTRIPE["GEOM Stripe<br/>(ストライピング)"]
    GELI --> CAM3["CAM<br/>サブシステム"]
    GMIRROR --> CAM3
    GSTRIPE --> CAM3
    GEOM3 --> CAM3
    CAM3 --> AHCI["AHCIドライバ"]
    CAM3 --> NVME["NVMeドライバ"]
    CAM3 --> SCSI["SCSIドライバ"]
    AHCI --> HWDISK["物理ディスク"]
    NVME --> HWDISK
    SCSI --> HWDISK

    style APP fill:#e3f2fd
    style VFS3 fill:#e8f5e9
    style GEOM3 fill:#fff9c4
    style CAM3 fill:#ffe0b2
    style HWDISK fill:#fce4ec
```

## セキュリティフレームワーク構成図

```mermaid
graph TD
    subgraph SecurityFramework["セキュリティフレームワーク"]
        MAC2["MAC フレームワーク<br/>(security/mac/)"]
        BIBA["mac_biba<br/>Biba整合性モデル"]
        MLS["mac_mls<br/>多レベルセキュリティ"]
        LOMAC["mac_lomac<br/>Low-watermark MAC"]
        BSDEXT["mac_bsdextended<br/>拡張BSDパーミッション"]
        PORTACL["mac_portacl<br/>ポートACL"]
        VERIEXEC["mac_veriexec<br/>実行ファイル検証"]

        MAC2 --> BIBA
        MAC2 --> MLS
        MAC2 --> LOMAC
        MAC2 --> BSDEXT
        MAC2 --> PORTACL
        MAC2 --> VERIEXEC
    end

    subgraph AuditFramework["監査フレームワーク"]
        BSM["BSM 監査<br/>(security/audit/)"]
    end

    subgraph CryptoFramework["暗号フレームワーク"]
        OCF["OpenCrypto<br/>(opencrypto/)"]
        SWCRYPTO["ソフトウェア暗号"]
        HWCRYPTO["ハードウェア暗号<br/>アクセラレータ"]
        OCF --> SWCRYPTO
        OCF --> HWCRYPTO
    end

    subgraph Sandbox["サンドボックス"]
        CAPSICUM["Capsicum<br/>ケイパビリティモード"]
        JAIL["jail<br/>OS仮想化"]
    end

    KERN["カーネル各サブシステム"] --> MAC2
    KERN --> BSM
    KERN --> CAPSICUM
    KERN --> JAIL
    NETIPSEC2["IPsec"] --> OCF

    style SecurityFramework fill:#fce4ec,stroke:#c62828
    style AuditFramework fill:#f3e5f5,stroke:#7b1fa2
    style CryptoFramework fill:#e8eaf6,stroke:#283593
    style Sandbox fill:#e0f2f1,stroke:#00695c
```
