# アーキテクチャ設計書

## 概要

本ドキュメントは、FreeBSD オペレーティングシステムのソースコード（freebsd-src-main）のアーキテクチャ設計について記載する。FreeBSD は30年以上にわたり開発が続けられているオープンソースの UNIX 系オペレーティングシステムであり、カーネル、ユーザランドユーティリティ、システムライブラリ、ブートローダ等を含む統合的なソースツリーで構成される。本設計書では、ソースツリー全体の構造、カーネルアーキテクチャ、ユーザランド構成、横断的関心事について解説する。

## システム全体構成

### アーキテクチャ概要図

[アーキテクチャ構成図](./アーキテクチャ構成図.md) を参照。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| ハードウェアデバイス | デバイスドライバ（sys/dev/）、バスインターフェース（device_if.m, bus_if.m） | ハードウェア制御・入出力 |
| ネットワーク | TCP/IPスタック（sys/netinet/, sys/netinet6/）、ソケットAPI | ネットワーク通信 |
| ストレージデバイス | CAM（Common Access Method）サブシステム（sys/cam/）、GEOMフレームワーク（sys/geom/） | ディスクI/O |
| ユーザプロセス | システムコールインターフェース（sys/kern/init_sysent.c）、libc | ユーザランドとカーネルの境界 |
| 外部ファイルシステム | NFS クライアント/サーバ（sys/nfsclient/, sys/nfsserver/）、FUSE（sys/fs/fuse/） | リモート・外部ファイルシステムアクセス |
| Xen ハイパーバイザ | Xen パラバーチャル化インターフェース（sys/xen/） | 仮想化環境連携 |

## レイヤー構成

### アーキテクチャスタイル

FreeBSD はモノリシックカーネルアーキテクチャを採用している。カーネル全体が単一のアドレス空間で動作し、カーネルモジュール（KLD: Kernel Loadable Module）による動的拡張をサポートする。ユーザランドとカーネルの間はシステムコールインターフェースで明確に分離されている。

カーネル内部は機能別サブシステムに分割されており、レイヤード構造を持つ。上位レイヤーから下位レイヤーへの依存が基本であるが、コールバックやイベントハンドラによる逆方向の通知メカニズムも存在する。

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| ユーザランドアプリケーション | ユーザ向けコマンド・ユーティリティの提供 | bin/, usr.bin/, usr.sbin/, sbin/ |
| システムライブラリ | ユーザランドプログラムへのAPI提供、システムコールラッパー | lib/libc/, lib/libpthread/, lib/libm/ 等 |
| システムコールインターフェース | ユーザランドとカーネルの境界、トラップハンドリング | sys/kern/init_sysent.c, syscalls.master |
| カーネル上位サブシステム | プロセス管理、ファイルシステム、ネットワークプロトコル | sys/kern/, sys/fs/, sys/netinet/ |
| カーネルフレームワーク | デバイスアクセス抽象化、ストレージ抽象化 | sys/cam/, sys/geom/, sys/dev/ |
| マシン依存層（MD層） | CPU・プラットフォーム固有処理、割り込み、MMU | sys/amd64/, sys/arm64/, sys/i386/, sys/riscv/ |
| ブートローダ | システム起動、カーネルロード | stand/ |

### レイヤー間の依存関係ルール

- ユーザランドプログラムはシステムライブラリ（libc等）を介してカーネルにアクセスする。直接カーネルメモリへのアクセスは禁止されている。
- カーネル上位サブシステムはマシン非依存（MI: Machine Independent）コードで記述され、マシン依存（MD: Machine Dependent）層の抽象インターフェースを呼び出す。
- デバイスドライバはバスインターフェース（bus_if.m, device_if.m）で定義された標準インターフェースに従う。
- ファイルシステムは VFS（Virtual File System）インターフェースを通じてカーネルに統合される。
- ネットワークプロトコルはソケット層を通じてユーザランドに公開される。
- カーネルモジュール（KLD）はモジュールインターフェースを通じて動的にロード・アンロードされる。

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| プロセス管理 | プロセス生成・終了・スケジューリング・シグナル処理 | sys/kern/kern_fork.c, kern_exit.c, kern_sig.c, sched_ule.c |
| メモリ管理 | 仮想メモリ、物理メモリ割当、ページング、UMAアロケータ | sys/vm/, sys/kern/subr_vmem.c |
| ファイルシステム | VFS抽象化、個別FS実装、バッファキャッシュ | sys/kern/vfs_*, sys/fs/, sys/ufs/ |
| ネットワーク | TCP/IP スタック、ソケット、ルーティング、パケットフィルタ | sys/net/, sys/netinet/, sys/netinet6/, sys/netpfil/ |
| デバイスドライバ | ハードウェアデバイス制御 | sys/dev/ |
| ストレージ | SCSI/ATA 抽象化、ディスクパーティション | sys/cam/, sys/geom/ |
| セキュリティ | MAC フレームワーク、監査、暗号化 | sys/security/, sys/opencrypto/, sys/crypto/ |
| 互換性 | 他OSバイナリ互換 | sys/compat/ |
| ネットワークファイルシステム | NFS クライアント/サーバ、RPC | sys/nfsclient/, sys/nfsserver/, sys/rpc/ |
| デバッグ | カーネルデバッガ、GDBスタブ | sys/ddb/, sys/gdb/ |

### パッケージ構造

```
freebsd-src-main/
├── bin/                    # 基本ユーザコマンド (sh, ls, cp, mv 等)
├── sbin/                   # 基本システム管理コマンド (mount, ifconfig, fsck 等)
├── usr.bin/                # 追加ユーザコマンド (cc, make, grep 等)
├── usr.sbin/               # 追加システム管理コマンド (sshd, cron 等)
├── lib/                    # システムライブラリ
│   ├── libc/               # 標準Cライブラリ
│   ├── libpthread/         # POSIXスレッドライブラリ (libthr)
│   ├── libcrypto/          # 暗号ライブラリ
│   └── ...                 # その他多数のライブラリ
├── libexec/                # システムデーモン・ヘルパープログラム
├── include/                # システムヘッダファイル
├── sys/                    # カーネルソースコード
│   ├── kern/               # カーネルコア (プロセス管理, VFS, IPC等)
│   ├── vm/                 # 仮想メモリサブシステム
│   ├── net/                # ネットワーク共通層
│   ├── netinet/            # IPv4プロトコルスタック
│   ├── netinet6/           # IPv6プロトコルスタック
│   ├── netpfil/            # パケットフィルタ (pf, ipfw)
│   ├── netipsec/           # IPsec
│   ├── netlink/            # Netlink
│   ├── fs/                 # ファイルシステム実装群
│   ├── ufs/                # Unix File System (FFS/UFS2)
│   ├── dev/                # デバイスドライバ
│   ├── cam/                # Common Access Method (SCSI/ATA)
│   ├── geom/               # GEOMストレージフレームワーク
│   ├── security/           # セキュリティフレームワーク (MAC, audit)
│   ├── opencrypto/         # 暗号フレームワーク
│   ├── crypto/             # 暗号アルゴリズム実装
│   ├── ddb/                # カーネルデバッガ
│   ├── gdb/                # GDBリモートスタブ
│   ├── compat/             # OS互換レイヤー
│   ├── conf/               # カーネルビルド設定
│   ├── modules/            # カーネルモジュールビルド定義
│   ├── sys/                # カーネルヘッダファイル
│   ├── amd64/              # x86-64アーキテクチャ依存コード
│   ├── arm64/              # AArch64アーキテクチャ依存コード
│   ├── arm/                # ARMアーキテクチャ依存コード
│   ├── i386/               # x86 (32bit) アーキテクチャ依存コード
│   ├── powerpc/            # PowerPCアーキテクチャ依存コード
│   ├── riscv/              # RISC-Vアーキテクチャ依存コード
│   └── x86/                # x86共通コード (amd64/i386共有)
├── stand/                  # ブートローダソース
├── etc/                    # /etc テンプレートファイル
├── share/                  # 共有リソース (man, locale等)
├── contrib/                # サードパーティ寄贈パッケージ
├── crypto/                 # 暗号関連外部パッケージ
├── cddl/                   # CDDL ライセンスのコード (ZFS, DTrace)
├── gnu/                    # GPL/LGPL ライセンスのコード
├── secure/                 # 暗号関連のコマンド・ライブラリ
├── tests/                  # リグレッションテスト (Kyua)
├── tools/                  # ビルド・テストユーティリティ
├── release/                # リリースビルドツール
├── rescue/                 # 静的リンクレスキューユーティリティ
├── targets/                # DIRDEPS_BUILD サポート
├── kerberos5/              # Kerberos5 (Heimdal)
└── Makefile                # トップレベルビルドシステム
```

### コンポーネント依存関係

- **ユーザランドプログラム** --> **lib/libc/** --> **システムコールインターフェース** --> **sys/kern/**
- **sys/kern/（VFS層）** --> **sys/fs/*, sys/ufs/**（個別ファイルシステム実装）
- **sys/kern/（ソケット層）** --> **sys/netinet/, sys/netinet6/**（プロトコル実装）
- **sys/netinet/** --> **sys/net/**（ネットワーク共通層）
- **sys/cam/** --> **sys/dev/**（ストレージデバイスドライバ）
- **sys/geom/** --> **sys/cam/**（ストレージアクセス）
- **sys/kern/（MI層）** --> **sys/amd64/, sys/arm64/ 等**（MD層、プラットフォーム固有処理）
- **sys/security/mac** --> **sys/kern/**（MAC フレームワークフック）

## ミドルウェア構成

### データベース

FreeBSD はオペレーティングシステムであり、アプリケーションレベルのデータベースミドルウェアは含まない。ただし、以下のデータ管理機構を持つ。

| 種類 | ミドルウェア | 用途 |
| --- | --- | --- |
| ファイルシステム | UFS2/FFS | デフォルトのファイルシステム（sys/ufs/） |
| ファイルシステム | ZFS（CDDL） | 高機能ファイルシステム（cddl/contrib/openzfs/） |
| ファイルシステム | msdosfs, cd9660, ext2fs, tmpfs 等 | 各種ファイルシステムサポート（sys/fs/） |

### キャッシュ

| ミドルウェア | 実装箇所 | 用途 | TTL |
| --- | --- | --- | --- |
| バッファキャッシュ | sys/kern/vfs_bio.c | ディスクブロックのキャッシュ | LRU方式で動的管理 |
| ネームキャッシュ | sys/kern/vfs_cache.c | ファイル名からvnodeの解決キャッシュ | 動的管理 |
| UMAゾーンアロケータ | sys/vm/uma_core.c | カーネルオブジェクトのスラブアロケータ | N/A |
| ルートキャッシュ | sys/net/route.c | ネットワークルーティングテーブルキャッシュ | タイムアウトベース |

### メッセージキュー

| ミドルウェア | 実装箇所 | 用途 |
| --- | --- | --- |
| POSIX メッセージキュー | sys/kern/uipc_mqueue.c | プロセス間通信 |
| System V メッセージキュー | sys/kern/sysv_msg.c | レガシーIPC |
| Netlink | sys/netlink/ | カーネル-ユーザランド間ネットワーク設定通知 |

### 検索エンジン

該当なし（OS カーネルであるため、検索エンジンミドルウェアは含まない）。

### その他ミドルウェア

| ミドルウェア | 実装箇所 | 用途 |
| --- | --- | --- |
| OpenCrypto フレームワーク | sys/opencrypto/ | 暗号処理の抽象化・ハードウェアアクセラレータ連携 |
| DTrace | cddl/contrib/opensolaris/、sys/cddl/ | 動的トレーシングフレームワーク |
| GEOM | sys/geom/ | ストレージ変換・管理フレームワーク（RAID, 暗号化, パーティション） |
| devd | sbin/devd/ | デバイスイベントデーモン |
| Netgraph | sys/netgraph/ | ネットワークグラフベースフレームワーク |

## データフロー

### リクエスト処理の流れ（システムコール）

ユーザランドプロセスからカーネルへのシステムコール処理フローを示す。

1. ユーザランドプログラムが libc の関数（例: read()）を呼び出す
2. libc が適切なシステムコール番号を設定し、トラップ命令（syscall/svc）を発行
3. CPU がカーネルモードに遷移し、MD層のトラップハンドラが起動（例: sys/amd64/amd64/trap.c）
4. トラップハンドラがシステムコールディスパッチテーブル（sys/kern/init_sysent.c）を参照し、対応するカーネル関数を呼び出す
5. カーネル関数が処理を実行（例: VFS 層 --> 個別ファイルシステム --> デバイスドライバ）
6. 結果をユーザランドに返却し、CPU がユーザモードに復帰

### 非同期処理の流れ

1. **割り込み処理**: ハードウェア割り込み発生 --> MD層割り込みハンドラ --> ithread（割り込みスレッド）でデバイスドライバのハンドラ実行
2. **タスクキュー**: カーネル内の遅延処理はtaskqueue（sys/kern/subr_taskqueue.c）で非同期実行
3. **カーネルスレッド**: kthread（sys/kern/kern_kthread.c）による常駐バックグラウンドタスク（ページデーモン、bufdaemon等）
4. **callout**: タイマーベースの遅延実行メカニズム（sys/kern/kern_timeout.c）
5. **ソフト割り込み（swi）**: ネットワークパケット処理等の遅延割り込み処理

### データ永続化の流れ

1. ユーザランドが write() システムコールを発行
2. VFS 層がファイルディスクリプタからvnodeを解決
3. 個別ファイルシステム（例: FFS）がデータを内部構造にマッピング
4. バッファキャッシュ（sys/kern/vfs_bio.c）にデータを書き込み
5. バッファキャッシュが非同期または同期でGEOM層にI/Oリクエストを発行
6. GEOM 変換レイヤー（暗号化、RAID等）を経由
7. CAM サブシステムがデバイスドライバを通じて物理デバイスにデータを書き込み

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| UNIX パーミッション | sys/kern/vfs_vnops.c, kern_descrip.c | ファイル・ディレクトリアクセス制御 |
| MAC フレームワーク | sys/security/mac/ | 強制アクセス制御（Biba, MLS, LOMAC等のポリシーモジュール） |
| Capsicum (Capability Mode) | sys/kern/sys_capability.c | プロセスのケイパビリティベースサンドボックス |
| jail | sys/kern/kern_jail.c | OS レベル仮想化・リソース分離 |
| Kerberos5 | kerberos5/ | ネットワーク認証 |
| PAM | lib/libpam/ | Pluggable Authentication Modules |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| カーネルログ | printf/log()（sys/kern/subr_prf.c） | /var/log/messages（syslogd経由） |
| 監査ログ | BSM 監査フレームワーク（sys/security/audit/） | /var/audit/ |
| DTrace トレース | DTrace プローブ（sys/cddl/） | ユーザランドツールで収集 |
| コンソールログ | sys/kern/kern_cons.c | コンソールデバイス |

### エラーハンドリング

カーネル内のエラーハンドリング方針とメカニズムを示す。

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| システムコールエラー | errno を設定し -1 を返却 | ユーザランドに errno で通知 |
| カーネルパニック | panic() 呼び出し | システム停止・クラッシュダンプ生成 |
| ページフォルト | トラップハンドラ --> vm_fault() | ページイン or SIGSEGV シグナル |
| デバイスエラー | デバイスドライバがエラーコード返却 | 上位レイヤーにエラー伝播 |
| ファイルシステムエラー | VFS 層でエラー返却 | errno としてユーザランドに通知 |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| UFS/FFS ジャーナリング | Soft Updates（sys/ufs/ffs/ffs_softdep.c） | ファイルシステムメタデータ整合性保証 |
| UFS/FFS スナップショット | ffs_snapshot.c | ポイントインタイムの一貫性ビュー |
| ZFS トランザクション | ZFS のコピーオンライトトランザクションモデル | 常に一貫性のあるオンディスク状態 |
| カーネルロック | mutex, rwlock, sx lock, rmlock（sys/kern/kern_mutex.c 等） | データ構造の一貫性保証 |

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| MI/MD 分離 | カーネル全体 | sys/kern/（MI）と sys/amd64/ 等（MD）の分離 |
| VFS 抽象化 | ファイルシステム | 全ファイルシステムが共通 VFS インターフェースを実装 |
| Newbus デバイスモデル | デバイスドライバ | device_if.m, bus_if.m によるインターフェース定義 |
| カーネルモジュール化 | 機能拡張 | sys/modules/ 配下のKLDモジュール |
| GEOM 変換スタック | ストレージ | パイプライン型のストレージ変換 |
| MAC フレームワーク | セキュリティ | プラガブルなセキュリティポリシーモジュール |

### コーディング規約

- FreeBSD プロジェクトは style(9) マニュアルページで定義されたカーネルコーディングスタイルに従う。
- カーネルコードはC言語（C11ベース）で記述される。
- インデントはタブ（8スペース幅）を使用。
- 関数定義はBSDスタイル（戻り値型を別行に記述）。
- ヘッダガードには `_SYS_*_H_` 形式のマクロを使用。
- マシン依存インターフェースは `.m` ファイル（インターフェース定義言語）で定義される。
- ビルドシステムは BSD make（bmake）を使用し、Makefile は `bsd.*.mk` インクルードファイルに基づく。

## 備考

- FreeBSD は複数の CPU アーキテクチャ（amd64, arm64, arm, i386, powerpc, riscv）をサポートしている。
- ライセンスは主に BSD ライセンスであるが、一部のコンポーネントは CDDL（ZFS, DTrace）、GPL/LGPL（gnu/）で提供されている。
- サードパーティ寄贈コード（contrib/）は各プロジェクトのアップストリームから取り込まれ、FreeBSD 固有の修正が最小限に抑えられている。
- テストフレームワークとして Kyua（tests/）を採用している。
- ブートプロセスは stand/ 配下のブートローダ（loader）がカーネルをロードし、sys/kern/init_main.c で初期化処理が行われる。
