---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 25
  claims_without_evidence: 5
confidence_derived: 0.83
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：25 / 30、根拠なし：5
- 優先レビュー（高）
  1. **ビルドサーバーのスペック・台数**：根拠不足（構成ファイルに具体的なサーバースペック・台数の明記なし）
  2. **Gitリポジトリサーバーの構成詳細**：根拠不足（URLのみ確認、詳細構成は不明）
  3. **CIサーバーの台数・スペック**：根拠不足（ci.confにテスト設定のみ、サーバー構成は不明）
  4. **バックアップの保持期間・頻度の詳細**：根拠不足
  5. **監視設計の具体的なアラート閾値**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、ソースツリー構成
- E-02: `release/Makefile.vm` - VM/クラウドイメージ生成設定、クラウドプロバイダー一覧、ディスクフォーマット
- E-03: `release/tools/ec2.conf` - EC2イメージ設定（ディスクサイズ、ネットワーク、NTP、EFS等）
- E-04: `release/tools/azure.conf` - Azure イメージ設定（ディスクサイズ、waagent、ネットワーク）
- E-05: `release/tools/gce.conf` - GCEイメージ設定（ディスクサイズ、Google Cloud SDK、ネットワーク）
- E-06: `release/tools/openstack.conf` - OpenStackイメージ設定（cloud-init、ネットワーク）
- E-07: `release/tools/oracle.conf` - Oracle Cloudイメージ設定（cloud-init、OCI CLI）
- E-08: `release/tools/vagrant.conf` - Vagrantイメージ設定（ディスクサイズ、SSH）
- E-09: `release/Makefile.firecracker` - Firecrackerイメージ設定（カーネル、rootfs、ネットワーク）
- E-10: `release/Makefile.oci` - OCIコンテナイメージ生成設定（階層構造）
- E-11: `release/tools/oci-image-runtime.conf` - OCIランタイムイメージパッケージ一覧
- E-12: `release/release.sh` - リリースビルドスクリプト（CHROOTDIR、GITROOT、VCS設定）
- E-13: `sys/amd64/conf/GENERIC` - GENERICカーネル構成（SMP、NUMA、ネットワーク、FS等）
- E-14: `sys/amd64/conf/FIRECRACKER` - FIRECRACKERカーネル構成（VirtIO MMIO、mptable）
- E-15: `sys/amd64/conf/` ディレクトリ一覧 - カーネル構成バリエーション
- E-16: `tests/ci/tools/ci.conf` - CI環境設定（テストパッケージ、カーネルモジュール、sysctl）
- E-17: `libexec/rc/rc.conf` - デフォルトrc.conf設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FreeBSDはサーバー、デスクトップ、組み込みプラットフォームで使用されるOS | E-01 | ○ |
| C-02 | Gitベースのソース管理 (git.FreeBSD.org) | E-12 | ○ |
| C-03 | BSD makeベースのビルドシステム | E-01 | ○ |
| C-04 | ビルドサーバーでCHROOTDIR="/scratch"を使用 | E-12 | ○ |
| C-05 | ビルドサーバーのスペック・台数 | **根拠なし** | △ |
| C-06 | Gitリポジトリサーバーの詳細構成 | **根拠なし** | △ |
| C-07 | 対応アーキテクチャ: amd64, arm, arm64, i386, powerpc, riscv | E-02, E-15 | ○ |
| C-08 | EC2イメージ: raw形式、8GBパーティション、ENA ドライバ | E-02, E-03 | ○ |
| C-09 | Azure イメージ: VHD形式、30GB、waagent、mlx4en/mlx5en | E-02, E-04 | ○ |
| C-10 | GCEイメージ: raw形式、20GB、MTU 1460 | E-02, E-05 | ○ |
| C-11 | OpenStackイメージ: qcow2形式、cloud-init | E-02, E-06 | ○ |
| C-12 | Oracle Cloudイメージ: raw形式、8GB、cloud-init | E-02, E-07 | ○ |
| C-13 | Vagrantイメージ: vmdk形式、8GB | E-02, E-08 | ○ |
| C-14 | Firecrackerイメージ: カーネルバイナリ+rootfs、静的IP 10.0.0.2/16 | E-09, E-14 | ○ |
| C-15 | OCIコンテナイメージの5層階層構造 | E-10, E-11 | ○ |
| C-16 | GENERICカーネルのSMP, NUMA, VIMAGE, INET/INET6サポート | E-13 | ○ |
| C-17 | FIRECRACKERカーネルのVirtIO MMIO, mptable対応 | E-14 | ○ |
| C-18 | カーネル構成バリエーション (GENERIC, FIRECRACKER, MINIMAL等) | E-15 | ○ |
| C-19 | EC2でのNTP: 169.254.169.123 | E-03 | ○ |
| C-20 | EC2でのEFS: NFSv4.1 autofs経由 | E-03 | ○ |
| C-21 | GCEでのmetadata.google.internal (169.254.169.254) | E-05 | ○ |
| C-22 | CI環境でKyuaテストフレームワーク使用 | E-16 | ○ |
| C-23 | CI環境でZFS arc_max=4GB | E-16 | ○ |
| C-24 | CI環境で3 FIB構成 | E-16 | ○ |
| C-25 | growfsによるブート時ディスク自動拡張 | E-03, E-05, E-08 | ○ |
| C-26 | カーネルダンプ: EKCD, GZIO/ZSTDIO, NETDUMP | E-13, E-14 | ○ |
| C-27 | DTrace: CTF対応ビルド (WITH_CTF=1) | E-13 | ○ |
| C-28 | CIサーバーの台数・スペック | **根拠なし** | △ |
| C-29 | バックアップの保持期間・頻度の詳細 | **根拠なし** | △ |
| C-30 | 監視設計の具体的なアラート閾値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルドサーバー/CIサーバーの具体的なハードウェアスペック・台数は、ソースコードリポジトリ内の構成ファイルには記載されていない。これらはFreeBSDプロジェクトの運用インフラドキュメント（外部）に依存する。
  - 候補：FreeBSD Foundationのインフラドキュメント / FreeBSD Cluster管理者向けドキュメント / FreeBSD Wikiのインフラページ
- Gitリポジトリサーバーの詳細構成（冗長化、ストレージ容量等）は外部運用情報に依存する。
  - 候補：git.FreeBSD.org のインフラ構成ドキュメント / FreeBSD Cluster管理チームの資料
- バックアップポリシーの詳細（保持期間、頻度）はリリースエンジニアリングポリシーに依存する。
  - 候補：FreeBSD Release Engineering ドキュメント / FreeBSD Handbook
- 監視設計の具体的なアラート閾値・通知先はソースコード外の運用設定に依存する。
  - 候補：FreeBSD Cluster 監視設定 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラウドイメージ設定の記述（各.confファイルから直接抽出、高信頼）
- 0: 低リスク - カーネル構成の記述（GENERICおよびFIRECRACKERカーネル設定ファイルから直接抽出）
- 0: 低リスク - OCIコンテナイメージ階層構造（Makefile.ociから直接抽出）
- 1: 中リスク - サーバー構成の台数・スペック（ソースコードから推測不可、外部運用情報必要）
- 1: 中リスク - バックアップ・監視の詳細（ソースコード外の運用設定に依存）
- 2: 高リスク - なし

## 6) レビュアーチェックリスト（最小）
- [ ] クラウドプロバイダー設定（EC2, Azure, GCE, Oracle, OpenStack）が各.confファイルと一致しているか
- [ ] カーネル構成オプション（SMP, NUMA, VIMAGE等）がGENERIC/FIRECRACKERカーネル設定と一致しているか
- [ ] OCIコンテナイメージの階層構造がMakefile.ociの依存関係と一致しているか
- [ ] ネットワーク設定（DHCP, 静的IP, NTP等）が各環境の.confファイルと一致しているか
- [ ] ビルドサーバー/CIサーバーのスペック・台数について、外部情報源で補完が必要な箇所を確認
- [ ] 対応アーキテクチャの一覧がsys/conf/配下のアーキテクチャ固有ファイルと一致しているか
