# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "ソースコード管理"
        GIT["Git Repository<br/>git.FreeBSD.org"]
    end

    subgraph "ビルドシステム"
        BUILD["ビルドサーバー<br/>(CHROOTDIR=/scratch)"]
        RELEASE["release.sh<br/>リリースビルド"]
        MAKEFILE["Makefile.vm / Makefile.oci<br/>イメージ生成"]
    end

    subgraph "カーネル構成"
        GENERIC["GENERIC<br/>汎用カーネル"]
        FIRECRACKER_KERN["FIRECRACKER<br/>マイクロVM専用"]
        MINIMAL["MINIMAL<br/>最小構成"]
    end

    subgraph "VM/クラウドイメージ生成"
        direction TB
        EC2_IMG["EC2 イメージ<br/>(raw, 8GB)"]
        AZURE_IMG["Azure イメージ<br/>(vhd, 30GB)"]
        GCE_IMG["GCE イメージ<br/>(raw, 20GB)"]
        ORACLE_IMG["Oracle Cloud イメージ<br/>(raw, 8GB)"]
        OPENSTACK_IMG["OpenStack イメージ<br/>(qcow2)"]
        VAGRANT_IMG["Vagrant イメージ<br/>(vmdk, 8GB)"]
        FC_IMG["Firecracker イメージ<br/>(kernel + rootfs)"]
    end

    subgraph "OCI コンテナイメージ"
        OCI_STATIC["static"]
        OCI_DYNAMIC["dynamic"]
        OCI_RUNTIME["runtime"]
        OCI_NOTOOL["notoolchain"]
        OCI_TOOL["toolchain"]
    end

    subgraph "CI/CD"
        CI["CI サーバー<br/>(Kyua テスト)"]
    end

    GIT --> BUILD
    BUILD --> RELEASE
    RELEASE --> MAKEFILE
    BUILD --> GENERIC
    BUILD --> FIRECRACKER_KERN
    BUILD --> MINIMAL

    MAKEFILE --> EC2_IMG
    MAKEFILE --> AZURE_IMG
    MAKEFILE --> GCE_IMG
    MAKEFILE --> ORACLE_IMG
    MAKEFILE --> OPENSTACK_IMG
    MAKEFILE --> VAGRANT_IMG
    MAKEFILE --> FC_IMG

    MAKEFILE --> OCI_STATIC
    OCI_STATIC --> OCI_DYNAMIC
    OCI_DYNAMIC --> OCI_RUNTIME
    OCI_RUNTIME --> OCI_NOTOOL
    OCI_NOTOOL --> OCI_TOOL

    GIT --> CI
```

## クラウドイメージ生成フロー

```mermaid
flowchart LR
    subgraph "入力"
        SRC["ソースコード"]
        CONF["*.conf<br/>クラウド設定"]
    end

    subgraph "ビルドプロセス"
        MK_VM["mk-vmimage.sh"]
        VMIMAGE_SUBR["vmimage.subr"]
    end

    subgraph "出力フォーマット"
        VHD["VHD<br/>(Azure, Hyper-V)"]
        VMDK["VMDK<br/>(VMware, VirtualBox)"]
        QCOW2["QCOW2<br/>(QEMU, KVM)"]
        RAW["RAW<br/>(EC2, GCE, Oracle)"]
    end

    subgraph "ファイルシステム"
        UFS["UFS"]
        ZFS["ZFS"]
    end

    SRC --> MK_VM
    CONF --> MK_VM
    MK_VM --> VMIMAGE_SUBR
    VMIMAGE_SUBR --> VHD
    VMIMAGE_SUBR --> VMDK
    VMIMAGE_SUBR --> QCOW2
    VMIMAGE_SUBR --> RAW
    UFS --> VMIMAGE_SUBR
    ZFS --> VMIMAGE_SUBR
```

## カーネルアーキテクチャ構成

```mermaid
graph TB
    subgraph "対応アーキテクチャ"
        AMD64["amd64<br/>(x86_64)"]
        ARM64["arm64<br/>(aarch64)"]
        ARM["arm<br/>(armv7)"]
        I386["i386<br/>(x86)"]
        PPC["powerpc<br/>(ppc/ppc64/ppc64le)"]
        RISCV["riscv<br/>(riscv64)"]
    end

    subgraph "カーネル構成 (amd64例)"
        G["GENERIC"]
        F["FIRECRACKER"]
        M["MINIMAL"]
        GND["GENERIC-NODEBUG"]
        KASAN["GENERIC-KASAN"]
        KCSAN["GENERIC-KCSAN"]
        KMSAN["GENERIC-KMSAN"]
    end

    subgraph "主要カーネルオプション"
        SMP["SMP"]
        NUMA["NUMA"]
        VIMAGE["VIMAGE (VNET)"]
        INET["INET / INET6"]
        FFS_OPT["FFS / ZFS"]
        DTRACE["DTrace (CTF)"]
    end

    AMD64 --> G
    AMD64 --> F
    AMD64 --> M
    AMD64 --> GND
    AMD64 --> KASAN
    AMD64 --> KCSAN
    AMD64 --> KMSAN

    G --> SMP
    G --> NUMA
    G --> VIMAGE
    G --> INET
    G --> FFS_OPT
    G --> DTRACE
```

## クラウド環境ネットワーク構成

```mermaid
graph TB
    subgraph "EC2"
        EC2_DHCP["DHCP + IPv6<br/>(accept_rtadv)"]
        EC2_ENA["ENA ドライバ"]
        EC2_NTP["NTP: 169.254.169.123"]
        EC2_EFS["EFS: NFSv4.1<br/>(autofs)"]
    end

    subgraph "Azure"
        AZ_DHCP["DHCP<br/>(ifconfig_hn0)"]
        AZ_MLX["mlx4en / mlx5en"]
        AZ_WAAGENT["waagent"]
    end

    subgraph "GCE"
        GCE_DHCP["DHCP<br/>(MTU 1460)"]
        GCE_META["metadata.google.internal<br/>(169.254.169.254)"]
        GCE_AGENTS["Google Cloud<br/>Agents"]
    end

    subgraph "Firecracker"
        FC_STATIC["静的IP<br/>10.0.0.2/16"]
        FC_VIRTIO["VirtIO MMIO<br/>(vtnet)"]
        FC_GW["GW: 10.0.0.1"]
    end
```

## OCI コンテナイメージ階層構造

```mermaid
graph TB
    STATIC["static<br/>(最小静的バイナリ)"]
    DYNAMIC["dynamic<br/>(動的リンクライブラリ追加)"]
    RUNTIME["runtime<br/>(FreeBSD-runtime, FreeBSD-rc,<br/>FreeBSD-pkg-bootstrap 等)"]
    NOTOOLCHAIN["notoolchain<br/>(ツールチェーン以外追加)"]
    TOOLCHAIN["toolchain<br/>(ツールチェーン追加)"]

    STATIC --> DYNAMIC
    DYNAMIC --> RUNTIME
    RUNTIME --> NOTOOLCHAIN
    NOTOOLCHAIN --> TOOLCHAIN
```
