# インフラ設計書

## 概要

本ドキュメントは、FreeBSD オペレーティングシステムソースコード (freebsd-src-main) プロジェクトのインフラ構成について記載する。FreeBSD はサーバー、デスクトップ、組み込みプラットフォームで使用されるオープンソースOSであり、本プロジェクトはそのソースコードリポジトリである。インフラ設計としては、ビルドシステム構成、リリースエンジニアリング基盤、クラウドプロバイダー向けイメージ生成基盤、OCIコンテナイメージ生成基盤、CI/CD基盤、およびカーネル構成について記載する。

## システム構成

### 全体構成

FreeBSD プロジェクトのインフラは以下の主要コンポーネントで構成される。

1. **ソースコードリポジトリ**: Git ベースのソース管理 (`https://git.FreeBSD.org/`)
2. **ビルドシステム**: BSD make ベースの階層的ビルドシステム (Makefile, Makefile.inc1)
3. **リリースエンジニアリング**: release.sh および関連 Makefile によるリリースビルド基盤
4. **クラウドイメージ生成**: 各クラウドプロバイダー向けのVM/ディスクイメージ生成基盤
5. **OCIコンテナイメージ生成**: OCI準拠のコンテナイメージ生成基盤
6. **CI/CD基盤**: Kyua テストフレームワークを用いたCI環境
7. **カーネルビルド**: 複数アーキテクチャ対応のカーネル構成管理

### サーバー構成

本プロジェクトはOS自体のソースコードであるため、従来のWeb/AP/DB型のサーバー構成ではなく、ビルド/リリース基盤としてのサーバー構成となる。

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| ビルドサーバー | ソースコードのコンパイル、カーネル/ワールドビルド | release.sh で CHROOTDIR="/scratch" を使用 | 構成ファイルに明示なし |
| Gitリポジトリサーバー | ソースコード管理 (git.FreeBSD.org) | release.sh で GITROOT="https://git.FreeBSD.org/" を参照 | 構成ファイルに明示なし |
| CIサーバー | 自動テスト実行 (Kyua) | ci.conf で定義、ZFS arc_max=4GB | 構成ファイルに明示なし |

### 対応アーキテクチャ

| アーキテクチャ | カーネル構成 | 備考 |
| --- | --- | --- |
| amd64 | GENERIC, FIRECRACKER, MINIMAL 等 | 主要ターゲット |
| arm | armv7 | ARM 32bit |
| arm64 | aarch64 | ARM 64bit (Graviton等) |
| i386 | i386 | x86 32bit |
| powerpc | powerpc, powerpc64, powerpc64le | PowerPC系 |
| riscv | riscv64 | RISC-V 64bit |

### ネットワーク構成

FreeBSD カーネルは以下のネットワーク機能を標準でサポートしている (GENERIC カーネル構成より):

- **IPv4/IPv6**: INET, INET6 オプション有効
- **IPsec**: IPSEC_SUPPORT, IPSEC_OFFLOAD によるVPN/暗号化通信
- **マルチパスルーティング**: ROUTE_MPATH
- **TCP最適化**: TCP_OFFLOAD, TCP_BLACKBOX, TCP_RFC7413 (Fast Open), KERN_TLS
- **SCTP**: SCTP_SUPPORT
- **VNET**: VIMAGE によるネットワーク仮想化
- **ファイアウォール**: ipfw, pf, ipfilter をカーネルモジュールとして提供

クラウド環境向けのネットワーク構成:

| 環境 | ネットワーク設定 | 備考 |
| --- | --- | --- |
| EC2 | DHCP (SYNCDHCP accept_rtadv), IPv6, DHCPv6 | ENA ドライバ使用 |
| Azure | DHCP (ifconfig_hn0="SYNCDHCP") | Mellanox mlx4en/mlx5en ドライバ |
| GCE | DHCP (SYNCDHCP mtu 1460) | metadata.google.internal 参照 |
| OpenStack | DHCP (SYNCDHCP), cloud-init | cloud-init によるネットワーク構成 |
| Oracle Cloud | DHCP, cloud-init | cloud-init によるネットワーク構成 |
| Firecracker | 静的IP (10.0.0.2/16), GW 10.0.0.1 | virtio_mmio + vtnet |

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| OpenSSL | ソースツリー内 (crypto/openssl) | TLS/暗号化基盤 |
| OpenSSH | ソースツリー内 (crypto/openssh) | SSH リモートアクセス |
| Kerberos 5 (Heimdal/MIT krb5) | ソースツリー内 (kerberos5/, crypto/krb5) | 認証基盤 |
| Unbound | ソースツリー内 (contrib/unbound) | DNS リゾルバ |
| NTP | OS標準 ntpd | 時刻同期 |
| ZFS | カーネルモジュール | ファイルシステム (Oracle/一部イメージで使用) |
| UFS | カーネル組み込み | 標準ファイルシステム |
| DTrace | CTF対応ビルド (WITH_CTF=1) | 動的トレーシング |
| pkg | パッケージマネージャ | サードパーティパッケージ管理 |
| cloud-init | サードパーティ | クラウドインスタンス初期化 (OpenStack, Oracle) |
| Azure Agent (waagent) | サードパーティ | Azure VM管理 |
| Google Cloud SDK | サードパーティ | GCE インスタンス管理 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Amazon EC2 | クラウドVM イメージ配布 | AMI (raw形式ディスクイメージ) |
| Microsoft Azure | クラウドVM イメージ配布 | VHD形式ディスクイメージ |
| Google Compute Engine | クラウドVM イメージ配布 | raw形式ディスクイメージ |
| Oracle Cloud Infrastructure | クラウドVM イメージ配布 | raw形式ディスクイメージ |
| OpenStack | クラウドVM イメージ配布 | qcow2形式ディスクイメージ |
| Vagrant (VirtualBox/VMware) | ローカル仮想化イメージ配布 | vmdk形式ディスクイメージ |
| Firecracker | マイクロVM イメージ | カーネルバイナリ + rootfsイメージ |
| OCI Registry | コンテナイメージ配布 | OCI準拠コンテナイメージ (static/dynamic/runtime/notoolchain/toolchain) |
| FreeBSD Update (aws.update.FreeBSD.org) | EC2向けOSアップデート | HTTPS |
| Amazon NTP (169.254.169.123) | EC2時刻同期 | NTP |
| Google Metadata (169.254.169.254) | GCEメタデータ/NTP | HTTP/NTP |
| Oracle NTP (169.254.169.254) | Oracle Cloud 時刻同期 | NTP |
| Amazon EFS | EC2向け共有ファイルシステム | NFSv4.1 (autofs経由) |
| Git (git.FreeBSD.org) | ソースコード管理 | HTTPS |

## スケーリング設計

本プロジェクトはOS自体のソースコードであるため、アプリケーションレベルのスケーリングではなく、以下のスケーリングに関する設計が含まれる。

### カーネルレベルのスケーリング

- **SMP対応**: GENERICカーネルおよびFIRECRACKERカーネルの両方でSMPオプションが有効
- **NUMAサポート**: NUMAオプションによる非均一メモリアクセスの最適化
- **プリエンプション**: PREEMPTION オプションによるカーネルスレッドのプリエンプティブスケジューリング
- **スケジューラ**: ULEスケジューラ (SCHED_ULE) を標準使用、4BSDスケジューラもGENERICでは利用可能

### クラウドイメージのスケーリング

- **ディスク自動拡張**: growfs rc.d スクリプトによるブート時のパーティション自動拡張 (EC2: 8GB初期、GCE: 20GB初期、Azure: 30GB初期)
- **スワップなし**: EC2, Azure, OpenStack, Oracle ではスワップを無効化し、インスタンスサイズに応じたメモリ管理をクラウドプロバイダーに委任

### ビルドシステムのスケーリング

- **クロスコンパイル**: QEMU ユーザーモードエミュレーションによるクロスアーキテクチャビルド対応
- **複数フォーマット同時生成**: VHD, VMDK, QCOW2, RAW の4形式 x UFS/ZFS の複数ファイルシステム対応

## 可用性設計

### カーネルレベルの可用性機能

- **カーネルダンプ**: EKCD (暗号化カーネルダンプ), GZIO/ZSTDIO (圧縮ダンプ), NETDUMP (ネットワーク経由ダンプ) をサポート
- **デッドロック検出**: DEADLKRES (デッドロックリゾルバ), WITNESS (ロック順序検証)
- **デバッグ**: KDB, DDB, GDB によるカーネルデバッガサポート
- **パニック制御**: クラウド環境では panic_reboot_wait_time=0 による即時再起動

### クラウド環境の可用性

- **自動アップデート**: firstboot-freebsd-update による初回起動時のセキュリティアップデート適用
- **パニック通知**: GCE環境では panicmail による自動パニック通知
- **監査**: AUDIT オプションによるセキュリティイベント監査
- **Capsicum**: CAPABILITY_MODE, CAPABILITIES によるサンドボックス機構

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git リポジトリ (git.FreeBSD.org) | リアルタイム (コミット単位) | 全履歴保持 |
| リリースイメージ | SHA256/SHA512 チェックサム付きアーカイブ | リリース毎 | リリースポリシーに準拠 |
| カーネルダンプ | NETDUMP/ローカルダンプデバイス | パニック発生時 | 構成ファイルに明示なし |
| GCE ソースコード | src.txz, ports.txz をVM内に展開 | イメージビルド時 | イメージライフサイクルに準拠 |

## 監視設計

### カーネルレベルの監視

- **DTrace**: CTF対応ビルドによる動的トレーシング基盤
- **HWPMC**: ハードウェアパフォーマンスモニタリングカウンターのフック (HWPMC_HOOKS)
- **syslog**: 標準のsyslogによるシステムログ収集 (GCEでは *.err;kern.warning;auth.notice;mail.crit をコンソール出力)
- **監査 (audit)**: CIイメージでは auditd が有効化 (VM_RC_LIST に auditd を含む)

### クラウド環境の監視

- **EC2**: システムログ (シリアルポートエミュレーション) + VGAコンソール (インスタンススクリーンショット)
- **GCE**: google_startup, google_accounts_daemon, google_clock_skew_daemon, google_instance_setup, google_network_daemon による監視エージェント群
- **Azure**: waagent (Azure Linux Agent) によるVM管理・監視
- **Oracle Cloud**: cloud-init + OCI CLI によるインスタンス管理

## 備考

### VM ディスクイメージ形式

| 形式 | 用途 |
| --- | --- |
| VHD (vhdf) | Azure, VirtualPC, Hyper-V, Xen |
| VMDK | VMware, VirtualBox, Vagrant |
| QCOW2 | QEMU, KVM, OpenStack |
| RAW | EC2, GCE, Oracle Cloud, 汎用 |

### OCI コンテナイメージ階層

OCI コンテナイメージは以下の階層構造で生成される (Makefile.oci より):

1. **static**: 最小限の静的リンクバイナリ
2. **dynamic**: static をベースに動的リンクライブラリを追加
3. **runtime**: dynamic をベースにランタイムパッケージ (FreeBSD-runtime, FreeBSD-rc 等) を追加
4. **notoolchain**: runtime をベースにツールチェーン以外のパッケージを追加
5. **toolchain**: notoolchain をベースにツールチェーンを追加

### カーネル構成バリエーション (amd64)

| 構成名 | 用途 |
| --- | --- |
| GENERIC | 汎用カーネル (全ハードウェアドライバ含む) |
| FIRECRACKER | Firecracker マイクロVM専用 (VirtIO MMIO, mptable) |
| MINIMAL | 最小構成カーネル |
| GENERIC-NODEBUG | デバッグ無効の汎用カーネル |
| GENERIC-KASAN | Kernel Address Sanitizer 有効 |
| GENERIC-KCSAN | Kernel Concurrency Sanitizer 有効 |
| GENERIC-KMSAN | Kernel Memory Sanitizer 有効 |

### CI環境の構成 (ci.conf)

CI環境は以下のツール・パッケージを含む:

- テストフレームワーク: Kyua
- ネットワークテスト: scapy, nmap, tcptestsuite, ndisc6
- 開発ツール: git, gdb, py-pytest
- カーネルモジュール: pf, ipfw, carp, fusefs, ipsec 等のテスト用モジュール群
- ファイルシステム: ZFS (arc_max=4GB), UFS
- ネットワーク: 3 FIB (Forwarding Information Base) 構成
