---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **ASLR/SSP/W^X 対策の記述**：カーネルコンフィグやリンカスクリプトの直接確認が未実施
  2. **セッション管理の詳細設定値**：PAM 構成ファイルの個別内容は未解析
  3. **ハードウェア暗号化オフロードの対応範囲**：アーキテクチャ別の詳細実装は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/libpam/modules/` -- PAM モジュール一覧（ディレクトリリスト）
- E-02: `lib/libcrypt/crypt.c` -- crypt(3) ハッシュアルゴリズム実装
- E-03: `sys/security/audit/audit.c` -- BSM 監査サブシステム実装
- E-04: `sys/security/audit/audit.h` -- 監査サブシステムヘッダー
- E-05: `sys/security/mac/mac_framework.c` -- TrustedBSD MAC フレームワーク
- E-06: `sys/security/mac_biba/mac_biba.c` -- Biba 完全性ポリシー
- E-07: `sys/kern/kern_priv.c` -- 特権チェック機構（priv(9)）
- E-08: `sys/kern/kern_prot.c` -- プロセス保護システムコール
- E-09: `sys/kern/sys_capability.c` -- Capsicum ケーパビリティ実装
- E-10: `sys/opencrypto/` -- OpenCrypto フレームワーク（xform_*.c ファイル群）
- E-11: `sys/netipsec/` -- IPsec 実装ディレクトリ
- E-12: `sys/netpfil/pf/` -- PF パケットフィルタ実装
- E-13: `sys/netpfil/ipfw/` -- IPFW ファイアウォール実装
- E-14: `crypto/openssh/` -- OpenSSH 実装
- E-15: `crypto/openssl/` -- OpenSSL 実装
- E-16: `contrib/openbsm/etc/audit_control` -- 監査デフォルト設定
- E-17: `contrib/openbsm/etc/audit_class` -- 監査イベントクラス定義
- E-18: `sys/security/mac_veriexec/` -- 実行検証ポリシーモジュール
- E-19: `sys/kern/kern_jail.c` -- Jail 実装
- E-20: `secure/lib/` -- セキュアライブラリ群（libcrypto, libssl, libssh, libpkgecc）
- E-21: `crypto/heimdal/` -- Heimdal Kerberos 実装
- E-22: `lib/libcasper/` -- Casper ライブラリ（Capsicum サービス）
- E-23: `lib/libcapsicum/` -- Capsicum ヘルパーライブラリ
- E-24: `sys/opencrypto/ktls_ocf.c` -- カーネル TLS 実装
- E-25: `sys/security/mac_mls/` -- MLS ポリシーモジュール
- E-26: `sys/security/mac_lomac/` -- LOMAC ポリシーモジュール
- E-27: `secure/caroot/` -- CA ルート証明書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PAM フレームワークによる認証基盤 | E-01 | ○ |
| C-02 | pam_unix, pam_krb5, pam_ssh 等 14 種類の PAM モジュール | E-01 | ○ |
| C-03 | crypt(3) で MD5, Blowfish, NTHash, SHA-256, SHA-512, DES をサポート | E-02 | ○ |
| C-04 | Kerberos V5 認証（Heimdal 実装） | E-21 | ○ |
| C-05 | suser_enabled による uid=0 特権の制御 | E-07 | ○ |
| C-06 | priv_check_cred() による集中的な特権チェック | E-07 | ○ |
| C-07 | MAC ポリシーによる特権チェック（mac_priv_check/mac_priv_grant） | E-07 | ○ |
| C-08 | prison_priv_check() による Jail 内特権制限 | E-07, E-19 | ○ |
| C-09 | TrustedBSD MAC Framework の 3 つのインターフェース | E-05 | ○ |
| C-10 | mac_biba による Biba 完全性ポリシー | E-06 | ○ |
| C-11 | mac_mls による多段階セキュリティ | E-25 | ○ |
| C-12 | mac_lomac による動的完全性ポリシー | E-26 | ○ |
| C-13 | mac_veriexec によるハッシュベースの実行検証 | E-18 | ○ |
| C-14 | Capsicum ケーパビリティモードによるサンドボックス | E-09 | ○ |
| C-15 | Capsicum はグローバル名前空間アクセスを制限 | E-09 | ○ |
| C-16 | Jail によるプロセス隔離 | E-19 | ○ |
| C-17 | OpenCrypto フレームワークで AES-CBC/ICM/XTS/GCM 等をサポート | E-10 | ○ |
| C-18 | ChaCha20-Poly1305 サポート | E-10 | ○ |
| C-19 | SHA-1, SHA-2, RIPEMD-160 ハッシュサポート | E-10 | ○ |
| C-20 | IPsec（AH/ESP）サポート | E-11 | ○ |
| C-21 | OpenSSH 統合 | E-14 | ○ |
| C-22 | kTLS カーネル TLS オフロード | E-24 | ○ |
| C-23 | PF パケットフィルタ | E-12 | ○ |
| C-24 | IPFW ファイアウォール | E-13 | ○ |
| C-25 | BSM/OpenBSM 監査サブシステム | E-03, E-04, E-16, E-17 | ○ |
| C-26 | 監査イベントクラス 18 種類 | E-17 | ○ |
| C-27 | デフォルト監査設定（lo,aa フラグ、2M ファイルサイズ等） | E-16 | ○ |
| C-28 | ASLR/SSP/W^X によるバッファオーバーフロー対策 | **根拠なし** | △ |
| C-29 | セッション管理の具体的な設定値 | **根拠なし** | △ |
| C-30 | ハードウェア暗号化オフロードの対応（AES-NI, aarch64） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: ASLR/SSP/W^X については FreeBSD の一般的な知識に基づく記述であり、本ソースツリー内のカーネルコンフィグや Makefile での具体的な有効化設定は直接確認していない
  - 候補: `sys/conf/GENERIC` / `Makefile.inc1` / `sys/kern/kern_exec.c`
- C-29: PAM セッション管理の具体的な設定値は PAM 構成ファイル（`pam.d/` 配下）の個別内容に依存するが、各ファイルの内容は解析していない
  - 候補: `lib/libpam/pam.d/sshd` / `lib/libpam/pam.d/login` / `lib/libpam/pam.d/system`
- C-30: ハードウェア暗号化オフロードについて、`crypto.c` 内の `#if defined(__i386__) || defined(__amd64__) || defined(__aarch64__)` 条件分岐を確認したが、具体的なオフロード機能の詳細は未調査
  - 候補: `sys/crypto/aesni/` / `sys/crypto/armv8/` / `sys/opencrypto/cryptodev.c`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 認証（PAM）、監査（BSM）、暗号化（OpenCrypto）の記述はソースコードの直接確認に基づいており信頼性が高い
- 1: 中リスク -- セッション管理の詳細はサービス固有の PAM 構成に依存するため、運用環境に応じた確認が必要
- 1: 中リスク -- MAC ポリシーモジュールの一覧は完全だが、各モジュールの詳細な動作仕様までは解析していない
- 1: 中リスク -- ASLR/SSP/W^X は FreeBSD の標準機能だが、本ソースツリーでの具体的な有効化状態は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] PAM モジュール一覧が実際のデプロイ環境で有効化されているモジュールと一致するか確認
- [ ] crypt(3) のデフォルトハッシュアルゴリズムが運用ポリシーに適合するか確認（DES がデフォルトになっている可能性）
- [ ] MAC ポリシーモジュールの有効化状態がカーネルコンフィグと一致するか確認
- [ ] 監査設定（audit_control）が運用要件（保持期間、監査対象クラス）を満たしているか確認
- [ ] Capsicum/Jail の適用範囲が想定するサンドボックス要件を満たしているか確認
- [ ] ASLR/SSP/W^X の有効化状態をカーネルコンフィグおよびビルドオプションで確認
- [ ] OpenSSL/OpenSSH のバージョンが既知の脆弱性に対してパッチ適用済みか確認
