# セキュリティ設計書

## 概要

本ドキュメントは、FreeBSD オペレーティングシステムのソースツリー（freebsd-src-main）におけるセキュリティ設計を記述する。FreeBSD は多層防御（Defense in Depth）の原則に基づき、認証、認可、暗号化、アクセス制御、監査ログ、ネットワークセキュリティの各領域にわたるセキュリティ機構を実装している。主要なセキュリティコンポーネントとして、PAM（Pluggable Authentication Modules）による認証基盤、TrustedBSD MAC Framework による強制アクセス制御、Capsicum によるケーパビリティベースのサンドボックス、BSM（Basic Security Module）による監査、OpenCrypto フレームワークによるカーネル暗号化、IPsec/PF/IPFW によるネットワークセキュリティ、そして Jail によるプロセス隔離を備えている。

## 認証設計

### 認証方式

FreeBSD はユーザー認証に PAM（Pluggable Authentication Modules）フレームワークを採用している。PAM は `lib/libpam/` 配下に実装されており、モジュール式のアーキテクチャにより認証方式を柔軟に構成可能である。

**主要な PAM モジュール:**

| モジュール | 機能 |
| --- | --- |
| pam_unix | 標準 UNIX パスワード認証（/etc/passwd, /etc/master.passwd） |
| pam_krb5 | Kerberos V5 認証 |
| pam_ssh | SSH 鍵ベース認証 |
| pam_radius | RADIUS サーバーによるリモート認証 |
| pam_tacplus | TACACS+ サーバーによるリモート認証 |
| pam_deny | 認証を常に拒否（セキュリティフォールバック） |
| pam_permit | 認証を常に許可（テスト用途） |
| pam_rootok | root ユーザーの認証バイパス |
| pam_securetty | セキュアターミナルからのみ root ログインを許可 |
| pam_nologin | /etc/nologin による一般ユーザーログイン制限 |
| pam_passwdqc | パスワード品質チェック |
| pam_login_access | /etc/login.access によるアクセス制御 |
| pam_lastlog | 最終ログイン情報の記録 |
| pam_group | グループベースのアクセス制御 |

**PAM 設定ファイル:** `lib/libpam/pam.d/` 配下にサービスごとの PAM 構成ファイルが配置される。

**Kerberos V5 認証:** `kerberos5/` および `crypto/heimdal/` に Heimdal Kerberos 実装が含まれ、チケットベースの認証を提供する。

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション有効期限 | サービス依存（PAM 構成による） | pam_lastlog でセッション開始/終了を記録 |
| セッション固定化対策 | PAM セッションモジュールによる制御 | pam_chroot でセッション環境を分離可能 |
| ログイン制限 | /etc/login.access, /etc/nologin | pam_login_access, pam_nologin モジュールで制御 |
| パスワード品質 | pam_passwdqc で強制 | パスワード長・複雑性ルールを設定可能 |

### パスワードハッシュ

パスワードの保存には `lib/libcrypt/` の crypt(3) ライブラリを使用する。以下のハッシュアルゴリズムをサポートしている。

| アルゴリズム | プレフィックス | 実装ファイル |
| --- | --- | --- |
| MD5 | `$1$` | crypt-md5.c |
| Blowfish (bcrypt) | `$2` | HAS_BLOWFISH 条件付き |
| NTHash | `$3$` | crypt-nthash.c |
| SHA-256 | `$5$` | crypt-sha256.c |
| SHA-512 | `$6$` | crypt-sha512.c |
| DES | `_` | HAS_DES 条件付き（レガシー互換） |

## 認可設計

### 権限体系

FreeBSD は以下の多層的な権限モデルを実装している。

| ロール/機構 | 権限 | 説明 |
| --- | --- | --- |
| スーパーユーザー (uid=0) | 全権限（suser_enabled 制御下） | `security.bsd.suser_enabled` sysctl で有効/無効化可能 |
| 一般ユーザー | DAC（任意アクセス制御） | 標準 UNIX パーミッション（owner/group/other） |
| Jail 内プロセス | 制限付き特権 | `prison_priv_check()` により jail 内の特権を制限 |
| MAC ラベル付きプロセス | ポリシーベース | TrustedBSD MAC ポリシーに基づく強制アクセス制御 |

### アクセス制御

FreeBSD は3つのアクセス制御モデルを階層的に実装している。

**1. DAC（任意アクセス制御）**
- 標準 UNIX パーミッションモデル（rwx ビット、owner/group/other）
- `kern_prot.c` にシステムコール実装（setuid, setgid, seteuid 等）
- ACL（アクセス制御リスト）拡張対応

**2. MAC（強制アクセス制御）-- TrustedBSD MAC Framework**
- `sys/security/mac/mac_framework.c` に実装されたカーネル拡張フレームワーク
- 3つのプログラミングインターフェースを提供:
  - カーネル MAC インターフェース（mac_framework.h）
  - MAC ポリシーモジュールインターフェース（mac_policy.h）
  - ユーザー MAC API（mac.h）
- ポリシーモジュールによるラベルベースのセキュリティ判断

**主要な MAC ポリシーモジュール:**

| モジュール | 種別 | 説明 |
| --- | --- | --- |
| mac_biba | 完全性ポリシー | Biba 固定ラベル強制完全性ポリシー |
| mac_lomac | 完全性ポリシー | Low-Watermark MAC（動的完全性ポリシー） |
| mac_mls | 機密性ポリシー | Multi-Level Security（多段階セキュリティ） |
| mac_bsdextended | 拡張 DAC | ファイルシステムファイアウォール |
| mac_portacl | ネットワーク | ポートバインド制御 |
| mac_seeotheruids | プロセス可視性 | 他ユーザープロセスの可視性制御 |
| mac_partition | プロセス分離 | パーティションベースのプロセス分離 |
| mac_ifoff | ネットワーク | ネットワークインターフェースのシャットダウン制御 |
| mac_veriexec | 実行検証 | 署名に基づく実行ファイル検証（SHA1/SHA256/SHA384/SHA512） |
| mac_do | 特権昇格制御 | 特権昇格の制御 |

**3. Capsicum（ケーパビリティモード）**
- `sys/kern/sys_capability.c` に実装
- ファイルディスクリプタに対するケーパビリティ権限の精密制御
- プロセスのサンドボックス化（グローバル名前空間へのアクセス制限）
- `cap_rights_limit()` によるケーパビリティ権限の縮小のみ許可（拡大不可）
- `lib/libcapsicum/` および `lib/libcasper/` にユーザーランドライブラリ

**4. Jail（プロセス隔離）**
- `sys/kern/kern_jail.c` に実装
- OS レベルの仮想化によるプロセス隔離
- `prison_priv_check()` による jail 内の特権制限
- `PR_ALLOW_SUSER` フラグで jail 内のスーパーユーザー権限を制御
- ネットワーク、ファイルシステム、プロセス空間の分離

**5. 特権チェック機構（priv(9)）**
- `sys/kern/kern_priv.c` の `priv_check_cred()` で集中管理
- 処理フロー:
  1. MAC ポリシーによる拒否チェック（`mac_priv_check()`）
  2. Jail ポリシーによる制限チェック（`prison_priv_check()`）
  3. suser_enabled 判定（uid=0 の特権付与）
  4. MAC ポリシーによる許可チェック（`mac_priv_grant()`）
  5. デフォルトは拒否（EPERM）
- DTrace プローブ（`priv__ok`, `priv__err`）による特権チェックのトレース対応

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| IPsec | `sys/netipsec/` に実装。AH（認証ヘッダー）および ESP（暗号化セキュリティペイロード）プロトコルをサポート。鍵管理は `key.c` / `key_debug.c` で実装 |
| SSH | `crypto/openssh/` に OpenSSH を統合。認証方式として公開鍵、パスワード、Kerberos、PAM、GSSAPI をサポート |
| TLS/kTLS | `sys/opencrypto/ktls_ocf.c` にカーネル TLS オフロード実装。ユーザーランド処理のオーバーヘッドを軽減 |
| PF（パケットフィルタ） | `sys/netpfil/pf/` に実装。ステートフルパケットフィルタリング、NAT、トラフィックシェーピング |
| IPFW | `sys/netpfil/ipfw/` に実装。FreeBSD 固有のファイアウォール。パケットフィルタリング、NAT、トラフィック制御 |

## データセキュリティ

### 暗号化

**カーネル暗号化フレームワーク（OpenCrypto）:**

`sys/opencrypto/` に統一的なカーネル暗号化フレームワークが実装されている。

| 対象 | 暗号化方式 |
| --- | --- |
| 対称暗号（ブロック） | AES-CBC (`xform_aes_cbc.c`), AES-ICM/CTR (`xform_aes_icm.c`), AES-XTS (`xform_aes_xts.c`), Camellia (`xform_cml.c`) |
| 認証付き暗号（AEAD） | AES-GCM (`xform_gmac.c`), ChaCha20-Poly1305 (`xform_chacha20_poly1305.c`), AES-CBC-MAC (`xform_cbc_mac.c`) |
| ハッシュ/MAC | SHA-1 (`xform_sha1.c`), SHA-2 (SHA-256/384/512) (`xform_sha2.c`), RIPEMD-160 (`xform_rmd160.c`), GMAC (`xform_gmac.c`), Poly1305 (`xform_poly1305.c`) |
| 圧縮 | Deflate (`xform_deflate.c`) |

**ユーザーランド暗号化ライブラリ:**

| ライブラリ | 配置 | 用途 |
| --- | --- | --- |
| OpenSSL (libcrypto/libssl) | `crypto/openssl/`, `secure/lib/libcrypto/`, `secure/lib/libssl/` | TLS/SSL 通信、汎用暗号化処理 |
| libpkgecc | `secure/lib/libpkgecc/` | 楕円曲線暗号（パッケージ署名） |
| libssh | `secure/lib/libssh/` | SSH プロトコル実装 |
| libecc | `crypto/libecc/` | 軽量楕円曲線暗号ライブラリ |

### 機密情報管理

- パスワードハッシュは `/etc/master.passwd` に保存され、一般ユーザーからの読み取りは不可（root のみアクセス可）
- `/etc/passwd` にはハッシュを含まない公開情報のみ格納
- Kerberos チケットはユーザーごとの資格情報キャッシュに保存
- SSH 秘密鍵はユーザーホームディレクトリの `~/.ssh/` に保存（パーミッション 600）
- CA ルート証明書バンドルは `secure/caroot/` で管理
- 暗号化鍵の管理はサービス固有の設定に委譲

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| バッファオーバーフロー | Stack Smashing Protection (SSP)、ASLR（アドレス空間配置のランダム化）、W^X（書き込み不可かつ実行不可の同時保証） |
| 特権昇格 | priv(9) フレームワークによる集中的な特権チェック、MAC ポリシーによる強制制御、Capsicum サンドボックス |
| 不正な実行ファイル | mac_veriexec によるハッシュベースの実行検証（SHA-1, SHA-256, SHA-384, SHA-512） |
| ファイルシステム操作 | Capsicum ケーパビリティモードによるグローバル名前空間アクセスの制限、securelevel による変更制限 |
| プロセス間干渉 | Jail によるプロセス分離、mac_partition によるパーティション、mac_seeotheruids によるプロセス可視性制御 |
| ネットワーク攻撃 | PF/IPFW ファイアウォール、IPsec による通信暗号化/認証 |

## 監査ログ

FreeBSD は BSM（Basic Security Module）/ OpenBSM に基づく包括的な監査サブシステムを実装している。

**監査サブシステムの実装:**
- カーネル側: `sys/security/audit/` に実装
- ユーザーランド: `contrib/openbsm/` に OpenBSM ライブラリ・ツール群
- 監査デーモン: `usr.sbin/auditd/`

**監査イベントクラス:**

| ログ種別 | 記録内容 | クラスコード |
| --- | --- | --- |
| ファイル読み取り | ファイル読み取り操作 | fr (0x00000001) |
| ファイル書き込み | ファイル書き込み操作 | fw (0x00000002) |
| ファイル属性アクセス | ファイル属性の参照 | fa (0x00000004) |
| ファイル属性変更 | ファイル属性の変更 | fm (0x00000008) |
| ファイル作成 | ファイル作成操作 | fc (0x00000010) |
| ファイル削除 | ファイル削除操作 | fd (0x00000020) |
| ファイルクローズ | ファイルクローズ操作 | cl (0x00000040) |
| プロセス | プロセス操作（fork, exec, exit 等） | pc (0x00000080) |
| ネットワーク | ネットワーク操作 | nt (0x00000100) |
| IPC | プロセス間通信 | ip (0x00000200) |
| 非帰属イベント | 特定ユーザーに帰属しない操作 | na (0x00000400) |
| 管理操作 | システム管理操作 | ad (0x00000800) |
| ログイン/ログアウト | ログイン・ログアウトイベント | lo (0x00001000) |
| 認証・認可 | 認証および認可イベント | aa (0x00002000) |
| アプリケーション | アプリケーション固有イベント | ap (0x00004000) |
| ioctl | ioctl 操作 | io (0x20000000) |
| 実行 | プログラム実行 | ex (0x40000000) |
| その他 | 上記に分類されない操作 | ot (0x80000000) |

**デフォルト監査設定（audit_control）:**

| 設定項目 | 値 | 説明 |
| --- | --- | --- |
| dir | /var/audit | 監査トレイルの保存先ディレクトリ |
| dist | off | リモート配信の有効/無効 |
| flags | lo,aa | 監査対象イベントクラス（ログイン/ログアウト、認証/認可） |
| minfree | 5 | ファイルシステムの最小空き容量（%） |
| naflags | lo,aa | 非帰属イベントの監査フラグ |
| policy | cnt,argv | 監査ポリシー（カウント継続、引数記録） |
| filesz | 2M | 監査トレイルファイルの最大サイズ |
| expire-after | 10M | 監査トレイルの有効期限（累積サイズ） |

**監査サブシステムの機能:**
- システムコール単位の監査（`audit_syscall_enter()` / `audit_syscall_exit()`）
- DTrace 統合によるリアルタイム監査（`audit_dtrace_enabled`）
- 監査パイプ（`audit_pipe.c`）によるリアルタイムイベントストリーム
- キュー管理（高/低ウォーターマーク制御）による監査記録のバッファリング
- ディスク領域不足時のフェイルストップ/パニック制御（`audit_fail_stop`, `audit_panic_on_write_fail`）

## 備考

- FreeBSD のセキュリティアーキテクチャは「多層防御」の原則に基づき、DAC、MAC、Capsicum、Jail の各セキュリティ機構を組み合わせて使用することを想定している。
- TrustedBSD MAC Framework はモジュール式であり、システム要件に応じてポリシーモジュールをロード/アンロードできる。
- OpenCrypto フレームワークはハードウェアアクセラレーション対応であり、x86（AES-NI）および aarch64 プラットフォームでのハードウェア暗号化オフロードをサポートする。
- Capsicum は FreeBSD 固有のセキュリティ機構であり、アプリケーションレベルのサンドボックス化に適している。
- セキュリティ関連の sysctl パラメータ（`security.bsd.*`）により、実行時にセキュリティポリシーの調整が可能である。
