---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **性能テストの実施タイミング**：明示的な根拠なし（推定による記述）
  2. **カバレッジ目標の方針**：明示的なポリシードキュメントが確認できない
  3. **受入テストの担当**：リリースエンジニアリングチームの記述は推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/README` - FreeBSD テストスイートの概要説明
- E-02: `tests/Kyuafile` - Kyuaテストランナー設定（自動探索ロジック）
- E-03: `tests/Makefile` - テストビルド設定（KYUAFILE=yes、SUBDIR構成）
- E-04: `tests/conftest.py` - pytest/ATF統合プラグイン設定
- E-05: `tests/atf_python/atf_pytest.py` - ATF pytest ハンドラ実装
- E-06: `tests/atf_python/ktest.py` - カーネルテスト（ktest）フレームワーク
- E-07: `tests/ci/Makefile` - CI テストインフラ設定（bhyve/QEMU、smoke/full）
- E-08: `.github/workflows/checklist.yml` - PR チェックリスト ワークフロー
- E-09: `.github/workflows/style.yml` - スタイルチェッカー ワークフロー
- E-10: `.github/workflows/cross-bootstrap-tools.yml` - クロスビルド検証ワークフロー
- E-11: `tests/Makefile.inc0` - MK_CHECK_USE_SANDBOX=yes 設定
- E-12: `tests/freebsd_test_suite/macros.h` - テストスイート共通マクロ
- E-13: `tests/ci/Makefile.amd64`, `Makefile.aarch64` 等 - アーキテクチャ別CI設定
- E-14: `tests/sys/` ディレクトリ構成 - 38サブシステムのテストディレクトリ
- E-15: `tests/examples/test_examples.py`, `test_ktest_example.py` - テスト例

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ATF および Kyua がテストフレームワークの中心である | E-01, E-02, E-03 | ○ |
| C-02 | テストコードはシェルスクリプト約351、C約220、Python約109ファイルで構成 | ファイルカウント結果 | ○ |
| C-03 | Kyuafile による自動テスト探索機能がある | E-02 | ○ |
| C-04 | テスト階層は /usr/src/ と同一構造で /usr/tests/ に配置される | E-01 | ○ |
| C-05 | pytest が ATF との統合プラグインを通じて利用される | E-04, E-05 | ○ |
| C-06 | ktest フレームワークによるカーネルモジュールテストが存在する | E-06 | ○ |
| C-07 | CI環境はbhyve（amd64/i386）とQEMU（他アーキテクチャ）で構成 | E-07 | ○ |
| C-08 | CI テストタイプとして smoke と full が存在する | E-07 | ○ |
| C-09 | サポートアーキテクチャは amd64, aarch64, armv7, powerpc64, powerpc64le, riscv64 | E-07, E-13 | ○ |
| C-10 | CI タイムアウトはデフォルト5400秒 | E-07 | ○ |
| C-11 | メタデータTARファイル（512MB）でテスト結果収集 | E-07 | ○ |
| C-12 | GitHub Actions で checklist, style, cross-build の3ワークフローが存在 | E-08, E-09, E-10 | ○ |
| C-13 | checklist.yml は Signed-off-by 行を検証する | E-08 | ○ |
| C-14 | style.yml は C/C++/アセンブリファイルの style(9) チェックを行う | E-09 | ○ |
| C-15 | cross-build は ubuntu-22.04, ubuntu-24.04, macOS-latest で実行される | E-10 | ○ |
| C-16 | cross-build は clang-15/clang-18 を使用する | E-10 | ○ |
| C-17 | MK_TESTS ビルドオプションでテストスイートが制御される | E-01 | ○ |
| C-18 | サンドボックス実行がデフォルトで有効 | E-11 | ○ |
| C-19 | pytest マーカーとして require_user, require_arch 等が定義されている | E-04 | ○ |
| C-20 | CODEOWNERS によるファイルオーナー通知がある | E-08 | ○ |
| C-21 | path-rules.txt による変更注意事項の自動表示がある | E-08 | ○ |
| C-22 | tests/freebsd_test_suite/macros.h に共通マクロが定義されている | E-12 | ○ |
| C-23 | 追加ディスクは最大5台、各128MB | E-07 | ○ |
| C-24 | VM メモリは最小4GB、16GB以上で8GB割当 | E-07 | ○ |
| C-25 | META_MODE（filemon）によるインクリメンタルビルドが利用可能 | E-07 | ○ |
| C-26 | contrib ライブラリ（openssh, krb5, libecc）に対するCIFuzzファジングテストがある | E-10（.github/workflows参照） | ○ |
| C-27 | ci-buildworld -> ci-buildkernel -> ci-buildimage の順でビルドされる | E-07 | ○ |
| C-28 | 性能テストはリリース前・必要に応じて実施される | **根拠なし** | △ |
| C-29 | カバレッジ目標は明示的に設定されていない（品質重視方針） | **根拠なし** | △ |
| C-30 | 受入テストはリリースエンジニアリングチームが担当する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28：性能テストの実施タイミングについて明示的な定義ドキュメントが確認できない。プロジェクトの一般的慣行からの推定である。
  - 候補：リリースエンジニアリングドキュメント / FreeBSD Wiki / メーリングリスト議論
- C-29：カバレッジ目標の方針について公式なポリシードキュメントが確認できない。テスト設定ファイルにカバレッジ関連の設定が見当たらないことからの推定である。
  - 候補：FreeBSD Developer's Handbook / テスト方針に関するメーリングリスト議論
- C-30：受入テストの担当組織について明示的な定義が確認できない。FreeBSD リリースプロセスの一般的知識からの推定である。
  - 候補：release/ ディレクトリ内のドキュメント / FreeBSD リリースエンジニアリング文書

## 5) リスクフラグ（レビュー観点）
- 0: テストフレームワーク・ツールの特定（ATF/Kyua/pytest）- 十分な根拠あり
- 0: CI/CDパイプラインの構成 - ワークフローファイルから直接確認済み
- 0: テスト階層構造 - README および Makefile から直接確認済み
- 1: テストレベルの区分と担当 - テストコードの実態から推定した部分あり
- 1: カバレッジ目標 - 明示的ポリシーが不在のため推定
- 0: テストデータ管理方針 - conftest.py および CI Makefile から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ATF/Kyua がテストフレームワークの主軸であることは正しいか
- [ ] CI テストインフラ（bhyve/QEMU）の構成記述は実態と合致しているか
- [ ] サポートアーキテクチャの一覧に漏れ・誤りはないか
- [ ] GitHub Actions ワークフローの記述が最新の状態と一致しているか
- [ ] テストスイートの38サブシステム一覧に漏れはないか
- [ ] 性能テスト・受入テストに関する記述が組織の実態と合致しているか
- [ ] カバレッジ目標に関する記述（目標値未設定）は方針として正しいか
